/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsdl.xml;

import com.ibm.wsdl.Constants;
import com.ibm.wsdl.extensions.schema.SchemaConstants;
import com.ibm.wsdl.util.StringUtils;
import com.ibm.wsdl.util.xml.DOMUtils;
import com.ibm.wsdl.util.xml.QNameUtils;
import com.ibm.wsdl.util.xml.XPathUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.AttributeExtensible;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WSDLReaderImplOriginal
implements WSDLReader {
    private static final List STYLE_ONE_WAY = Arrays.asList("input");
    private static final List STYLE_REQUEST_RESPONSE = Arrays.asList("input", "output");
    private static final List STYLE_SOLICIT_RESPONSE = Arrays.asList("output", "input");
    private static final List STYLE_NOTIFICATION = Arrays.asList("output");
    protected boolean verbose = true;
    protected boolean importDocuments = true;
    protected ExtensionRegistry extReg = null;
    protected String factoryImplName = null;
    protected WSDLLocator loc = null;
    protected WSDLFactory factory = null;
    protected Map allSchemas = new Hashtable();

    public void setFeature(String string, boolean bl) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        if (string.equals("javax.wsdl.verbose")) {
            this.verbose = bl;
        } else if (string.equals("javax.wsdl.importDocuments")) {
            this.importDocuments = bl;
        } else {
            throw new IllegalArgumentException("Feature name '" + string + "' not recognized.");
        }
    }

    public boolean getFeature(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Feature name must not be null.");
        }
        if (string.equals("javax.wsdl.verbose")) {
            return this.verbose;
        }
        if (string.equals("javax.wsdl.importDocuments")) {
            return this.importDocuments;
        }
        throw new IllegalArgumentException("Feature name '" + string + "' not recognized.");
    }

    public void setExtensionRegistry(ExtensionRegistry extensionRegistry) {
        this.extReg = extensionRegistry;
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.extReg;
    }

    protected WSDLFactory getWSDLFactory() throws WSDLException {
        if (this.factory == null) {
            this.factory = this.factoryImplName != null ? WSDLFactory.newInstance((String)this.factoryImplName) : WSDLFactory.newInstance();
        }
        return this.factory;
    }

    public void setFactoryImplName(String string) throws UnsupportedOperationException {
        if (this.factoryImplName == null && string != null || this.factoryImplName != null && !this.factoryImplName.equals(string)) {
            this.factory = null;
            this.factoryImplName = string;
        }
    }

    public String getFactoryImplName() {
        return this.factoryImplName;
    }

    protected Definition parseDefinitions(String string, Element element, Map hashtable) throws WSDLException {
        WSDLReaderImplOriginal.checkElementName(element, Constants.Q_ELEM_DEFINITIONS);
        WSDLFactory wSDLFactory = this.getWSDLFactory();
        Definition definition = wSDLFactory.newDefinition();
        if (this.extReg != null) {
            definition.setExtensionRegistry(this.extReg);
        }
        String string2 = DOMUtils.getAttribute(element, "name");
        String string3 = DOMUtils.getAttribute(element, "targetNamespace");
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (hashtable == null) {
            hashtable = new Hashtable<String, Definition>();
        }
        if (string != null) {
            definition.setDocumentBaseURI(string);
            hashtable.put(string, definition);
        }
        if (string2 != null) {
            definition.setQName(new QName(string3, string2));
        }
        if (string3 != null) {
            definition.setTargetNamespace(string3);
        }
        int n2 = namedNodeMap.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Attr attr = (Attr)namedNodeMap.item(i2);
            String string4 = attr.getNamespaceURI();
            String string5 = attr.getLocalName();
            String string6 = attr.getValue();
            if (string4 == null || !string4.equals("http://www.w3.org/2000/xmlns/")) continue;
            if (string5 != null && !string5.equals("xmlns")) {
                definition.addNamespace(string5, string6);
                continue;
            }
            definition.addNamespace(null, string6);
        }
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_IMPORT, (Node)element2)) {
                definition.addImport(this.parseImport(element2, definition, hashtable));
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                definition.setDocumentationElement(element2);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_TYPES, (Node)element2)) {
                definition.setTypes(this.parseTypes(element2, definition));
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_MESSAGE, (Node)element2)) {
                definition.addMessage(this.parseMessage(element2, definition));
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_PORT_TYPE, (Node)element2)) {
                definition.addPortType(this.parsePortType(element2, definition));
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_BINDING, (Node)element2)) {
                definition.addBinding(this.parseBinding(element2, definition));
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_SERVICE, (Node)element2)) {
                definition.addService(this.parseService(element2, definition));
            } else {
                definition.addExtensibilityElement(this.parseExtensibilityElement(Definition.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        this.parseExtensibilityAttributes(element, Definition.class, (AttributeExtensible)definition, definition);
        return definition;
    }

    protected Import parseImport(Element element, Definition definition, Map map) throws WSDLException {
        Object object;
        Object object2;
        Import import_;
        block25: {
            import_ = definition.createImport();
            try {
                object2 = DOMUtils.getAttribute(element, "namespace");
                object = DOMUtils.getAttribute(element, "location");
                String string = null;
                if (object2 != null) {
                    import_.setNamespaceURI((String)object2);
                }
                if (object == null) break block25;
                import_.setLocationURI((String)object);
                if (!this.importDocuments) break block25;
                try {
                    Object object3;
                    string = definition.getDocumentBaseURI();
                    Definition definition2 = null;
                    InputStream inputStream = null;
                    InputSource inputSource = null;
                    URL uRL = null;
                    if (this.loc != null) {
                        inputSource = this.loc.getImportInputSource(string, (String)object);
                        object3 = this.loc.getLatestImportURI();
                        definition2 = (Definition)map.get(object3);
                        inputSource.setSystemId((String)object3);
                    } else {
                        object3 = string != null ? StringUtils.getURL(null, (String)string) : null;
                        uRL = StringUtils.getURL((URL)object3, (String)object);
                        definition2 = (Definition)map.get(uRL.toString());
                        if (definition2 == null && (inputStream = StringUtils.getContentAsInputStream((URL)uRL)) != null) {
                            inputSource = new InputSource(inputStream);
                            inputSource.setSystemId(uRL.toString());
                        }
                    }
                    if (definition2 == null) {
                        Object object4;
                        Element element2;
                        if (inputSource == null) {
                            throw new WSDLException("OTHER_ERROR", "Unable to locate imported document at '" + (String)object + "'" + (string == null ? "." : ", relative to '" + string + "'."));
                        }
                        object3 = WSDLReaderImplOriginal.getDocument(inputSource, inputSource.getSystemId());
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (QNameUtils.matches((QName)Constants.Q_ELEM_DEFINITIONS, (Node)(element2 = object3.getDocumentElement()))) {
                            if (this.verbose) {
                                System.out.println("Retrieving document at '" + (String)object + "'" + (string == null ? "." : ", relative to '" + string + "'."));
                            }
                            object4 = this.loc != null ? this.loc.getLatestImportURI() : (uRL != null ? uRL.toString() : object);
                            definition2 = this.readWSDL((String)object4, element2, map);
                        } else {
                            object4 = QNameUtils.newQName((Node)element2);
                            if (SchemaConstants.XSD_QNAME_LIST.contains(object4)) {
                                if (this.verbose) {
                                    System.out.println("Retrieving schema wsdl:imported from '" + (String)object + "'" + (string == null ? "." : ", relative to '" + string + "'."));
                                }
                                WSDLFactory wSDLFactory = this.getWSDLFactory();
                                definition2 = wSDLFactory.newDefinition();
                                if (this.extReg != null) {
                                    definition2.setExtensionRegistry(this.extReg);
                                }
                                Object object5 = this.loc != null ? this.loc.getLatestImportURI() : (uRL != null ? uRL.toString() : object);
                                definition2.setDocumentBaseURI((String)object5);
                                Types types = definition2.createTypes();
                                types.addExtensibilityElement(this.parseSchema(Types.class, element2, definition2));
                                definition2.setTypes(types);
                            }
                        }
                    }
                    if (definition2 != null) {
                        import_.setDefinition(definition2);
                    }
                }
                catch (WSDLException wSDLException) {
                    throw wSDLException;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + (String)object + (string == null ? "'." : "', relative to '" + string + "'"), (Throwable)exception);
                }
            }
            catch (WSDLException wSDLException) {
                if (wSDLException.getLocation() == null) {
                    wSDLException.setLocation(XPathUtils.getXPathExprFromNode((Node)element));
                } else {
                    String string = XPathUtils.getXPathExprFromNode((Node)element) + wSDLException.getLocation();
                    wSDLException.setLocation(string);
                }
                throw wSDLException;
            }
        }
        object2 = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations((NamedNodeMap)object2, definition);
        object = DOMUtils.getFirstChildElement(element);
        while (object != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)object)) {
                import_.setDocumentationElement((Element)object);
            } else {
                import_.addExtensibilityElement(this.parseExtensibilityElement(Import.class, (Element)object, definition));
            }
            object = DOMUtils.getNextSiblingElement((Element)object);
        }
        this.parseExtensibilityAttributes(element, Import.class, (AttributeExtensible)import_, definition);
        return import_;
    }

    protected Types parseTypes(Element element, Definition definition) throws WSDLException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations(namedNodeMap, definition);
        Types types = definition.createTypes();
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            QName qName = QNameUtils.newQName((Node)element2);
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                types.setDocumentationElement(element2);
            } else if (SchemaConstants.XSD_QNAME_LIST.contains(qName)) {
                types.addExtensibilityElement(this.parseSchema(Types.class, element2, definition));
            } else {
                types.addExtensibilityElement(this.parseExtensibilityElement(Types.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        this.parseExtensibilityAttributes(element, Types.class, (AttributeExtensible)types, definition);
        return types;
    }

    protected ExtensibilityElement parseSchema(Class clazz, Element element, Definition definition) throws WSDLException {
        Object var4_4 = null;
        ExtensionRegistry extensionRegistry = null;
        try {
            extensionRegistry = definition.getExtensionRegistry();
            if (extensionRegistry == null) {
                throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionRegistry set for this Definition, so unable to deserialize a '" + var4_4 + "' element in the " + "context of a '" + clazz.getName() + "'.");
            }
            return this.parseSchema(clazz, element, definition, extensionRegistry);
        }
        catch (WSDLException wSDLException) {
            if (wSDLException.getLocation() == null) {
                wSDLException.setLocation(XPathUtils.getXPathExprFromNode((Node)element));
            }
            throw wSDLException;
        }
    }

    protected ExtensibilityElement parseSchema(Class clazz, Element element, Definition definition, ExtensionRegistry extensionRegistry) throws WSDLException {
        Schema schema = null;
        SchemaReference schemaReference = null;
        try {
            QName qName = QNameUtils.newQName((Node)element);
            ExtensionDeserializer extensionDeserializer = extensionRegistry.queryDeserializer(clazz, qName);
            ExtensibilityElement extensibilityElement = extensionDeserializer.unmarshall(clazz, qName, element, definition, extensionRegistry);
            if (!(extensibilityElement instanceof Schema)) {
                return extensibilityElement;
            }
            schema = (Schema)extensibilityElement;
            if (schema.getDocumentBaseURI() != null) {
                this.allSchemas.put(schema.getDocumentBaseURI(), schema);
            }
            ArrayList arrayList = new ArrayList();
            Collection collection = schema.getImports().values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.addAll((Collection)iterator.next());
            }
            arrayList.addAll(schema.getIncludes());
            arrayList.addAll(schema.getRedefines());
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                try {
                    Serializable serializable;
                    Object object;
                    Object object2;
                    schemaReference = (SchemaReference)listIterator.next();
                    if (schemaReference.getSchemaLocationURI() == null) continue;
                    if (this.verbose) {
                        System.out.println("Retrieving schema at '" + schemaReference.getSchemaLocationURI() + (schema.getDocumentBaseURI() == null ? "'." : "', relative to '" + schema.getDocumentBaseURI() + "'."));
                    }
                    InputStream inputStream = null;
                    InputSource inputSource = null;
                    Schema schema2 = null;
                    String string = null;
                    if (this.loc != null) {
                        inputSource = this.loc.getImportInputSource(schema.getDocumentBaseURI(), schemaReference.getSchemaLocationURI());
                        if (inputSource == null) {
                            throw new WSDLException("OTHER_ERROR", "Unable to locate with a locator the schema referenced at '" + schemaReference.getSchemaLocationURI() + "' relative to document base '" + schema.getDocumentBaseURI() + "'");
                        }
                        string = this.loc.getLatestImportURI();
                        schema2 = (Schema)this.allSchemas.get(string);
                    } else {
                        object2 = schema.getDocumentBaseURI();
                        object = object2 != null ? StringUtils.getURL(null, (String)object2) : null;
                        serializable = StringUtils.getURL((URL)object, (String)schemaReference.getSchemaLocationURI());
                        string = serializable.toExternalForm();
                        schema2 = (Schema)this.allSchemas.get(string);
                        if (schema2 == null) {
                            inputStream = StringUtils.getContentAsInputStream((URL)serializable);
                            if (inputStream != null) {
                                inputSource = new InputSource(inputStream);
                            }
                            if (inputSource == null) {
                                throw new WSDLException("OTHER_ERROR", "Unable to locate with a url the document referenced at '" + schemaReference.getSchemaLocationURI() + "'" + (object2 == null ? "." : ", relative to '" + (String)object2 + "'."));
                            }
                        }
                    }
                    if (schema2 == null) {
                        inputSource.setSystemId(string);
                        object2 = WSDLReaderImplOriginal.getDocument(inputSource, string);
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (SchemaConstants.XSD_QNAME_LIST.contains(serializable = QNameUtils.newQName((Node)(object = object2.getDocumentElement())))) {
                            WSDLFactory wSDLFactory = this.getWSDLFactory();
                            Definition definition2 = wSDLFactory.newDefinition();
                            definition2.setDocumentBaseURI(string);
                            schema2 = (Schema)this.parseSchema(clazz, (Element)object, definition2, extensionRegistry);
                        }
                    }
                    schemaReference.setReferencedSchema(schema2);
                }
                catch (WSDLException wSDLException) {
                    throw wSDLException;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new WSDLException("OTHER_ERROR", "An error occurred trying to resolve schema referenced at '" + schemaReference.getSchemaLocationURI() + "'" + (schema.getDocumentBaseURI() == null ? "." : ", relative to '" + schema.getDocumentBaseURI() + "'."), (Throwable)exception);
                }
            }
            return schema;
        }
        catch (WSDLException wSDLException) {
            if (wSDLException.getLocation() == null) {
                wSDLException.setLocation(XPathUtils.getXPathExprFromNode((Node)element));
            } else {
                String string = XPathUtils.getXPathExprFromNode((Node)element) + wSDLException.getLocation();
                wSDLException.setLocation(string);
            }
            throw wSDLException;
        }
    }

    protected Binding parseBinding(Element element, Definition definition) throws WSDLException {
        Object object;
        Binding binding = null;
        List list = DOMUtils.getAttributes(element);
        String string = DOMUtils.getAttribute(element, "name", list);
        QName qName = WSDLReaderImplOriginal.getQualifiedAttributeValue(element, "type", "binding", definition, list);
        PortType portType = null;
        if (string != null) {
            object = new QName(definition.getTargetNamespace(), string);
            binding = definition.getBinding((QName)object);
            if (binding == null) {
                binding = definition.createBinding();
                binding.setQName((QName)object);
            }
        } else {
            binding = definition.createBinding();
        }
        binding.setUndefined(false);
        if (qName != null) {
            portType = definition.getPortType(qName);
            if (portType == null) {
                portType = definition.createPortType();
                portType.setQName(qName);
                definition.addPortType(portType);
            }
            binding.setPortType(portType);
        }
        object = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations((NamedNodeMap)object, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                binding.setDocumentationElement(element2);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_OPERATION, (Node)element2)) {
                binding.addBindingOperation(this.parseBindingOperation(element2, portType, definition));
            } else {
                binding.addExtensibilityElement(this.parseExtensibilityElement(Binding.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return binding;
    }

    protected BindingOperation parseBindingOperation(Element element, PortType portType, Definition definition) throws WSDLException {
        BindingOperation bindingOperation = definition.createBindingOperation();
        List list = DOMUtils.getAttributes(element);
        String string = DOMUtils.getAttribute(element, "name", list);
        if (string != null) {
            bindingOperation.setName(string);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations(namedNodeMap, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                bindingOperation.setDocumentationElement(element2);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_INPUT, (Node)element2)) {
                bindingOperation.setBindingInput(this.parseBindingInput(element2, definition));
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_OUTPUT, (Node)element2)) {
                bindingOperation.setBindingOutput(this.parseBindingOutput(element2, definition));
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_FAULT, (Node)element2)) {
                bindingOperation.addBindingFault(this.parseBindingFault(element2, definition));
            } else {
                bindingOperation.addExtensibilityElement(this.parseExtensibilityElement(BindingOperation.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        if (portType != null) {
            String string2;
            BindingInput bindingInput = bindingOperation.getBindingInput();
            BindingOutput bindingOutput = bindingOperation.getBindingOutput();
            String string3 = bindingInput != null ? (bindingInput.getName() != null ? bindingInput.getName() : ":none") : (string2 = null);
            String string4 = bindingOutput != null ? (bindingOutput.getName() != null ? bindingOutput.getName() : ":none") : null;
            Operation operation = portType.getOperation(string, string2, string4);
            if (operation == null) {
                if (":none".equals(string2) && ":none".equals(string4)) {
                    operation = portType.getOperation(string, null, null);
                } else if (":none".equals(string2)) {
                    operation = portType.getOperation(string, null, string4);
                } else if (":none".equals(string4)) {
                    operation = portType.getOperation(string, string2, null);
                }
            }
            if (operation == null) {
                Input input = definition.createInput();
                Output output = definition.createOutput();
                operation = definition.createOperation();
                operation.setName(string);
                input.setName(string2);
                output.setName(string4);
                operation.setInput(input);
                operation.setOutput(output);
                portType.addOperation(operation);
            }
            bindingOperation.setOperation(operation);
        }
        this.parseExtensibilityAttributes(element, BindingOperation.class, (AttributeExtensible)bindingOperation, definition);
        return bindingOperation;
    }

    protected BindingInput parseBindingInput(Element element, Definition definition) throws WSDLException {
        BindingInput bindingInput = definition.createBindingInput();
        List list = DOMUtils.getAttributes(element);
        String string = DOMUtils.getAttribute(element, "name", list);
        if (string != null) {
            bindingInput.setName(string);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations(namedNodeMap, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                bindingInput.setDocumentationElement(element2);
            } else {
                bindingInput.addExtensibilityElement(this.parseExtensibilityElement(BindingInput.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return bindingInput;
    }

    protected BindingOutput parseBindingOutput(Element element, Definition definition) throws WSDLException {
        BindingOutput bindingOutput = definition.createBindingOutput();
        List list = DOMUtils.getAttributes(element);
        String string = DOMUtils.getAttribute(element, "name", list);
        if (string != null) {
            bindingOutput.setName(string);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations(namedNodeMap, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                bindingOutput.setDocumentationElement(element2);
            } else {
                bindingOutput.addExtensibilityElement(this.parseExtensibilityElement(BindingOutput.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        return bindingOutput;
    }

    protected BindingFault parseBindingFault(Element element, Definition definition) throws WSDLException {
        BindingFault bindingFault = definition.createBindingFault();
        List list = DOMUtils.getAttributes(element);
        String string = DOMUtils.getAttribute(element, "name", list);
        if (string != null) {
            bindingFault.setName(string);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations(namedNodeMap, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                bindingFault.setDocumentationElement(element2);
            } else {
                bindingFault.addExtensibilityElement(this.parseExtensibilityElement(BindingFault.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        this.parseExtensibilityAttributes(element, BindingFault.class, (AttributeExtensible)bindingFault, definition);
        return bindingFault;
    }

    protected Message parseMessage(Element element, Definition definition) throws WSDLException {
        Object object;
        Message message = null;
        List list = DOMUtils.getAttributes(element);
        String string = DOMUtils.getAttribute(element, "name", list);
        if (string != null) {
            object = new QName(definition.getTargetNamespace(), string);
            message = definition.getMessage((QName)object);
            if (message == null) {
                message = definition.createMessage();
                message.setQName((QName)object);
            }
        } else {
            message = definition.createMessage();
        }
        message.setUndefined(false);
        object = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations((NamedNodeMap)object, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                message.setDocumentationElement(element2);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_PART, (Node)element2)) {
                message.addPart(this.parsePart(element2, definition));
            } else {
                message.addExtensibilityElement(this.parseExtensibilityElement(Message.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        this.parseExtensibilityAttributes(element, Message.class, (AttributeExtensible)message, definition);
        return message;
    }

    protected Part parsePart(Element element, Definition definition) throws WSDLException {
        Part part = definition.createPart();
        String string = DOMUtils.getAttribute(element, "name");
        QName qName = WSDLReaderImplOriginal.getQualifiedAttributeValue(element, "element", "message", definition);
        QName qName2 = WSDLReaderImplOriginal.getQualifiedAttributeValue(element, "type", "message", definition);
        if (string != null) {
            part.setName(string);
        }
        if (qName != null) {
            part.setElementName(qName);
        }
        if (qName2 != null) {
            part.setTypeName(qName2);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations(namedNodeMap, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                part.setDocumentationElement(element2);
            } else {
                part.addExtensibilityElement(this.parseExtensibilityElement(Part.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        this.parseExtensibilityAttributes(element, Part.class, (AttributeExtensible)part, definition);
        return part;
    }

    protected void parseExtensibilityAttributes(Element element, Class clazz, AttributeExtensible attributeExtensible, Definition definition) throws WSDLException {
        List list = attributeExtensible.getNativeAttributeNames();
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            Attr attr = (Attr)namedNodeMap.item(i2);
            String string = attr.getLocalName();
            String string2 = attr.getNamespaceURI();
            String string3 = attr.getPrefix();
            QName qName = new QName(string2, string);
            if (string2 != null && !string2.equals("http://schemas.xmlsoap.org/wsdl/")) {
                if (string2.equals("http://www.w3.org/2000/xmlns/")) continue;
                DOMUtils.registerUniquePrefix(string3, string2, definition);
                object = attr.getValue();
                int n3 = -1;
                ExtensionRegistry extensionRegistry = definition.getExtensionRegistry();
                if (extensionRegistry != null) {
                    n3 = extensionRegistry.queryExtensionAttributeType(clazz, qName);
                }
                Object object2 = this.parseExtensibilityAttribute(element, n3, (String)object, definition);
                attributeExtensible.setExtensionAttribute(qName, object2);
                continue;
            }
            if (list.contains(string)) continue;
            object = new WSDLException("INVALID_WSDL", "Encountered illegal extension attribute '" + qName + "'. Extension " + "attributes must be in " + "a namespace other than " + "WSDL's.");
            object.setLocation(XPathUtils.getXPathExprFromNode((Node)element));
            throw object;
        }
    }

    protected Object parseExtensibilityAttribute(Element element, int n2, String string, Definition definition) throws WSDLException {
        if (n2 == 1) {
            return DOMUtils.getQName(string, element, definition);
        }
        if (n2 == 2) {
            return StringUtils.parseNMTokens((String)string);
        }
        if (n2 == 3) {
            List list = StringUtils.parseNMTokens((String)string);
            int n3 = list.size();
            Vector<QName> vector = new Vector<QName>(n3);
            for (int i2 = 0; i2 < n3; ++i2) {
                String string2 = (String)list.get(i2);
                QName qName = DOMUtils.getQName(string2, element, definition);
                vector.add(qName);
            }
            return vector;
        }
        if (n2 == 0) {
            return string;
        }
        QName qName = null;
        try {
            qName = DOMUtils.getQName(string, element, definition);
        }
        catch (WSDLException wSDLException) {
            qName = new QName(string);
        }
        return qName;
    }

    protected PortType parsePortType(Element element, Definition definition) throws WSDLException {
        Object object;
        PortType portType = null;
        String string = DOMUtils.getAttribute(element, "name");
        if (string != null) {
            object = new QName(definition.getTargetNamespace(), string);
            portType = definition.getPortType((QName)object);
            if (portType == null) {
                portType = definition.createPortType();
                portType.setQName((QName)object);
            }
        } else {
            portType = definition.createPortType();
        }
        portType.setUndefined(false);
        object = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations((NamedNodeMap)object, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                portType.setDocumentationElement(element2);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_OPERATION, (Node)element2)) {
                Operation operation = this.parseOperation(element2, portType, definition);
                if (operation != null) {
                    portType.addOperation(operation);
                }
            } else {
                portType.addExtensibilityElement(this.parseExtensibilityElement(PortType.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        this.parseExtensibilityAttributes(element, PortType.class, (AttributeExtensible)portType, definition);
        return portType;
    }

    protected Operation parseOperation(Element element, PortType portType, Definition definition) throws WSDLException {
        OperationType operationType;
        Operation operation = null;
        List list = DOMUtils.getAttributes(element);
        String string = DOMUtils.getAttribute(element, "name", list);
        String string2 = DOMUtils.getAttribute(element, "parameterOrder", list);
        NamedNodeMap namedNodeMap = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations(namedNodeMap, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        Vector<String> vector = new Vector<String>();
        Element element3 = null;
        Input input = null;
        Output output = null;
        Vector<Fault> vector2 = new Vector<Fault>();
        Vector<ExtensibilityElement> vector3 = new Vector<ExtensibilityElement>();
        boolean bl = true;
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                element3 = element2;
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_INPUT, (Node)element2)) {
                input = this.parseInput(element2, definition);
                vector.add("input");
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_OUTPUT, (Node)element2)) {
                output = this.parseOutput(element2, definition);
                vector.add("output");
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_FAULT, (Node)element2)) {
                vector2.add(this.parseFault(element2, definition));
            } else {
                vector3.add(this.parseExtensibilityElement(Operation.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        if (string != null) {
            Input input2;
            String string3 = input != null ? (input.getName() != null ? input.getName() : ":none") : (operationType = null);
            String string4 = output != null ? (output.getName() != null ? output.getName() : ":none") : null;
            operation = portType.getOperation(string, (String)operationType, string4);
            if (operation != null && !operation.isUndefined()) {
                operation = null;
            }
            if (operation != null && operationType == null && (input2 = operation.getInput()) != null && input2.getName() != null) {
                operation = null;
            }
            if (operation != null && string4 == null && (input2 = operation.getOutput()) != null && input2.getName() != null) {
                operation = null;
            }
            if (operation == null) {
                operation = definition.createOperation();
                operation.setName(string);
                bl = false;
            }
        } else {
            operation = definition.createOperation();
            bl = false;
        }
        operation.setUndefined(false);
        if (string2 != null) {
            operation.setParameterOrdering(StringUtils.parseNMTokens((String)string2));
        }
        if (element3 != null) {
            operation.setDocumentationElement(element3);
        }
        if (input != null) {
            operation.setInput(input);
        }
        if (output != null) {
            operation.setOutput(output);
        }
        if (vector2.size() > 0) {
            operationType = vector2.iterator();
            while (operationType.hasNext()) {
                operation.addFault((Fault)operationType.next());
            }
        }
        if (vector3.size() > 0) {
            operationType = vector3.iterator();
            while (operationType.hasNext()) {
                operation.addExtensibilityElement((ExtensibilityElement)operationType.next());
            }
        }
        operationType = null;
        if (((Object)vector).equals(STYLE_ONE_WAY)) {
            operationType = OperationType.ONE_WAY;
        } else if (((Object)vector).equals(STYLE_REQUEST_RESPONSE)) {
            operationType = OperationType.REQUEST_RESPONSE;
        } else if (((Object)vector).equals(STYLE_SOLICIT_RESPONSE)) {
            operationType = OperationType.SOLICIT_RESPONSE;
        } else if (((Object)vector).equals(STYLE_NOTIFICATION)) {
            operationType = OperationType.NOTIFICATION;
        }
        if (operationType != null) {
            operation.setStyle(operationType);
        }
        if (bl) {
            operation = null;
        }
        this.parseExtensibilityAttributes(element, Operation.class, (AttributeExtensible)operation, definition);
        return operation;
    }

    protected Service parseService(Element element, Definition definition) throws WSDLException {
        Service service = definition.createService();
        List list = DOMUtils.getAttributes(element);
        String string = DOMUtils.getAttribute(element, "name", list);
        if (string != null) {
            service.setQName(new QName(definition.getTargetNamespace(), string));
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations(namedNodeMap, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                service.setDocumentationElement(element2);
            } else if (QNameUtils.matches((QName)Constants.Q_ELEM_PORT, (Node)element2)) {
                service.addPort(this.parsePort(element2, definition));
            } else {
                service.addExtensibilityElement(this.parseExtensibilityElement(Service.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        this.parseExtensibilityAttributes(element, Service.class, (AttributeExtensible)service, definition);
        return service;
    }

    protected Port parsePort(Element element, Definition definition) throws WSDLException {
        NamedNodeMap namedNodeMap;
        Port port = definition.createPort();
        List list = DOMUtils.getAttributes(element);
        String string = DOMUtils.getAttribute(element, "name", list);
        QName qName = WSDLReaderImplOriginal.getQualifiedAttributeValue(element, "binding", "port", definition, list);
        if (string != null) {
            port.setName(string);
        }
        if (qName != null) {
            namedNodeMap = definition.getBinding(qName);
            if (namedNodeMap == null) {
                namedNodeMap = definition.createBinding();
                namedNodeMap.setQName(qName);
                definition.addBinding((Binding)namedNodeMap);
            }
            port.setBinding((Binding)namedNodeMap);
        }
        namedNodeMap = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations(namedNodeMap, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                port.setDocumentationElement(element2);
            } else {
                port.addExtensibilityElement(this.parseExtensibilityElement(Port.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        this.parseExtensibilityAttributes(element, Port.class, (AttributeExtensible)port, definition);
        return port;
    }

    protected ExtensibilityElement parseExtensibilityElement(Class clazz, Element element, Definition definition) throws WSDLException {
        QName qName = QNameUtils.newQName((Node)element);
        String string = element.getNamespaceURI();
        try {
            if (string == null || string.equals("http://schemas.xmlsoap.org/wsdl/")) {
                throw new WSDLException("INVALID_WSDL", "Encountered illegal extension element '" + qName + "' in the context of a '" + clazz.getName() + "'. Extension elements must be in " + "a namespace other than WSDL's.");
            }
            ExtensionRegistry extensionRegistry = definition.getExtensionRegistry();
            if (extensionRegistry == null) {
                throw new WSDLException("CONFIGURATION_ERROR", "No ExtensionRegistry set for this Definition, so unable to deserialize a '" + qName + "' element in the " + "context of a '" + clazz.getName() + "'.");
            }
            ExtensionDeserializer extensionDeserializer = extensionRegistry.queryDeserializer(clazz, qName);
            return extensionDeserializer.unmarshall(clazz, qName, element, definition, extensionRegistry);
        }
        catch (WSDLException wSDLException) {
            if (wSDLException.getLocation() == null) {
                wSDLException.setLocation(XPathUtils.getXPathExprFromNode((Node)element));
            }
            throw wSDLException;
        }
    }

    protected Input parseInput(Element element, Definition definition) throws WSDLException {
        NamedNodeMap namedNodeMap;
        Input input = definition.createInput();
        String string = DOMUtils.getAttribute(element, "name");
        QName qName = WSDLReaderImplOriginal.getQualifiedAttributeValue(element, "message", "input", definition);
        if (string != null) {
            input.setName(string);
        }
        if (qName != null) {
            namedNodeMap = definition.getMessage(qName);
            if (namedNodeMap == null) {
                namedNodeMap = definition.createMessage();
                namedNodeMap.setQName(qName);
                definition.addMessage((Message)namedNodeMap);
            }
            input.setMessage((Message)namedNodeMap);
        }
        namedNodeMap = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations(namedNodeMap, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                input.setDocumentationElement(element2);
            } else {
                input.addExtensibilityElement(this.parseExtensibilityElement(Input.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        this.parseExtensibilityAttributes(element, Input.class, (AttributeExtensible)input, definition);
        return input;
    }

    protected Output parseOutput(Element element, Definition definition) throws WSDLException {
        NamedNodeMap namedNodeMap;
        Output output = definition.createOutput();
        String string = DOMUtils.getAttribute(element, "name");
        QName qName = WSDLReaderImplOriginal.getQualifiedAttributeValue(element, "message", "output", definition);
        if (string != null) {
            output.setName(string);
        }
        if (qName != null) {
            namedNodeMap = definition.getMessage(qName);
            if (namedNodeMap == null) {
                namedNodeMap = definition.createMessage();
                namedNodeMap.setQName(qName);
                definition.addMessage((Message)namedNodeMap);
            }
            output.setMessage((Message)namedNodeMap);
        }
        namedNodeMap = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations(namedNodeMap, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                output.setDocumentationElement(element2);
            } else {
                output.addExtensibilityElement(this.parseExtensibilityElement(Output.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        this.parseExtensibilityAttributes(element, Output.class, (AttributeExtensible)output, definition);
        return output;
    }

    protected Fault parseFault(Element element, Definition definition) throws WSDLException {
        NamedNodeMap namedNodeMap;
        Fault fault = definition.createFault();
        String string = DOMUtils.getAttribute(element, "name");
        QName qName = WSDLReaderImplOriginal.getQualifiedAttributeValue(element, "message", "fault", definition);
        if (string != null) {
            fault.setName(string);
        }
        if (qName != null) {
            namedNodeMap = definition.getMessage(qName);
            if (namedNodeMap == null) {
                namedNodeMap = definition.createMessage();
                namedNodeMap.setQName(qName);
                definition.addMessage((Message)namedNodeMap);
            }
            fault.setMessage((Message)namedNodeMap);
        }
        namedNodeMap = element.getAttributes();
        WSDLReaderImplOriginal.registerNSDeclarations(namedNodeMap, definition);
        Element element2 = DOMUtils.getFirstChildElement(element);
        while (element2 != null) {
            if (QNameUtils.matches((QName)Constants.Q_ELEM_DOCUMENTATION, (Node)element2)) {
                fault.setDocumentationElement(element2);
            } else {
                fault.addExtensibilityElement(this.parseExtensibilityElement(Fault.class, element2, definition));
            }
            element2 = DOMUtils.getNextSiblingElement(element2);
        }
        this.parseExtensibilityAttributes(element, Fault.class, (AttributeExtensible)fault, definition);
        return fault;
    }

    private static QName getQualifiedAttributeValue(Element element, String string, String string2, Definition definition) throws WSDLException {
        try {
            return DOMUtils.getQualifiedAttributeValue(element, string, string2, false, definition);
        }
        catch (WSDLException wSDLException) {
            if (wSDLException.getFaultCode().equals("NO_PREFIX_SPECIFIED")) {
                String string3 = DOMUtils.getAttribute(element, string);
                return new QName(string3);
            }
            throw wSDLException;
        }
    }

    private static QName getQualifiedAttributeValue(Element element, String string, String string2, Definition definition, List list) throws WSDLException {
        try {
            return DOMUtils.getQualifiedAttributeValue(element, string, string2, false, definition, list);
        }
        catch (WSDLException wSDLException) {
            if (wSDLException.getFaultCode().equals("NO_PREFIX_SPECIFIED")) {
                String string3 = DOMUtils.getAttribute(element, string, list);
                return new QName(string3);
            }
            throw wSDLException;
        }
    }

    private static void checkElementName(Element element, QName qName) throws WSDLException {
        if (!QNameUtils.matches((QName)qName, (Node)element)) {
            WSDLException wSDLException = new WSDLException("INVALID_WSDL", "Expected element '" + qName + "'.");
            wSDLException.setLocation(XPathUtils.getXPathExprFromNode((Node)element));
            throw wSDLException;
        }
    }

    private static Document getDocument(InputSource inputSource, String string) throws WSDLException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            return document;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new WSDLException("PARSER_ERROR", "Problem parsing '" + string + "'.", (Throwable)exception);
        }
    }

    private static void registerNSDeclarations(NamedNodeMap namedNodeMap, Definition definition) {
        int n2 = namedNodeMap.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Attr attr = (Attr)namedNodeMap.item(i2);
            String string = attr.getNamespaceURI();
            String string2 = attr.getLocalName();
            String string3 = attr.getValue();
            if (string == null || !string.equals("http://www.w3.org/2000/xmlns/")) continue;
            if (string2 != null && !string2.equals("xmlns")) {
                DOMUtils.registerUniquePrefix(string2, string3, definition);
                continue;
            }
            DOMUtils.registerUniquePrefix(null, string3, definition);
        }
    }

    public Definition readWSDL(String string) throws WSDLException {
        return this.readWSDL(null, string);
    }

    public Definition readWSDL(String string, String string2) throws WSDLException {
        try {
            if (this.verbose) {
                System.out.println("Retrieving document at '" + string2 + "'" + (string == null ? "." : ", relative to '" + string + "'."));
            }
            URL uRL = string != null ? StringUtils.getURL(null, (String)string) : null;
            URL uRL2 = StringUtils.getURL((URL)uRL, (String)string2);
            InputStream inputStream = StringUtils.getContentAsInputStream((URL)uRL2);
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(uRL2.toString());
            Document document = WSDLReaderImplOriginal.getDocument(inputSource, uRL2.toString());
            inputStream.close();
            Definition definition = this.readWSDL(uRL2.toString(), document);
            return definition;
        }
        catch (WSDLException wSDLException) {
            throw wSDLException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + string2 + (string == null ? "'." : "', relative to '" + string + "'."), (Throwable)exception);
        }
    }

    public Definition readWSDL(String string, Element element) throws WSDLException {
        return this.readWSDL(string, element, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition readWSDL(WSDLLocator wSDLLocator, Element element) throws WSDLException {
        try {
            this.loc = wSDLLocator;
            Definition definition = this.readWSDL(wSDLLocator.getBaseURI(), element, null);
            return definition;
        }
        finally {
            wSDLLocator.close();
            this.loc = null;
        }
    }

    protected Definition readWSDL(String string, Element element, Map map) throws WSDLException {
        return this.parseDefinitions(string, element, map);
    }

    public Definition readWSDL(String string, Document document) throws WSDLException {
        return this.readWSDL(string, document.getDocumentElement());
    }

    public Definition readWSDL(String string, InputSource inputSource) throws WSDLException {
        String string2 = inputSource.getSystemId() != null ? inputSource.getSystemId() : "- WSDL Document -";
        return this.readWSDL(string, WSDLReaderImplOriginal.getDocument(inputSource, string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition readWSDL(WSDLLocator wSDLLocator) throws WSDLException {
        InputSource inputSource = wSDLLocator.getBaseInputSource();
        String string = wSDLLocator.getBaseURI();
        if (inputSource == null) {
            throw new WSDLException("OTHER_ERROR", "Unable to locate document at '" + string + "'.");
        }
        inputSource.setSystemId(string);
        this.loc = wSDLLocator;
        if (this.verbose) {
            System.out.println("Retrieving document at '" + string + "'.");
        }
        try {
            Definition definition = this.readWSDL(string, inputSource);
            return definition;
        }
        finally {
            this.loc.close();
            this.loc = null;
        }
    }
}

