/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class PortingUtils {
    private static Rectangle e = null;
    private static Area c;
    private static Rectangle[] f;
    private static Insets[] b;
    private static Thread d;
    public static boolean INITIALIZE_SCREEN_AREA_USING_THREAD;

    public static Component getCurrentFocusComponent(AWTEvent aWTEvent) {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    public static int getFrameState(Frame frame) {
        return frame.getExtendedState();
    }

    public static void setFrameState(Frame frame, int n2) {
        frame.setExtendedState(n2);
    }

    public static int getMouseModifiers(MouseEvent mouseEvent) {
        return mouseEvent.getModifiersEx();
    }

    public static void removeFocus(JComponent jComponent) {
        jComponent.setRequestFocusEnabled(false);
        jComponent.setFocusable(false);
    }

    public static void removeButtonBorder(AbstractButton abstractButton) {
        abstractButton.setContentAreaFilled(false);
        abstractButton.setMargin(new Insets(0, 0, 0, 0));
        abstractButton.setBorder(BorderFactory.createEmptyBorder());
    }

    public static Rectangle containsInScreenBounds(Component component, Rectangle rectangle) {
        return PortingUtils.containsInScreenBounds(component, rectangle, false);
    }

    public static Rectangle containsInScreenBounds(Component component, Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = PortingUtils.getScreenBounds(component, bl);
        Point point = rectangle.getLocation();
        if (point.x + rectangle.width > rectangle2.x + rectangle2.width) {
            point.x = rectangle2.x + rectangle2.width - rectangle.width;
        }
        if (point.y + rectangle.height > rectangle2.y + rectangle2.height) {
            point.y = rectangle2.y + rectangle2.height - rectangle.height;
        }
        if (point.x < rectangle2.x) {
            point.x = rectangle2.x;
        }
        if (point.y < rectangle2.y) {
            point.y = rectangle2.y;
        }
        return new Rectangle(point, rectangle.getSize());
    }

    public static Rectangle overlapWithScreenBounds(Component component, Rectangle rectangle) {
        Rectangle rectangle2 = PortingUtils.getScreenBounds(component);
        Point point = rectangle.getLocation();
        if (point.x > rectangle2.x + rectangle2.width) {
            point.x = rectangle2.x + rectangle2.width - rectangle.width;
        }
        if (point.y > rectangle2.y + rectangle2.height) {
            point.y = rectangle2.y + rectangle2.height - rectangle.height;
        }
        if (point.x + rectangle.width < rectangle2.x) {
            point.x = rectangle2.x;
        }
        if (point.y + rectangle.height < rectangle2.y) {
            point.y = rectangle2.y;
        }
        return new Rectangle(point, rectangle.getSize());
    }

    public static Dimension getScreenSize(Component component) {
        PortingUtils.h();
        Dimension dimension = e.getSize();
        if (component != null && !(component instanceof JApplet) && component.getGraphicsConfiguration() != null) {
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(component.getGraphicsConfiguration());
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
        }
        return dimension;
    }

    public static Dimension getLocalScreenSize(Component component) {
        PortingUtils.h();
        if (component != null && !(component instanceof JApplet) && component.getGraphicsConfiguration() != null) {
            GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            return rectangle.getSize();
        }
        return PortingUtils.getScreenSize(component);
    }

    public static Rectangle getScreenBounds(Component component, boolean bl) {
        Rectangle rectangle;
        PortingUtils.h();
        Rectangle rectangle2 = rectangle = !bl || component == null || component.getGraphicsConfiguration() == null ? (Rectangle)e.clone() : component.getGraphicsConfiguration().getBounds();
        if (component != null && !(component instanceof JApplet) && component.getGraphicsConfiguration() != null) {
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(component.getGraphicsConfiguration());
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        }
        return rectangle;
    }

    public static Rectangle getScreenBounds(Component component) {
        return PortingUtils.getScreenBounds(component, false);
    }

    public static Rectangle getLocalScreenBounds() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.getMaximumWindowBounds();
    }

    private static void h() {
        if (e == null) {
            GraphicsDevice[] graphicsDeviceArray;
            e = new Rectangle();
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
                GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                e = e.union(graphicsConfiguration.getBounds());
            }
        }
    }

    public static synchronized void initializeScreenArea() {
        PortingUtils.initializeScreenArea(5);
    }

    public static synchronized void initializeScreenArea(int n2) {
        if (d == null) {
            d = new Thread(){

                public void run() {
                    GraphicsDevice[] graphicsDeviceArray;
                    c = new Area();
                    e = new Rectangle();
                    GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>();
                    ArrayList<Insets> arrayList2 = new ArrayList<Insets>();
                    for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
                        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
                        Rectangle rectangle = graphicsConfiguration.getBounds();
                        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
                        arrayList.add(rectangle);
                        arrayList2.add(insets);
                        c.add(new Area(rectangle));
                        e = e.union(rectangle);
                    }
                    PortingUtils.j(arrayList.toArray(new Rectangle[arrayList.size()]));
                    PortingUtils.e(arrayList2.toArray(new Insets[arrayList.size()]));
                    d = null;
                }
            };
            d.setPriority(n2);
            if (INITIALIZE_SCREEN_AREA_USING_THREAD) {
                d.start();
            } else {
                d.run();
            }
        }
    }

    public static boolean isInitializationThreadAlive() {
        return d != null && d.isAlive();
    }

    public static boolean isInitalizationThreadStarted() {
        return d != null;
    }

    private static void c() {
        PortingUtils.initializeScreenArea();
        while (d != null && d.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static Rectangle ensureVisible(Component component, Rectangle rectangle) {
        Rectangle rectangle2 = PortingUtils.getLocalScreenBounds();
        if (!rectangle2.contains(rectangle.getLocation())) {
            Rectangle rectangle3 = PortingUtils.getScreenBounds(component, false);
            if (rectangle.x > rectangle3.x + rectangle3.width || rectangle.x < rectangle3.x) {
                rectangle.x = rectangle2.x;
            }
            if (rectangle.y > rectangle3.y + rectangle3.height || rectangle.y < rectangle3.y) {
                rectangle.y = rectangle2.y;
            }
        }
        return rectangle;
    }

    public static Rectangle ensureOnScreen(Rectangle rectangle) {
        int n2;
        int n3;
        Rectangle rectangle2 = PortingUtils.getLocalScreenBounds();
        if (rectangle2.contains(rectangle)) {
            return rectangle;
        }
        PortingUtils.c();
        if (c.contains(rectangle)) {
            return rectangle;
        }
        Rectangle rectangle3 = null;
        Point point = rectangle.getLocation();
        for (Rectangle rectangle4 : f) {
            if (!rectangle4.contains(point)) continue;
            rectangle3 = rectangle4;
            break;
        }
        for (Rectangle rectangle4 : f) {
            if (!rectangle4.intersects(rectangle)) continue;
            rectangle3 = rectangle4;
            break;
        }
        if (rectangle3 == null) {
            rectangle.x = (PortingUtils.f[0].width - rectangle.width) / 2;
            rectangle.y = (PortingUtils.f[0].width - rectangle.width) / 2;
            return rectangle;
        }
        int n4 = rectangle.x + rectangle.width;
        int n5 = rectangle3.x + rectangle3.width;
        if (n4 > n5) {
            rectangle.x = n5 - rectangle.width;
        }
        if (rectangle.x < rectangle3.x) {
            rectangle.x = rectangle3.x;
        }
        if ((n3 = rectangle.y + rectangle.height) > (n2 = rectangle3.y + rectangle3.height)) {
            rectangle.y = n2 - rectangle.height;
        }
        if (rectangle.y < rectangle3.y) {
            rectangle.y = rectangle3.y;
        }
        return rectangle;
    }

    public static Rectangle getContainingScreenBounds(Rectangle rectangle, boolean bl) {
        Rectangle rectangle2;
        int n2;
        PortingUtils.c();
        Rectangle rectangle3 = null;
        Insets insets = null;
        Point point = rectangle.getLocation();
        for (n2 = 0; n2 < f.length; ++n2) {
            rectangle2 = f[n2];
            if (!rectangle2.contains(point)) continue;
            rectangle3 = rectangle2;
            insets = b[n2];
            break;
        }
        for (n2 = 0; n2 < f.length; ++n2) {
            rectangle2 = f[n2];
            if (!rectangle2.intersects(rectangle)) continue;
            rectangle3 = rectangle2;
            insets = b[n2];
            break;
        }
        if (rectangle3 == null) {
            rectangle3 = f[0];
            insets = b[0];
        }
        Rectangle rectangle4 = new Rectangle(rectangle3);
        if (bl && insets != null) {
            rectangle4.x += insets.left;
            rectangle4.y += insets.top;
            rectangle4.width -= insets.left + insets.right;
            rectangle4.height -= insets.top + insets.bottom;
        }
        return rectangle4;
    }

    public static Area getScreenArea() {
        PortingUtils.c();
        return c;
    }

    public static void notifyUser() {
        PortingUtils.notifyUser(null);
    }

    public static void notifyUser(Component component) {
        String string = SecurityUtils.getProperty("jide.beepNotifyUser", "true");
        if ("true".equals(string)) {
            UIManager.getLookAndFeel().provideErrorFeedback(component);
        }
    }

    public static void prerequisiteChecking() {
        if (!SystemInfo.isJdk14Above()) {
            PortingUtils.notifyUser();
            JOptionPane.showMessageDialog(null, "J2SE 1.4 or above is required for this demo.", "JIDE Software, Inc.", 2);
            System.exit(0);
        }
        if (!SystemInfo.isJdk142Above()) {
            PortingUtils.notifyUser();
            JOptionPane.showMessageDialog(null, "J2SE 1.4.2 or above is recommended for this demo for the best experience of seamless integration with Windows XP.", "JIDE Software, Inc.", 2);
        }
        if (SystemInfo.isMacOSX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.brushMetalLook", "true");
        }
    }

    public static void setPreferredSize(Component component, Dimension dimension) {
        if (SystemInfo.isJdk15Above()) {
            component.setPreferredSize(dimension);
        } else if (component instanceof JComponent) {
            ((JComponent)component).setPreferredSize(dimension);
        }
    }

    public static void setMinimumSize(Component component, Dimension dimension) {
        if (SystemInfo.isJdk15Above()) {
            component.setMinimumSize(dimension);
        } else if (component instanceof JComponent) {
            ((JComponent)component).setMinimumSize(dimension);
        }
    }

    static /* synthetic */ Rectangle[] j(Rectangle[] rectangleArray) {
        f = rectangleArray;
        return rectangleArray;
    }

    static /* synthetic */ Insets[] e(Insets[] insetsArray) {
        b = insetsArray;
        return insetsArray;
    }

    static {
        d = null;
        INITIALIZE_SCREEN_AREA_USING_THREAD = true;
    }
}

