/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedVector<E>
extends Vector<E> {
    private Map<Object, Integer> b;
    private boolean c = false;

    public CachedVector() {
    }

    public CachedVector(Collection<? extends E> collection) {
        super(collection);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedVector(int n2) {
        super(n2);
    }

    @Override
    public int indexOf(Object object) {
        this.b();
        Integer n2 = this.b.get(object);
        if (n2 != null) {
            return n2;
        }
        if (this.isLazyCaching()) {
            int n3 = super.indexOf(object);
            if (n3 == -1) {
                this.uncacheIt(object);
            } else {
                this.cacheIt(object, n3);
            }
            return n3;
        }
        return -1;
    }

    protected synchronized void adjustCache(int n2, int n3) {
        if (this.b != null) {
            Map<Object, Integer> map = this.createCache();
            Set<Object> set = this.b.keySet();
            for (Object object : set) {
                int n4 = this.b.get(object);
                if (n4 >= n2) {
                    map.put(object, n4 + n3);
                    continue;
                }
                map.put(object, n4);
            }
            this.b = map;
        }
    }

    protected Map<Object, Integer> createCache() {
        return new IdentityHashMap<Object, Integer>();
    }

    public synchronized void cacheIt(Object object, int n2) {
        if (this.b != null && (this.b.get(object) == null || n2 < this.b.get(object))) {
            this.b.put(object, n2);
        }
    }

    public synchronized void uncacheIt(Object object) {
        if (this.b != null) {
            this.b.remove(object);
        }
    }

    @Override
    public boolean add(E e2) {
        boolean bl = super.add(e2);
        if (!this.isLazyCaching() && bl) {
            this.b();
            this.cacheIt(e2, this.size() - 1);
        }
        return bl;
    }

    @Override
    public void add(int n2, E e2) {
        super.add(n2, e2);
        if (!this.isLazyCaching()) {
            this.b();
            this.adjustCache(n2, 1);
            this.cacheIt(e2, n2);
        } else if (this.b != null) {
            this.adjustCache(n2, 1);
            this.cacheIt(e2, n2);
        }
    }

    private void b() {
        if (this.b == null) {
            this.b = this.createCache();
        }
    }

    @Override
    public E remove(int n2) {
        Object e2 = super.remove(n2);
        if (e2 != null) {
            this.uncacheIt(e2);
            this.adjustCache(n2, -1);
        }
        return e2;
    }

    @Override
    public boolean remove(Object object) {
        int n2 = this.indexOf(object);
        boolean bl = super.remove(object);
        if (bl) {
            this.uncacheIt(object);
            this.adjustCache(n2, -1);
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        this.uncacheAll();
        return super.removeAll(collection);
    }

    @Override
    public void clear() {
        this.uncacheAll();
        super.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = super.addAll(collection);
        if (bl) {
            this.cacheAll();
        }
        return bl;
    }

    @Override
    public boolean addAll(int n2, Collection<? extends E> collection) {
        boolean bl = super.addAll(n2, collection);
        this.b();
        this.adjustCache(n2, collection.size());
        for (E e2 : collection) {
            this.cacheIt(e2, n2++);
        }
        return bl;
    }

    @Override
    public E set(int n2, E e2) {
        if (!this.isLazyCaching()) {
            this.b();
            E e3 = super.set(n2, e2);
            this.uncacheIt(e3);
            this.cacheIt(e2, n2);
            return e3;
        }
        return super.set(n2, e2);
    }

    public void invalidateCache() {
        this.uncacheAll();
    }

    public synchronized void uncacheAll() {
        if (this.b != null) {
            this.b.clear();
            this.b = null;
        }
    }

    public synchronized void cacheAll() {
        this.b = this.createCache();
        Integer n2 = 0;
        for (Object e2 : this) {
            if (this.b.get(e2) == null) {
                this.b.put(e2, n2);
            }
            Integer n3 = n2;
            Integer n4 = n2 = Integer.valueOf(n2 + 1);
        }
    }

    public boolean isLazyCaching() {
        return this.c;
    }

    public void setLazyCaching(boolean bl) {
        this.c = bl;
    }

    @Override
    protected void removeRange(int n2, int n3) {
        if (n2 == n3) {
            this.remove(n2);
        } else {
            super.removeRange(n2, n3);
            this.uncacheAll();
            if (!this.isLazyCaching()) {
                this.cacheAll();
            }
        }
    }
}

