/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.utils.ReflectionUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;

public class VisibilityFocusTraversalPolicy
extends FocusTraversalPolicy {
    private FocusTraversalPolicy c;
    private Set<Container> b;

    public VisibilityFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        this(focusTraversalPolicy, null);
    }

    public VisibilityFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy, Container container) {
        if (focusTraversalPolicy != null && ReflectionUtils.isSubClassOf(focusTraversalPolicy, "LegacyGlueFocusTraversalPolicy")) {
            throw new IllegalArgumentException("VisibilityFocusTraversalPolicy can't work well with LegacyGlueFocusTraversalPolicy.");
        }
        this.c = focusTraversalPolicy;
        if (container != null) {
            this.b = new HashSet<Container>();
            this.b.add(container);
        }
    }

    public void addContainer(Container container) {
        if (this.b == null) {
            this.b = new HashSet<Container>();
        }
        this.b.add(container);
    }

    public void removeContainer(Container container) {
        if (this.b != null) {
            this.b.remove(container);
        }
    }

    public Container[] getContainers() {
        if (this.b == null) {
            return new Container[0];
        }
        return this.b.toArray(new Container[this.b.size()]);
    }

    public FocusTraversalPolicy getDefaultPolicy() {
        return this.c;
    }

    public Component getComponentAfter(Container container, Component component) {
        if (this.c == null) {
            return null;
        }
        Component component2 = this.c.getComponentAfter(container, component);
        boolean bl = true;
        block0: while (component2 != null && component != component2 && bl) {
            bl = false;
            for (Container container2 : this.b) {
                if (!container2.isAncestorOf(component2)) continue;
                Rectangle rectangle = container2.getBounds();
                Container container3 = container2.getParent();
                Rectangle rectangle2 = SwingUtilities.convertRectangle(component2.getParent(), component2.getBounds(), container3);
                if (rectangle2.x < rectangle.x + rectangle.width && rectangle2.x + rectangle2.width > rectangle.x && rectangle2.y < rectangle.y + rectangle.height && rectangle2.y + rectangle2.height > rectangle.y) {
                    return component2;
                }
                component2 = this.c.getComponentAfter(container, component2);
                bl = true;
                continue block0;
            }
        }
        return component2;
    }

    public Component getComponentBefore(Container container, Component component) {
        if (this.c == null) {
            return null;
        }
        Component component2 = this.c.getComponentBefore(container, component);
        boolean bl = true;
        block0: while (component2 != null && component != component2 && bl) {
            bl = false;
            for (Container container2 : this.b) {
                if (!container2.isAncestorOf(component2)) continue;
                Rectangle rectangle = container2.getBounds();
                Container container3 = container2.getParent();
                Rectangle rectangle2 = SwingUtilities.convertRectangle(component2.getParent(), component2.getBounds(), container3);
                if (rectangle2.x < rectangle.x + rectangle.width && rectangle2.x + rectangle2.width > rectangle.x && rectangle2.y < rectangle.y + rectangle.height && rectangle2.y + rectangle2.height > rectangle.y) {
                    return component2;
                }
                component2 = this.c.getComponentBefore(container, component2);
                bl = true;
                continue block0;
            }
        }
        return component2;
    }

    public Component getFirstComponent(Container container) {
        boolean bl;
        Component component;
        if (this.c == null) {
            return null;
        }
        Component component2 = component = this.c.getFirstComponent(container);
        block0: do {
            bl = false;
            for (Container container2 : this.b) {
                if (!container2.isAncestorOf(component)) continue;
                Rectangle rectangle = container2.getBounds();
                Container container3 = container2.getParent();
                Rectangle rectangle2 = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), container3);
                if (rectangle2.x < rectangle.x + rectangle.width && rectangle2.x + rectangle2.width > rectangle.x && rectangle2.y < rectangle.y + rectangle.height && rectangle2.y + rectangle2.height > rectangle.y) {
                    return component;
                }
                component = this.c.getComponentAfter(container, component);
                bl = true;
                continue block0;
            }
        } while (component != null && component2 != component && bl);
        return component;
    }

    public Component getLastComponent(Container container) {
        boolean bl;
        Component component;
        if (this.c == null) {
            return null;
        }
        Component component2 = component = this.c.getLastComponent(container);
        block0: do {
            bl = false;
            for (Container container2 : this.b) {
                if (!container2.isAncestorOf(component)) continue;
                Rectangle rectangle = container2.getBounds();
                Container container3 = container2.getParent();
                Rectangle rectangle2 = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), container3);
                if (rectangle2.x < rectangle.x + rectangle.width && rectangle2.x + rectangle2.width > rectangle.x && rectangle2.y < rectangle.y + rectangle.height && rectangle2.y + rectangle2.height > rectangle.y) {
                    return component;
                }
                component = this.c.getComponentBefore(container, component);
                bl = true;
                continue block0;
            }
        } while (component != null && component2 != component && bl);
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getDefaultComponent(Container container) {
        boolean bl;
        Component component;
        if (this.c == null) {
            return null;
        }
        Component component2 = component = this.c.getDefaultComponent(container);
        boolean bl2 = bl = this.c instanceof SortingFocusTraversalPolicy && ((SortingFocusTraversalPolicy)this.c).getImplicitDownCycleTraversal();
        if (this.c instanceof SortingFocusTraversalPolicy) {
            ((SortingFocusTraversalPolicy)this.c).setImplicitDownCycleTraversal(false);
        }
        try {
            boolean bl3;
            block4: do {
                bl3 = false;
                for (Container container2 : this.b) {
                    if (!container2.isAncestorOf(component)) continue;
                    Rectangle rectangle = container2.getBounds();
                    Container container3 = container2.getParent();
                    Rectangle rectangle2 = SwingUtilities.convertRectangle(component.getParent(), component.getBounds(), container3);
                    if (rectangle2.x < rectangle.x + rectangle.width && rectangle2.x + rectangle2.width > rectangle.x && rectangle2.y < rectangle.y + rectangle.height && rectangle2.y + rectangle2.height > rectangle.y) {
                        Component component3 = component;
                        return component3;
                    }
                    component = this.c.getComponentAfter(container, component);
                    bl3 = true;
                    continue block4;
                }
            } while (component != null && component2 != component && bl3);
            Component component4 = component;
            return component4;
        }
        finally {
            if (this.c instanceof SortingFocusTraversalPolicy) {
                ((SortingFocusTraversalPolicy)this.c).setImplicitDownCycleTraversal(bl);
            }
        }
    }

    public Component getInitialComponent(Window window) {
        if (this.c == null) {
            return null;
        }
        return this.c.getInitialComponent(window);
    }
}

