/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.f;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;

public class SimpleScrollPane
extends JScrollPane
implements ChangeListener,
MouseWheelListener {
    private AbstractButton j;
    private AbstractButton c;
    private AbstractButton f;
    private AbstractButton k;
    private int b = 10;
    private boolean h = false;
    private int i = 10;
    private boolean d = false;
    private int g = 50;
    private boolean e = true;
    public static final String SCROLL_UP_BUTTON = "SCROLL_UP_BUTTON";
    public static final String SCROLL_DOWN_BUTTON = "SCROLL_DOWN_BUTTON";
    public static final String SCROLL_LEFT_BUTTON = "SCROLL_LEFT_BUTTON";
    public static final String SCROLL_RIGHT_BUTTON = "SCROLL_RIGHT_BUTTON";

    public SimpleScrollPane(Component component, int n2, int n3) {
        this.setLayout(new f._b());
        this.setVerticalScrollBarPolicy(n2);
        this.setHorizontalScrollBarPolicy(n3);
        this.setViewport(this.createViewport());
        this.setScrollUpButton(this.createScrollButton(1));
        this.setScrollDownButton(this.createScrollButton(5));
        this.setScrollLeftButton(this.createScrollButton(7));
        this.setScrollRightButton(this.createScrollButton(3));
        if (null != component) {
            this.setViewportView(component);
        }
        this.updateButtonState();
        this.setOpaque(true);
        this.setFocusable(false);
        if (this.getHorizontalScrollBar() != null) {
            this.getHorizontalScrollBar().setVisible(false);
            this.getHorizontalScrollBar().setFocusable(false);
        }
        if (this.getVerticalScrollBar() != null) {
            this.getVerticalScrollBar().setVisible(false);
            this.getVerticalScrollBar().setFocusable(false);
        }
        this.updateUI();
        if (!this.getComponentOrientation().isLeftToRight()) {
            this.viewport.setViewPosition(new Point(Integer.MAX_VALUE, 0));
        }
        if (this.isWheelScrollingEnabled()) {
            this.addMouseWheelListener(this);
        }
    }

    public SimpleScrollPane(Component component) {
        this(component, 20, 30);
    }

    public SimpleScrollPane(int n2, int n3) {
        this(null, n2, n3);
    }

    public SimpleScrollPane() {
        this(null, 20, 30);
    }

    public void updateUI() {
        super.updateUI();
        this.setLayout(new f._b());
        LookAndFeel.installBorder(this, "JideScrollPane.border");
        this.getViewport().addChangeListener(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.getViewport()) {
            this.updateButtonState();
        }
    }

    public AbstractButton getScrollUpButton() {
        return this.j;
    }

    public void setScrollUpButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollUpButton();
        this.j = abstractButton;
        this.add((Component)this.j, SCROLL_UP_BUTTON);
        this.firePropertyChange("scrollUpButton", abstractButton2, this.j);
        this.revalidate();
        this.repaint();
    }

    public AbstractButton getScrollDownButton() {
        return this.c;
    }

    public void setScrollDownButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollDownButton();
        this.c = abstractButton;
        this.add((Component)this.c, SCROLL_DOWN_BUTTON);
        this.firePropertyChange("scrollDownButton", abstractButton2, this.c);
        this.revalidate();
        this.repaint();
    }

    public AbstractButton getScrollLeftButton() {
        return this.f;
    }

    public void setScrollLeftButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollLeftButton();
        this.f = abstractButton;
        this.add((Component)this.f, SCROLL_LEFT_BUTTON);
        this.firePropertyChange("scrollLeftButton", abstractButton2, this.f);
        this.revalidate();
        this.repaint();
    }

    public AbstractButton getScrollRightButton() {
        return this.k;
    }

    public void setScrollRightButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollRightButton();
        this.k = abstractButton;
        this.add((Component)this.k, SCROLL_RIGHT_BUTTON);
        this.firePropertyChange("scrollRightButton", abstractButton2, this.k);
        this.revalidate();
        this.repaint();
    }

    protected AbstractButton createScrollButton(int n2) {
        return new ScrollButton(n2);
    }

    protected void updateButtonState() {
        Point point = this.viewport.getViewPosition();
        this.j.setEnabled(point.y != 0);
        this.c.setEnabled(point.y != this.viewport.getViewSize().height - this.viewport.getViewRect().height);
        this.f.setEnabled(point.x != 0);
        this.k.setEnabled(point.x != this.viewport.getViewSize().width - this.viewport.getViewRect().width);
        this.revalidate();
        this.repaint();
    }

    public void scroll(JViewport jViewport, int n2) {
        Point point = jViewport.getViewPosition();
        JViewport jViewport2 = this.getViewport();
        switch (n2) {
            case 1: {
                if (!this.d && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.y -= scrollable.getScrollableUnitIncrement(rectangle, 1, -1);
                } else {
                    point.y -= this.getVerticalUnitIncrement();
                }
                if (point.y >= 0) break;
                point.y = 0;
                break;
            }
            case 5: {
                if (!this.d && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.y += scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
                } else {
                    point.y += this.getVerticalUnitIncrement();
                }
                if (point.y + jViewport.getViewRect().height <= jViewport.getViewSize().height) break;
                point.y = jViewport.getViewSize().height - jViewport.getViewRect().height;
                break;
            }
            case 7: {
                if (!this.h && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.x -= scrollable.getScrollableUnitIncrement(rectangle, 0, -1);
                } else {
                    point.x -= this.getHorizontalUnitIncrement();
                }
                if (point.x >= 0) break;
                point.x = 0;
                break;
            }
            case 3: {
                if (!this.h && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.x += scrollable.getScrollableUnitIncrement(rectangle, 0, 1);
                } else {
                    point.x += this.getHorizontalUnitIncrement();
                }
                if (point.x + jViewport.getViewRect().width <= jViewport.getViewSize().width) break;
                point.x = jViewport.getViewSize().width - jViewport.getViewRect().width;
            }
        }
        jViewport.setViewPosition(point);
    }

    public Rectangle getViewportBorderBounds() {
        Rectangle rectangle = new Rectangle(this.getSize());
        Insets insets = this.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        if (this.j != null && this.j.isVisible()) {
            rectangle.y += this.j.getHeight();
            rectangle.height -= this.j.getHeight();
        }
        if (this.f != null && this.f.isVisible()) {
            rectangle.x += this.f.getWidth();
            rectangle.width -= this.f.getWidth();
        }
        if (this.c != null && this.c.isVisible()) {
            rectangle.height -= this.c.getHeight();
        }
        if (this.k != null && this.k.isVisible()) {
            rectangle.width -= this.k.getWidth();
        }
        return rectangle;
    }

    public int getHorizontalUnitIncrement() {
        return this.b;
    }

    public void setHorizontalUnitIncrement(int n2) {
        this.h = true;
        if (n2 != this.b) {
            int n3 = this.b;
            this.b = n2;
            this.firePropertyChange("horizontalUnitIncrement", n3, this.b);
        }
    }

    public int getVerticalUnitIncrement() {
        return this.i;
    }

    public void setVerticalUnitIncrement(int n2) {
        this.d = true;
        if (n2 != this.i) {
            int n3 = this.i;
            this.i = n2;
            this.firePropertyChange("verticalUnitIncrement", n3, this.i);
        }
    }

    public boolean isScrollOnRollover() {
        return this.e;
    }

    public void setScrollOnRollover(boolean bl) {
        if (this.e != bl) {
            boolean bl2 = this.e;
            this.e = bl;
            this.firePropertyChange("scrollOnRollover", bl2, this.e);
        }
    }

    public int getRepeatDelay() {
        return this.g;
    }

    public void setRepeatDelay(int n2) {
        if (n2 != this.g) {
            int n3 = this.g;
            this.g = n2;
            this.firePropertyChange("repeatDelay", n3, this.g);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.isWheelScrollingEnabled() && mouseWheelEvent.getScrollAmount() != 0) {
            boolean bl = mouseWheelEvent.getWheelRotation() >= 0;
            int n2 = 0;
            if (!this.b(bl)) {
                return;
            }
            n2 = this.c(bl);
            if (n2 != 0) {
                this.scroll(this.getViewport(), n2);
            }
        }
    }

    private boolean b(boolean bl) {
        if (bl) {
            return this.j != null && this.j.isVisible() || this.f != null && this.f.isVisible();
        }
        return this.c != null && this.c.isVisible() || this.k != null && this.k.isVisible();
    }

    private int c(boolean bl) {
        if (bl) {
            if (this.j != null && this.j.isVisible()) {
                return 5;
            }
            if (this.f != null && this.f.isVisible()) {
                return 3;
            }
        } else {
            if (this.c != null && this.c.isVisible()) {
                return 1;
            }
            if (this.k != null && this.k.isVisible()) {
                return 7;
            }
        }
        return 0;
    }

    public void setWheelScrollingEnabled(boolean bl) {
        if (bl && !this.isWheelScrollingEnabled()) {
            this.addMouseWheelListener(this);
        }
        if (!bl && this.isWheelScrollingEnabled()) {
            this.removeMouseWheelListener(this);
        }
        super.setWheelScrollingEnabled(bl);
    }

    public class ScrollButton
    extends JideButton
    implements MouseListener,
    ActionListener,
    UIResource {
        private int hb;
        private Timer ib;

        public ScrollButton(int n2) {
            this.hb = n2;
            switch (n2) {
                case 1: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_up.gif"));
                    break;
                }
                case 5: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_down.gif"));
                    break;
                }
                case 7: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_left.gif"));
                    break;
                }
                case 3: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_right.gif"));
                }
            }
            this.addActionListener(this);
            this.addMouseListener(this);
            this.setPreferredSize(new Dimension(10, 10));
            this.setMinimumSize(new Dimension(10, 10));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleScrollPane.this.scroll(SimpleScrollPane.this.getViewport(), this.hb);
            SimpleScrollPane.this.updateButtonState();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SimpleScrollPane.this.isScrollOnRollover()) {
                this.fb(mouseEvent, 500);
            } else {
                this.eb(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SimpleScrollPane.this.isScrollOnRollover()) {
                this.hb();
            } else {
                this.eb(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (SimpleScrollPane.this.isScrollOnRollover()) {
                this.fb(mouseEvent, 500);
            }
        }

        private void eb(MouseEvent mouseEvent) {
            if (this.ib != null) {
                this.ib.setDelay(this.gb(mouseEvent));
            }
        }

        private void fb(MouseEvent mouseEvent, int n2) {
            this.hb();
            this.ib = new Timer(this.gb(mouseEvent), this);
            this.ib.setInitialDelay(n2);
            this.ib.start();
        }

        private void hb() {
            if (this.ib != null) {
                this.ib.stop();
                this.ib = null;
            }
        }

        private int gb(MouseEvent mouseEvent) {
            if (SimpleScrollPane.this.isScrollOnRollover()) {
                return SwingUtilities.isLeftMouseButton(mouseEvent) ? SimpleScrollPane.this.getRepeatDelay() : SimpleScrollPane.this.getRepeatDelay() * 2;
            }
            return SimpleScrollPane.this.getRepeatDelay();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (SimpleScrollPane.this.isScrollOnRollover()) {
                this.hb();
            }
        }
    }
}

