/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ResizableMouseInputAdapter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class Resizable {
    public static final int NONE = 0;
    public static final int UPPER_LEFT = 1;
    public static final int UPPER = 2;
    public static final int UPPER_RIGHT = 4;
    public static final int RIGHT = 8;
    public static final int LOWER_RIGHT = 16;
    public static final int LOWER = 32;
    public static final int LOWER_LEFT = 64;
    public static final int LEFT = 128;
    public static final int ALL = 255;
    private int d = 255;
    private int b = 16;
    public static final String PROPERTY_RESIZABLE_CORNERS = "resizableCorner";
    public static final String PROPERTY_RESIZE_CORNER_SIZE = "resizeCornerSize";
    protected final JComponent _component;
    private Insets e;
    private MouseInputListener f;
    private int c = 1;
    private boolean g;

    public Resizable(JComponent jComponent) {
        this._component = jComponent;
        this.installListeners();
    }

    public int getResizableCorners() {
        return this.d;
    }

    public void setResizableCorners(int n2) {
        if (this.d != n2) {
            int n3 = this.d;
            this.d = n2;
            this._component.firePropertyChange(PROPERTY_RESIZABLE_CORNERS, n3, this.d);
        }
    }

    public int getResizeCornerSize() {
        return this.b;
    }

    public void setResizeCornerSize(int n2) {
        if (this.b != n2) {
            int n3 = this.b;
            this.b = n2;
            this._component.firePropertyChange(PROPERTY_RESIZE_CORNER_SIZE, n3, this.b);
        }
    }

    protected void installListeners() {
        this.f = this.createMouseInputListener();
        this._component.addMouseListener(this.f);
        this._component.addMouseMotionListener(this.f);
    }

    public void uninstallListeners() {
        this._component.removeMouseListener(this.f);
        this._component.removeMouseMotionListener(this.f);
        this.f = null;
    }

    protected MouseInputListener createMouseInputListener() {
        return new ResizableMouseInputAdapter(this);
    }

    public MouseInputListener getMouseInputAdapter() {
        return this.f;
    }

    public void beginResizing(int n2) {
    }

    public void resizing(int n2, int n3, int n4, int n5, int n6) {
        Dimension dimension = this._component.getMinimumSize();
        Dimension dimension2 = this._component.getMaximumSize();
        if (n5 < dimension.width) {
            n5 = dimension.width;
        }
        if (n6 < dimension.height) {
            n5 = dimension.height;
        }
        if (n5 > dimension2.width) {
            n5 = dimension2.width;
        }
        if (n6 > dimension2.height) {
            n6 = dimension2.height;
        }
        this._component.setPreferredSize(new Dimension(n5, n6));
        this._component.getParent().doLayout();
    }

    public void endResizing(int n2) {
    }

    public boolean isTopLevel() {
        return this.g;
    }

    public void setTopLevel(boolean bl) {
        this.g = bl;
    }

    public JComponent getComponent() {
        return this._component;
    }

    public Insets getResizeInsets() {
        if (this.e != null) {
            return this.e;
        }
        return this.getComponent().getInsets();
    }

    public void setResizeInsets(Insets insets) {
        this.e = insets;
    }

    public int getSnapGridSize() {
        return this.c;
    }

    public void setSnapGridSize(int n2) {
        this.c = n2;
    }

    public static class ResizeCorner
    extends JComponent {
        static final int b = 16;
        private int c = 16;

        public ResizeCorner() {
        }

        public ResizeCorner(int n2) {
            this.c = n2;
        }

        public int getCorner() {
            return this.c;
        }

        public void setCorner(int n2) {
            this.c = n2;
        }

        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n2 = Math.min(this.getWidth(), this.getHeight());
            int n3 = Math.min(n2 / 4, 4);
            Color color = graphics.getColor();
            int n4 = this.getCorner();
            boolean bl = this.getComponentOrientation().isLeftToRight();
            switch (n4) {
                case 16: {
                    int n5;
                    graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                    int n6 = 0;
                    for (n5 = 0; n5 < n3; ++n5) {
                        n6 += 4;
                        if (bl) {
                            graphics.drawLine(n2, n2 - n6, n2 - n6, n2);
                            continue;
                        }
                        graphics.drawLine(0, n6, n2 - n6, n2);
                    }
                    graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    n6 = 0;
                    for (n5 = 0; n5 < n3; ++n5) {
                        n6 += 4;
                        if (bl) {
                            graphics.drawLine(n2, n2 - n6 + 1, n2 - n6 + 1, n2);
                            graphics.drawLine(n2, n2 - n6 + 2, n2 - n6 + 2, n2);
                            continue;
                        }
                        graphics.drawLine(0, n6 + 1, n2 - n6 - 1, n2);
                        graphics.drawLine(0, n6 + 2, n2 - n6 - 2, n2);
                    }
                    break;
                }
                case 4: {
                    int n7;
                    graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                    int n8 = 0;
                    for (n7 = 0; n7 < n3; ++n7) {
                        n8 += 4;
                        if (bl) {
                            graphics.drawLine(n2 - n8, 0, n2, n8);
                            continue;
                        }
                        graphics.drawLine(n8, 0, n2, n2 - n8);
                    }
                    graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    n8 = 0;
                    for (n7 = 0; n7 < n3; ++n7) {
                        n8 += 4;
                        if (bl) {
                            graphics.drawLine(n2 - n8 + 1, 0, n2, n8 - 1);
                            graphics.drawLine(n2 - n8 + 2, 0, n2, n8 - 2);
                            continue;
                        }
                        graphics.drawLine(n8 + 1, 0, n2, n2 - n8 - 1);
                        graphics.drawLine(n8 + 2, 0, n2, n2 - n8 - 2);
                    }
                    break;
                }
            }
            graphics.setColor(color);
        }
    }
}

