/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.WindowsDesktopProperty;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.JideBorderLayout;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.swing.b;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.CellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.tree.TreeCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JideSwingUtilities
implements SwingConstants {
    private static final Logger e = Logger.getLogger(JideSwingUtilities.class.getName() + ".focus");
    private static final boolean i;
    private static final boolean n;
    public static final Object AA_TEXT_PROPERTY_KEY;
    private static PropertyChangeListener h;
    private static PropertyChangeListener k;
    private static final String b = "setOpaqueRecursively.opaqueListener";
    public static final String SET_OPAQUE_RECURSIVELY_EXCLUDED = "setOpaqueRecursively.excluded";
    static Map c;
    private static Class<?> d;
    private static Constructor<?> g;
    private static Constructor<?> f;
    private static Class<?> j;
    private static Constructor<?> m;
    private static Constructor<?> l;
    protected static boolean tracingFocus;
    private static ChangeListener o;

    public static JPanel createLeftPanel(Component component) {
        NullPanel nullPanel = new NullPanel(new BorderLayout());
        nullPanel.setOpaque(false);
        nullPanel.add(component, "Before");
        return nullPanel;
    }

    public static JPanel createRightPanel(Component component) {
        NullPanel nullPanel = new NullPanel(new BorderLayout());
        nullPanel.setOpaque(false);
        nullPanel.add(component, "After");
        return nullPanel;
    }

    public static JPanel createTopPanel(Component component) {
        NullPanel nullPanel = new NullPanel(new BorderLayout());
        nullPanel.setOpaque(false);
        nullPanel.add(component, "First");
        return nullPanel;
    }

    public static JPanel createBottomPanel(Component component) {
        NullPanel nullPanel = new NullPanel(new BorderLayout());
        nullPanel.setOpaque(false);
        nullPanel.add(component, "Last");
        return nullPanel;
    }

    public static JPanel createCenterPanel(Component component) {
        NullPanel nullPanel = new NullPanel(new GridBagLayout());
        nullPanel.setOpaque(false);
        nullPanel.add(component, new GridBagConstraints());
        return nullPanel;
    }

    public static JPanel createLabeledComponent(JLabel jLabel, Component component, Object object) {
        NullPanel nullPanel = new NullPanel(new JideBorderLayout(3, 3));
        nullPanel.setOpaque(false);
        nullPanel.add((Component)jLabel, object);
        jLabel.setLabelFor(component);
        nullPanel.add(component);
        return nullPanel;
    }

    public static void centerWindow(Window window) {
        window.setLocationRelativeTo(window.getParent());
    }

    public static void globalCenterWindow(Window window) {
        window.setLocationRelativeTo(null);
    }

    public static void paintArrow(Graphics graphics, Color color, int n2, int n3, int n4, int n5) {
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        n4 = n4 / 2 * 2 + 1;
        if (n5 == 0) {
            for (int i2 = 0; i2 < (n4 + 1) / 2; ++i2) {
                graphics.drawLine(n2 + i2, n3 + i2, n2 + n4 - i2 - 1, n3 + i2);
            }
        } else if (n5 == 1) {
            for (int i3 = 0; i3 < (n4 + 1) / 2; ++i3) {
                graphics.drawLine(n2 + i3, n3 + i3, n2 + i3, n3 + n4 - i3 - 1);
            }
        }
        graphics.setColor(color2);
    }

    public static void paintArrow(JComponent jComponent, Graphics graphics, Color color, int n2, int n3, int n4, int n5) {
        if (!jComponent.getComponentOrientation().isLeftToRight()) {
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            n4 = n4 / 2 * 2 + 1;
            for (int i2 = 0; i2 < (n4 + 1) / 2; ++i2) {
                graphics.drawLine(n2 + n4 - i2, n3 + i2, n2 + n4 - i2, n3 + n4 - i2 - 1);
            }
            graphics.setColor(color2);
            return;
        }
        JideSwingUtilities.paintArrow(graphics, color, n2, n3, n4, n5);
    }

    public static void paintCross(Graphics graphics, Color color, int n2, int n3, int n4, int n5) {
        graphics.setColor(color);
        n4 /= 2;
        for (int i2 = 0; i2 < n5; ++i2) {
            graphics.drawLine(n2 - n4, n3 - n4, n2 + n4, n3 + n4);
            graphics.drawLine(n2 + n4, n3 - n4, n2 - n4, n3 + n4);
            ++n2;
        }
    }

    public static Frame getFrame(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Frame) {
            return (Frame)component;
        }
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Frame)) continue;
            return (Frame)container;
        }
        return null;
    }

    public static void toggleRTLnLTR(Component component) {
        ComponentOrientation componentOrientation = component.getComponentOrientation();
        componentOrientation = componentOrientation == ComponentOrientation.RIGHT_TO_LEFT ? ComponentOrientation.LEFT_TO_RIGHT : ComponentOrientation.RIGHT_TO_LEFT;
        component.applyComponentOrientation(componentOrientation);
    }

    public static void synchronizeView(JViewport jViewport, JViewport jViewport2, int n2) {
        HashMap hashMap;
        int n3;
        if (jViewport == null || jViewport2 == null) {
            return;
        }
        ChangeListener[] changeListenerArray = jViewport.getChangeListeners();
        for (n3 = 0; n3 < changeListenerArray.length && changeListenerArray[n3] != JideSwingUtilities.getViewportSynchronizationChangeListener(); ++n3) {
        }
        if (n3 >= changeListenerArray.length) {
            jViewport.addChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
        }
        if (!((hashMap = jViewport.getClientProperty("synchronizeViewSlaveViewport")) instanceof Map)) {
            hashMap = new HashMap();
        }
        Map map = hashMap;
        map.put(jViewport2, n2);
        jViewport.putClientProperty("synchronizeViewSlaveViewport", map);
        hashMap = jViewport2.getClientProperty("synchronizeViewMasterViewport");
        if (!(hashMap instanceof Map)) {
            hashMap = new HashMap();
        }
        Map map2 = hashMap;
        map2.put(jViewport, n2);
        jViewport2.putClientProperty("synchronizeViewMasterViewport", map2);
    }

    public static void unsynchronizeView(JViewport jViewport, JViewport jViewport2) {
        Map map;
        if (jViewport == null || jViewport2 == null) {
            return;
        }
        Object object = jViewport.getClientProperty("synchronizeViewSlaveViewport");
        if (object instanceof Map) {
            map = (Map)object;
            map.remove(jViewport2);
            if (map.isEmpty()) {
                map = null;
                jViewport.removeChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
            }
            jViewport.putClientProperty("synchronizeViewSlaveViewport", map);
        }
        if ((object = jViewport2.getClientProperty("synchronizeViewMasterViewport")) instanceof Map) {
            map = (Map)object;
            map.remove(jViewport);
            if (map.isEmpty()) {
                map = null;
            }
            jViewport2.putClientProperty("synchronizeViewMasterViewport", map);
        }
    }

    public static int getButtonState(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        if (!buttonModel.isEnabled()) {
            if (buttonModel.isSelected()) {
                return 5;
            }
            return 4;
        }
        if (buttonModel.isPressed() && buttonModel.isArmed()) {
            if (buttonModel.isRollover()) {
                return 1;
            }
            if (buttonModel.isSelected()) {
                return 3;
            }
        } else {
            if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                if (buttonModel.isSelected()) {
                    return 1;
                }
                return 2;
            }
            if (buttonModel.isSelected()) {
                return 3;
            }
            if (abstractButton.hasFocus() && abstractButton.isFocusPainted()) {
                if (buttonModel.isSelected()) {
                    return 1;
                }
                return 2;
            }
        }
        return 0;
    }

    public static int[] getButtonState(JideSplitButton jideSplitButton) {
        int[] nArray = new int[2];
        SplitButtonModel splitButtonModel = (SplitButtonModel)jideSplitButton.getModel();
        if (!splitButtonModel.isEnabled()) {
            nArray[0] = splitButtonModel.isButtonSelected() ? 5 : 4;
        } else if (jideSplitButton.hasFocus() && jideSplitButton.isFocusPainted()) {
            if (splitButtonModel.isButtonSelected()) {
                nArray[0] = 3;
                nArray[1] = 7;
            } else if (splitButtonModel.isSelected()) {
                nArray[0] = 7;
                nArray[1] = 3;
            } else {
                nArray[0] = 2;
                nArray[1] = 7;
            }
        } else if (splitButtonModel.isPressed() && splitButtonModel.isArmed()) {
            if (splitButtonModel.isButtonRollover()) {
                nArray[0] = 1;
                nArray[1] = 7;
            } else if (splitButtonModel.isRollover()) {
                nArray[0] = 7;
                nArray[1] = 2;
            }
        } else if (jideSplitButton.isRolloverEnabled() && splitButtonModel.isButtonRollover()) {
            if (splitButtonModel.isButtonSelected()) {
                nArray[0] = 1;
                nArray[1] = 7;
            } else if (splitButtonModel.isSelected()) {
                nArray[0] = 2;
                nArray[1] = 1;
            } else {
                nArray[0] = 2;
                nArray[1] = 7;
            }
        } else if (jideSplitButton.isRolloverEnabled() && splitButtonModel.isRollover()) {
            if (splitButtonModel.isButtonSelected()) {
                nArray[0] = 1;
                nArray[1] = 2;
            } else if (splitButtonModel.isSelected()) {
                nArray[0] = 7;
                nArray[1] = 1;
            } else {
                nArray[0] = 7;
                nArray[1] = 2;
            }
        } else if (splitButtonModel.isButtonSelected()) {
            nArray[0] = 3;
            nArray[1] = 7;
        } else if (splitButtonModel.isSelected()) {
            nArray[0] = 7;
            nArray[1] = 3;
        } else {
            nArray[0] = 0;
            nArray[1] = 0;
        }
        return nArray;
    }

    public static boolean equals(Object object, Object object2) {
        return JideSwingUtilities.equals(object, object2, false);
    }

    public static boolean equals(Object object, Object object2, boolean bl) {
        if (object == object2) {
            return true;
        }
        if (object != null && object2 == null) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof CharSequence && object2 instanceof CharSequence) {
            return JideSwingUtilities.equals((CharSequence)object, (CharSequence)object2, true);
        }
        if (object instanceof Comparable && object2 instanceof Comparable && object.getClass().isAssignableFrom(object2.getClass())) {
            return ((Comparable)object).compareTo(object2) == 0;
        }
        if (object instanceof Comparable && object2 instanceof Comparable && object2.getClass().isAssignableFrom(object.getClass())) {
            return ((Comparable)object2).compareTo(object) == 0;
        }
        if (bl && object instanceof List && object2 instanceof List) {
            int n2;
            int n3 = ((List)object).size();
            if (n3 != (n2 = ((List)object2).size())) {
                return false;
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                if (JideSwingUtilities.equals(((List)object).get(i2), ((List)object2).get(i2), true)) continue;
                return false;
            }
            return true;
        }
        if (bl && object.getClass().isArray() && object2.getClass().isArray()) {
            int n4;
            int n5 = Array.getLength(object);
            if (n5 != (n4 = Array.getLength(object2))) {
                return false;
            }
            for (int i3 = 0; i3 < n5; ++i3) {
                if (JideSwingUtilities.equals(Array.get(object, i3), Array.get(object2, i3), true)) continue;
                return false;
            }
            return true;
        }
        return object.equals(object2);
    }

    public static boolean equals(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = charSequence.length();
        while (n4-- > 0) {
            char c2;
            char c3;
            if ((c3 = charSequence.charAt(n2++)) == (c2 = charSequence2.charAt(n3++)) || !bl && JideSwingUtilities.charsEqualIgnoreCase(c3, c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean charsEqualIgnoreCase(char c2, char c3) {
        return c2 == c3 || JideSwingUtilities.toUpperCase(c2) == JideSwingUtilities.toUpperCase(c3) || JideSwingUtilities.toLowerCase(c2) == JideSwingUtilities.toLowerCase(c3);
    }

    public static char toUpperCase(char c2) {
        if (c2 < 'a') {
            return c2;
        }
        if (c2 >= 'a' && c2 <= 'z') {
            return (char)(c2 + -32);
        }
        return Character.toUpperCase(c2);
    }

    public static char toLowerCase(char c2) {
        if (c2 < 'A' || c2 >= 'a' && c2 <= 'z') {
            return c2;
        }
        if (c2 >= 'A' && c2 <= 'Z') {
            return (char)(c2 + 32);
        }
        return Character.toLowerCase(c2);
    }

    public static BufferedImage getFasterScaledInstance(BufferedImage bufferedImage, int n2, int n3, Object object, boolean bl) {
        int n4;
        int n5;
        boolean bl2;
        int n6 = bufferedImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage bufferedImage2 = bufferedImage;
        BufferedImage bufferedImage3 = null;
        Graphics2D graphics2D = null;
        int n7 = bufferedImage2.getWidth();
        int n8 = bufferedImage2.getHeight();
        boolean bl3 = bl2 = bufferedImage.getTransparency() != 1;
        if (bl) {
            n5 = bufferedImage.getWidth();
            n4 = bufferedImage.getHeight();
        } else {
            n5 = n2;
            n4 = n3;
        }
        do {
            if (bl && n5 > n2 && (n5 /= 2) < n2) {
                n5 = n2;
            }
            if (bl && n4 > n3 && (n4 /= 2) < n3) {
                n4 = n3;
            }
            if (bufferedImage3 == null || bl2) {
                bufferedImage3 = new BufferedImage(n5, n4, n6);
                graphics2D = bufferedImage3.createGraphics();
            }
            if (graphics2D != null) {
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
                graphics2D.drawImage(bufferedImage2, 0, 0, n5, n4, 0, 0, n7, n8, null);
            }
            n7 = n5;
            n8 = n4;
            bufferedImage2 = bufferedImage3;
        } while (n5 != n2 || n4 != n3);
        if (graphics2D != null) {
            graphics2D.dispose();
        }
        if (n2 != bufferedImage2.getWidth() || n3 != bufferedImage2.getHeight()) {
            bufferedImage3 = new BufferedImage(n2, n3, n6);
            graphics2D = bufferedImage3.createGraphics();
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage3;
        }
        return bufferedImage2;
    }

    public static boolean shouldUseSystemFont() {
        boolean bl;
        String string = SecurityUtils.getProperty("jide.useSystemfont", "");
        if ("false".equals(string)) {
            return false;
        }
        if ("true".equals(string)) {
            return true;
        }
        if (SystemInfo.isJdk15Above() || SystemInfo.isCJKLocale()) {
            return true;
        }
        String string2 = null;
        try {
            string2 = (String)AccessController.doPrivileged(new _b("swing.useSystemFontSettings"));
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        boolean bl2 = bl = string2 != null && Boolean.valueOf(string2) != false;
        if (bl) {
            Object object = UIDefaultsLookup.get("Application.useSystemFontSettings");
            bl = object != null || Boolean.TRUE.equals(object);
        }
        return "true".equals(SecurityUtils.getProperty("defaultFont", "false")) || bl;
    }

    public static void printUIDefaults() {
        Enumeration enumeration = UIManager.getDefaults().keys();
        ArrayList<String> arrayList = new ArrayList<String>();
        System.out.println("Non-string keys ---");
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof String) {
                arrayList.add((String)object);
                continue;
            }
            System.out.println(object + " => " + UIDefaultsLookup.get(object));
        }
        System.out.println();
        Collections.sort(arrayList);
        System.out.println("String keys ---");
        for (String string : arrayList) {
            System.out.println(string + " => " + UIDefaultsLookup.get(string));
        }
    }

    public static void setRecursively(Component component, Handler handler) {
        JideSwingUtilities.n(component, handler);
        handler.postAction(component);
    }

    private static void n(Component component, Handler handler) {
        if (handler.condition(component)) {
            handler.action(component);
        }
        if (handler instanceof ConditionHandler && ((ConditionHandler)handler).stopCondition(component)) {
            return;
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof JTabbedPane) {
            Component[] componentArray2 = (Component[])component;
            componentArray = new Component[componentArray2.getTabCount()];
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                componentArray[i2] = componentArray2.getComponentAt(i2);
            }
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (Component component2 : componentArray) {
                JideSwingUtilities.n(component2, handler);
            }
        }
    }

    public static Component findFirstComponentByName(Container container, final String string) {
        if (string != null && string.trim().length() != 0) {
            return JideSwingUtilities.getRecursively(container, new GetHandler(){

                public boolean condition(Component component) {
                    return string.equals(component.getName());
                }

                public Component action(Component component) {
                    return component;
                }
            });
        }
        return null;
    }

    public static Component findFirstComponentByClass(Container container, final Class<?> clazz) {
        if (clazz != null) {
            return JideSwingUtilities.getRecursively(container, new GetHandler(){

                public boolean condition(Component component) {
                    return component.getClass().isAssignableFrom(clazz);
                }

                public Component action(Component component) {
                    return component;
                }
            });
        }
        return null;
    }

    public static Component getRecursively(Component component, GetHandler getHandler) {
        return JideSwingUtilities.i(component, getHandler);
    }

    private static Component i(Component component, GetHandler getHandler) {
        if (getHandler.condition(component)) {
            return getHandler.action(component);
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (Component component2 : componentArray) {
                Component component3 = JideSwingUtilities.i(component2, getHandler);
                if (component3 == null) continue;
                return component3;
            }
        }
        return null;
    }

    public static void setEnabledRecursively(Component component, final boolean bl) {
        JideSwingUtilities.setRecursively(component, new Handler(){

            public boolean condition(Component component) {
                return true;
            }

            public void action(Component component) {
                component.setEnabled(bl);
            }

            public void postAction(Component component) {
            }
        });
    }

    public static void putClientPropertyRecursively(Component component, final String string, final Object object) {
        JideSwingUtilities.setRecursively(component, new Handler(){

            public boolean condition(Component component) {
                return component instanceof JComponent;
            }

            public void action(Component component) {
                ((JComponent)component).putClientProperty(string, object);
            }

            public void postAction(Component component) {
            }
        });
    }

    public static void setRequestFocusEnabledRecursively(Component component, final boolean bl) {
        JideSwingUtilities.setRecursively(component, new Handler(){

            public boolean condition(Component component) {
                return true;
            }

            public void action(Component component) {
                if (component instanceof JComponent) {
                    ((JComponent)component).setRequestFocusEnabled(bl);
                }
            }

            public void postAction(Component component) {
            }
        });
    }

    public static void setOpaqueRecursively(Component component, final boolean bl) {
        JideSwingUtilities.setRecursively(component, new Handler(){

            public boolean condition(Component component) {
                return !(component instanceof JComboBox) && !(component instanceof JButton) && !(component instanceof JTextComponent) && !(component instanceof ListCellRenderer) && !(component instanceof TreeCellRenderer) && !(component instanceof TableCellRenderer) && !(component instanceof CellEditor);
            }

            public void action(Component component) {
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    if (Boolean.TRUE.equals(jComponent.getClientProperty(JideSwingUtilities.SET_OPAQUE_RECURSIVELY_EXCLUDED))) {
                        return;
                    }
                    Object object = jComponent.getClientProperty(JideSwingUtilities.b);
                    if (object != null) {
                        jComponent.removePropertyChangeListener("opaque", (PropertyChangeListener)object);
                        jComponent.putClientProperty(JideSwingUtilities.b, null);
                    }
                    jComponent.setOpaque(bl);
                    if (jComponent.getClientProperty(JideSwingUtilities.b) == null) {
                        if (bl) {
                            if (h == null) {
                                h = new PropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                        if (propertyChangeEvent.getSource() instanceof JComponent) {
                                            Component component = (Component)propertyChangeEvent.getSource();
                                            component.removePropertyChangeListener("opaque", this);
                                            if (component instanceof JComponent) {
                                                ((JComponent)component).setOpaque(true);
                                            }
                                            component.addPropertyChangeListener("opaque", this);
                                        }
                                    }
                                };
                            }
                            jComponent.addPropertyChangeListener("opaque", h);
                            jComponent.putClientProperty(JideSwingUtilities.b, h);
                        } else {
                            if (k == null) {
                                k = new PropertyChangeListener(){

                                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                                        if (propertyChangeEvent.getSource() instanceof JComponent && propertyChangeEvent.getSource() instanceof JComponent) {
                                            Component component = (Component)propertyChangeEvent.getSource();
                                            component.removePropertyChangeListener("opaque", this);
                                            if (component instanceof JComponent) {
                                                ((JComponent)component).setOpaque(false);
                                            }
                                            component.addPropertyChangeListener("opaque", this);
                                        }
                                    }
                                };
                            }
                            jComponent.addPropertyChangeListener("opaque", k);
                            jComponent.putClientProperty(JideSwingUtilities.b, k);
                        }
                    }
                }
            }

            public void postAction(Component component) {
            }
        });
    }

    public static Dimension getPreferredButtonSize(AbstractButton abstractButton, int n2, boolean bl) {
        if (abstractButton.getComponentCount() > 0) {
            return null;
        }
        Icon icon = abstractButton.getIcon();
        String string = abstractButton.getText();
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        JideSwingUtilities.layoutCompoundLabel(abstractButton, fontMetrics, string, icon, bl, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, string == null ? 0 : n2);
        Rectangle rectangle4 = rectangle.union(rectangle2);
        Insets insets = abstractButton.getInsets();
        rectangle4.width += insets.left + insets.right;
        rectangle4.height += insets.top + insets.bottom;
        return rectangle4.getSize();
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, boolean bl, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        boolean bl2 = true;
        int n7 = n3;
        int n8 = n5;
        if (jComponent != null && !jComponent.getComponentOrientation().isLeftToRight()) {
            bl2 = false;
        }
        switch (n3) {
            case 10: {
                n7 = bl2 ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl2 ? 4 : 2;
            }
        }
        switch (n5) {
            case 10: {
                n8 = bl2 ? 2 : 4;
                break;
            }
            case 11: {
                n8 = bl2 ? 4 : 2;
            }
        }
        return JideSwingUtilities.j(jComponent, fontMetrics, string, icon, bl, n2, n7, n4, n8, rectangle, rectangle2, rectangle3, n6);
    }

    public static String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, boolean bl, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        return JideSwingUtilities.j(null, fontMetrics, string, icon, bl, n2, n3, n4, n5, rectangle, rectangle2, rectangle3, n6);
    }

    private static String j(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, boolean bl, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        if (bl) {
            return JideSwingUtilities.k(jComponent, fontMetrics, string, icon, n2, n3, n4, n5, rectangle, rectangle2, rectangle3, n6);
        }
        return JideSwingUtilities.b(jComponent, fontMetrics, string, icon, n2, n3, n4, n5, rectangle, rectangle2, rectangle3, n6);
    }

    private static String d(String string) {
        if (string.indexOf(32) == -1) {
            return string;
        }
        int n2 = string.length();
        int n3 = -1;
        int n4 = string.length() / 2;
        int n5 = -1;
        while ((n5 = string.indexOf(32, n5 + 1)) != -1) {
            int n6 = Math.abs(n5 - n4);
            if (n6 >= n2) continue;
            n2 = n6;
            n3 = n5;
        }
        return n3 >= n4 ? string.substring(0, n3) : string.substring(n3 + 1);
    }

    private static String k(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        int n7;
        int n8;
        int n9;
        int n10;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = string == null || string.equals("");
        View view = null;
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
        } else {
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.width = (int)view.getPreferredSpan(0);
                rectangle3.height = (int)view.getPreferredSpan(1);
            } else {
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
                rectangle3.height = fontMetrics.getHeight();
            }
        }
        int n11 = n10 = bl || icon == null ? 0 : n6;
        if (!bl && rectangle3.width > (n9 = n5 == 0 ? rectangle.width : rectangle.width - (rectangle2.width + n10))) {
            if (view != null) {
                rectangle3.width = n9;
            } else {
                String string2 = "...";
                n8 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                for (n7 = 0; n7 < string.length() && (n8 += fontMetrics.charWidth(string.charAt(n7))) <= n9; ++n7) {
                }
                string = string.substring(0, n7) + string2;
                rectangle3.width = SwingUtilities.computeStringWidth(fontMetrics, string);
            }
        }
        rectangle3.y = n4 == 1 ? (n5 != 0 ? 0 : -(rectangle3.height + n10)) : (n4 == 0 ? (rectangle2.height >> 1) - (rectangle3.height >> 1) : (n5 != 0 ? rectangle2.height - rectangle3.height : rectangle2.height + n10));
        rectangle3.x = n5 == 2 ? -(rectangle3.width + n10) : (n5 == 0 ? (rectangle2.width >> 1) - (rectangle3.width >> 1) : rectangle2.width + n10);
        n9 = Math.min(rectangle2.x, rectangle3.x);
        int n12 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n9;
        n8 = Math.min(rectangle2.y, rectangle3.y);
        n7 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n8;
        int n13 = n2 == 1 ? rectangle.y - n8 : (n2 == 0 ? rectangle.y + (rectangle.height >> 1) - (n8 + (n7 >> 1)) : rectangle.y + rectangle.height - (n8 + n7));
        int n14 = n3 == 2 ? rectangle.x - n9 : (n3 == 4 ? rectangle.x + rectangle.width - (n9 + n12) : rectangle.x + (rectangle.width >> 1) - (n9 + (n12 >> 1)));
        rectangle3.x += n14;
        rectangle3.y += n13;
        rectangle2.x += n14;
        rectangle2.y += n13;
        return string;
    }

    private static String b(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = string == null || string.equals("");
        View view = null;
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
        } else {
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.height = (int)view.getPreferredSpan(0);
                rectangle3.width = (int)view.getPreferredSpan(1);
            } else {
                rectangle3.height = SwingUtilities.computeStringWidth(fontMetrics, string);
                rectangle3.width = fontMetrics.getHeight();
            }
        }
        int n13 = n12 = bl || icon == null ? 0 : n6;
        if (!bl && rectangle3.height > (n11 = n5 == 0 ? rectangle.height : rectangle.height - (rectangle2.height + n12))) {
            if (view != null) {
                rectangle3.height = n11;
            } else {
                String string2 = "...";
                n10 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                for (n9 = 0; n9 < string.length() && (n10 += fontMetrics.charWidth(string.charAt(n9))) <= n11; ++n9) {
                }
                string = string.substring(0, n9) + string2;
                rectangle3.height = SwingUtilities.computeStringWidth(fontMetrics, string);
            }
        }
        if (n4 == 1) {
            rectangle3.x = n5 != 0 ? 0 : -(rectangle3.width + n12);
        } else if (n4 == 0) {
            rectangle3.y = (rectangle2.width >> 1) - (rectangle3.width >> 1);
        } else {
            rectangle3.x = n5 != 0 ? rectangle2.width - rectangle3.width : rectangle2.width + n12;
        }
        rectangle3.y = n5 == 2 ? -(rectangle3.height + n12) : (n5 == 0 ? (rectangle2.height >> 1) - (rectangle3.height >> 1) : rectangle2.height + n12);
        n11 = Math.min(rectangle2.y, rectangle3.y);
        int n14 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n11;
        n10 = Math.min(rectangle2.x, rectangle3.x);
        n9 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n10;
        if (n2 == 1) {
            n8 = rectangle.x - n10;
            n7 = rectangle.x + rectangle.width - (n10 + n9);
        } else if (n2 == 0) {
            n7 = n8 = rectangle.x + (rectangle.width >> 1) - (n10 + (n9 >> 1));
        } else {
            n8 = rectangle.x + rectangle.width - (n10 + n9);
            n7 = rectangle.x - n10;
        }
        int n15 = n3 == 2 ? rectangle.y - n11 : (n3 == 4 ? rectangle.y + rectangle.height - (n11 + n14) : rectangle.y + (rectangle.height >> 1) - (n11 + (n14 >> 1)));
        rectangle3.y += n15;
        rectangle3.x += n8;
        rectangle2.y += n15;
        rectangle2.x += n7;
        return string;
    }

    public static int getOrientationOf(Component component) {
        Integer n2;
        if (component instanceof Alignable) {
            return ((Alignable)((Object)component)).getOrientation();
        }
        if (component instanceof JComponent && (n2 = (Integer)((JComponent)component).getClientProperty("orientation")) != null) {
            return n2;
        }
        return 0;
    }

    public static void setOrientationOf(Component component, int n2) {
        int n3 = JideSwingUtilities.getOrientationOf(component);
        if (n2 != n3) {
            if (component instanceof Alignable) {
                ((Alignable)((Object)component)).setOrientation(n2);
            } else if (component instanceof JComponent) {
                ((JComponent)component).putClientProperty("orientation", n2);
            }
        }
    }

    public static void setChildrenOrientationOf(Container container, int n2) {
        Component[] componentArray;
        for (Component component : componentArray = container.getComponents()) {
            JideSwingUtilities.setOrientationOf(component, n2);
        }
    }

    public static Map<Component, Boolean> disableDoubleBuffered(Component component) {
        final HashMap<Component, Boolean> hashMap = new HashMap<Component, Boolean>();
        if (component instanceof JComponent) {
            JideSwingUtilities.setRecursively(component, new Handler(){

                public boolean condition(Component component) {
                    return component instanceof JComponent && component.isDoubleBuffered();
                }

                public void action(Component component) {
                    hashMap.put(component, Boolean.TRUE);
                    ((JComponent)component).setDoubleBuffered(false);
                }

                public void postAction(Component component) {
                }
            });
        }
        return hashMap;
    }

    public static Map<Component, Boolean> enableDoubleBuffered(Component component) {
        final HashMap<Component, Boolean> hashMap = new HashMap<Component, Boolean>();
        if (component instanceof JComponent) {
            JideSwingUtilities.setRecursively(component, new Handler(){

                public boolean condition(Component component) {
                    return component instanceof JComponent && !component.isDoubleBuffered();
                }

                public void action(Component component) {
                    hashMap.put(component, Boolean.FALSE);
                    ((JComponent)component).setDoubleBuffered(true);
                }

                public void postAction(Component component) {
                }
            });
        }
        return hashMap;
    }

    public static void restoreDoubleBuffered(Component component, final Map<Component, Boolean> map) {
        JideSwingUtilities.setRecursively(component, new Handler(){

            public boolean condition(Component component) {
                return component instanceof JComponent;
            }

            public void action(Component component) {
                Boolean bl = (Boolean)map.get(component);
                if (bl != null) {
                    ((JComponent)component).setDoubleBuffered(Boolean.TRUE.equals(bl));
                }
            }

            public void postAction(Component component) {
            }
        });
    }

    public static void paintBackground(Graphics graphics, Rectangle rectangle, Color color, Color color2) {
        Color color3 = graphics.getColor();
        graphics.setColor(color2);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(color);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics.setColor(color3);
    }

    public static void paintBackground(Graphics2D graphics2D, Rectangle rectangle, Color color, Paint paint) {
        Color color2 = graphics2D.getColor();
        graphics2D.setPaint(paint);
        graphics2D.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        graphics2D.setColor(color);
        graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        graphics2D.setColor(color2);
    }

    private static boolean l(Component component) {
        if (!n) {
            if (component != null) {
                if (component instanceof JComponent) {
                    Boolean bl = (Boolean)((JComponent)component).getClientProperty(AA_TEXT_PROPERTY_KEY);
                    return bl != null ? bl : false;
                }
                return false;
            }
            return false;
        }
        return i;
    }

    public static boolean drawTextAntialiased(boolean bl) {
        if (!n) {
            return bl;
        }
        return i;
    }

    public static void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n2, int n3, int n4) {
        JideSwingUtilities.drawString(jComponent, graphics, string, n3, n4);
        if (n2 >= 0 && n2 < string.length()) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = n3 + fontMetrics.stringWidth(string.substring(0, n2));
            int n6 = n4;
            int n7 = fontMetrics.charWidth(string.charAt(n2));
            int n8 = 1;
            graphics.fillRect(n5, n6 + fontMetrics.getDescent() - 1, n7, n8);
        }
    }

    private static Map m(Graphics2D graphics2D, Map map, Map map2) {
        if (map2 == null) {
            map2 = new RenderingHints(null);
        } else {
            map2.clear();
        }
        if (map == null || map.size() == 0) {
            return map2;
        }
        Set set = map.keySet();
        for (Object k2 : set) {
            RenderingHints.Key key = (RenderingHints.Key)k2;
            Object object = graphics2D.getRenderingHint(key);
            if (object == null) continue;
            map2.put(key, object);
        }
        return map2;
    }

    public static void drawString(JComponent jComponent, Graphics graphics, String string, int n2, int n3) {
        if (SystemInfo.isJdk6Above()) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Map map = null;
            if (c != null) {
                map = JideSwingUtilities.m(graphics2D, c, null);
                graphics2D.addRenderingHints(c);
            }
            graphics2D.drawString(string, n2, n3);
            if (map != null) {
                graphics2D.addRenderingHints(map);
            }
        } else if (JideSwingUtilities.l(jComponent) && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.drawString(string, n2, n3);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            graphics.drawString(string, n2, n3);
        }
    }

    public static Object setupAntialiasing(Component component, Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (SystemInfo.isJdk6Above()) {
            object = JideSwingUtilities.m(graphics2D, c, null);
            if (c != null) {
                graphics2D.addRenderingHints(c);
            }
        } else {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (JideSwingUtilities.l(component)) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        return object;
    }

    public static void restoreAntialiasing(Component component, Graphics graphics, Object object) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (SystemInfo.isJdk6Above()) {
            if (object instanceof RenderingHints) {
                graphics2D.addRenderingHints((RenderingHints)object);
            }
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }

    public static Object setupShapeAntialiasing(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return object;
    }

    public static void restoreShapeAntialiasing(Graphics graphics, Object object) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public static void drawGrip(Graphics graphics, Rectangle rectangle, int n2, int n3) {
        JideSwingUtilities.drawGrip(graphics, rectangle, n2, n3, true);
    }

    public static void drawGrip(Graphics graphics, Rectangle rectangle, int n2, int n3, boolean bl) {
        if (rectangle.width > rectangle.height) {
            int n4 = n2;
            if (n2 * 3 > rectangle.width) {
                n4 = rectangle.width / 3;
            }
            int n5 = rectangle.x + (rectangle.width - n4 * 3 >> 1);
            int n6 = rectangle.y + (rectangle.height - n3 * 3 >> 1);
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int i3 = 0; i3 < n4; ++i3) {
                    if (bl) {
                        graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                        graphics.drawLine(n5 + i3 * 3, n6 + i2 * 3, n5 + i3 * 3, n6 + i2 * 3);
                    }
                    graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    graphics.drawLine(n5 + i3 * 3 + 1, n6 + i2 * 3 + 1, n5 + i3 * 3 + 1, n6 + i2 * 3 + 1);
                }
            }
        } else {
            int n7 = n2;
            if (n2 * 3 > rectangle.height) {
                n7 = rectangle.height / 3;
            }
            int n8 = rectangle.x + (rectangle.width - n3 * 3 >> 1);
            int n9 = rectangle.y + (rectangle.height - n7 * 3 >> 1);
            for (int i4 = 0; i4 < n3; ++i4) {
                for (int i5 = 0; i5 < n7; ++i5) {
                    if (bl) {
                        graphics.setColor(UIDefaultsLookup.getColor("controlLtHighlight"));
                        graphics.drawLine(n8 + i4 * 3, n9 + i5 * 3, n8 + i4 * 3, n9 + i5 * 3);
                    }
                    graphics.setColor(UIDefaultsLookup.getColor("controlShadow"));
                    graphics.drawLine(n8 + i4 * 3 + 1, n9 + i5 * 3 + 1, n8 + i4 * 3 + 1, n9 + i5 * 3 + 1);
                }
            }
        }
    }

    public static void registerTabKey(Container container) {
        if (container instanceof JComponent) {
            ((JComponent)container).registerKeyboardAction(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }, KeyStroke.getKeyStroke(9, 0), 0);
        } else {
            for (int i2 = 0; i2 < container.getComponentCount(); ++i2) {
                Component component = container.getComponent(i2);
                if (!(component instanceof JComponent) || !component.isFocusable()) continue;
                ((JComponent)container).registerKeyboardAction(new AbstractAction(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    }
                }, KeyStroke.getKeyStroke(9, 0), 0);
            }
        }
    }

    public static void fillGradient(Graphics graphics, Rectangle rectangle, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = new Color(255, 255, 255, 0);
        Color color2 = new Color(255, 255, 255, 48);
        Color color3 = new Color(0, 0, 0, 0);
        Color color4 = new Color(0, 0, 0, 32);
        if (n2 == 0) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height >> 1), color2, color, true);
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y + (rectangle.height >> 1), rectangle.width, rectangle.height >> 1), color3, color4, true);
        } else {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width >> 1, rectangle.height), color2, color, false);
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x + (rectangle.width >> 1), rectangle.y, rectangle.width >> 1, rectangle.height), color3, color4, false);
        }
    }

    public static void fillSingleGradient(Graphics graphics, Rectangle rectangle, int n2) {
        JideSwingUtilities.fillSingleGradient(graphics, rectangle, n2, 127);
    }

    public static void fillSingleGradient(Graphics graphics, Rectangle rectangle, int n2, int n3) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = new Color(255, 255, 255, 0);
        Color color2 = new Color(255, 255, 255, n3);
        if (n2 == 5) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color2, color, true);
        } else if (n2 == 1) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color, color2, true);
        } else if (n2 == 3) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color2, color, false);
        } else if (n2 == 7) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), color, color2, false);
        }
    }

    public static Paint getRadialGradientPaint(Point2D point2D, float f2, float[] fArray, Color[] colorArray) {
        Class<?> clazz = null;
        try {
            clazz = SystemInfo.isJdk6Above() ? Class.forName("java.awt.RadialGradientPaint") : Class.forName("org.apache.batik.ext.awt.RadialGradientPaint");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                if (f == null) {
                    f = clazz.getConstructor(Point2D.class, Float.TYPE, float[].class, Color[].class);
                }
                Object obj = f.newInstance(point2D, Float.valueOf(f2), fArray, colorArray);
                return (Paint)obj;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        System.err.println("Warning - radial gradients are only supported in Java 6 and higher or use batik-aw-util.jar, using a plain color instead");
        return colorArray[0];
    }

    public static Paint getRadialGradientPaint(float f2, float f3, float f4, float[] fArray, Color[] colorArray) {
        if (d == null) {
            try {
                d = SystemInfo.isJdk6Above() ? Class.forName("java.awt.RadialGradientPaint") : Class.forName("org.apache.batik.ext.awt.RadialGradientPaint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (d != null) {
            try {
                if (g == null) {
                    g = d.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, float[].class, Color[].class);
                }
                Object obj = g.newInstance(Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), fArray, colorArray);
                return (Paint)obj;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        System.err.println("Warning - radial gradients are only supported in Java 6 and higher or use batik-aw-util.jar, using a plain color instead");
        return colorArray[0];
    }

    public static Paint getLinearGradientPaint(float f2, float f3, float f4, float f5, float[] fArray, Color[] colorArray) {
        if (j == null) {
            try {
                j = SystemInfo.isJdk6Above() ? Class.forName("java.awt.LinearGradientPaint") : Class.forName("org.apache.batik.ext.awt.LinearGradientPaint");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (j != null) {
            try {
                if (m == null) {
                    m = j.getConstructor(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, float[].class, Color[].class);
                }
                Object obj = m.newInstance(Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), fArray, colorArray);
                return (Paint)obj;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        System.err.println("Warning - linear gradients are only supported in Java 6 and higher or use batik-aw-util.jar, using a plain color instead");
        return colorArray[0];
    }

    public static boolean containerContainsFocus(Container container) {
        boolean bl;
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean bl2 = bl = component != null && SwingUtilities.isDescendingFrom(component, container);
        if (!bl) {
            bl = component2 != null && SwingUtilities.isDescendingFrom(component2, container);
        }
        return bl;
    }

    public static boolean componentIsPermanentFocusOwner(Component component) {
        return component != null && KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner() == component;
    }

    public static void installColorsAndFont(Component component, Color color, Color color2, Font font) {
        JideSwingUtilities.installFont(component, font);
        JideSwingUtilities.installColors(component, color, color2);
    }

    public static void installFont(Component component, Font font) {
        Font font2 = component.getFont();
        if (font2 == null || font2 instanceof UIResource) {
            component.setFont(font);
        }
    }

    public static void installColors(Component component, Color color, Color color2) {
        Color color3 = component.getBackground();
        if (color != null && (color3 == null || color3 instanceof UIResource)) {
            component.setBackground(color);
        }
        Color color4 = component.getForeground();
        if (color2 != null && (color4 == null || color4 instanceof UIResource)) {
            component.setForeground(color2);
        }
    }

    public static void installBorder(JComponent jComponent, Border border) {
        Border border2 = jComponent.getBorder();
        if (border2 == null || border2 instanceof UIResource) {
            jComponent.setBorder(border);
        }
    }

    public static void fillNormalGradient(Graphics2D graphics2D, Shape shape, Color color, Color color2, boolean bl) {
        Rectangle rectangle = shape.getBounds();
        GradientPaint gradientPaint = bl ? new GradientPaint(rectangle.x, rectangle.y, color, rectangle.x, rectangle.height + rectangle.y, color2, true) : new GradientPaint(rectangle.x, rectangle.y, color, rectangle.width + rectangle.x, rectangle.y, color2, true);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(shape);
        graphics2D.setPaint(paint);
    }

    public static void fillGradient(Graphics2D graphics2D, Shape shape, Color color, Color color2, boolean bl) {
        if ("true".equals(SecurityUtils.getProperty("normalGradientPaint", "false"))) {
            JideSwingUtilities.fillNormalGradient(graphics2D, shape, color, color2, bl);
        } else {
            com.jidesoft.swing.b.c(graphics2D, shape, color, color2, bl);
        }
    }

    public static void clearGradientCache() {
        com.jidesoft.swing.b.b();
    }

    public static Window getTopModalDialog(Window window) {
        Window[] windowArray;
        for (Window window2 : windowArray = window.getOwnedWindows()) {
            if (!window2.isVisible() || !(window2 instanceof Dialog) || !((Dialog)window2).isModal()) continue;
            return JideSwingUtilities.getTopModalDialog(window2);
        }
        return window;
    }

    public static void traceFocus() {
        JideSwingUtilities.traceFocus(false);
    }

    public static void traceFocus(final boolean bl) {
        if (tracingFocus) {
            return;
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                Object object2;
                if (bl) {
                    object2 = (Component)propertyChangeEvent.getOldValue();
                    if (object2 instanceof JComponent && (object = ((JComponent)object2).getBorder()) instanceof TraceDebugBorder) {
                        ((JComponent)object2).setBorder(((TraceDebugBorder)object).getInsideBorder());
                    }
                    if ((object = (Component)propertyChangeEvent.getNewValue()) instanceof JComponent) {
                        Border border = ((JComponent)object).getBorder();
                        if (border == null) {
                            border = new EmptyBorder(0, 0, 0, 0);
                        }
                        if (!(border instanceof TraceDebugBorder)) {
                            ((JComponent)object).setBorder(new TraceDebugBorder(border));
                        }
                    }
                }
                Object object3 = object2 = propertyChangeEvent.getOldValue() == null ? "null" : propertyChangeEvent.getOldValue().getClass().getName();
                if (propertyChangeEvent.getOldValue() instanceof Component && ((Component)propertyChangeEvent.getOldValue()).getName() != null) {
                    object2 = (String)object2 + "'" + ((Component)propertyChangeEvent.getOldValue()).getName() + "'";
                }
                Object object4 = object = propertyChangeEvent.getNewValue() == null ? "null" : propertyChangeEvent.getNewValue().getClass().getName();
                if (propertyChangeEvent.getNewValue() instanceof Component && ((Component)propertyChangeEvent.getNewValue()).getName() != null) {
                    object = (String)object + "'" + ((Component)propertyChangeEvent.getNewValue()).getName() + "'";
                }
                System.out.println(propertyChangeEvent.getPropertyName() + ": " + (String)object2 + " ==> " + (String)object);
            }
        };
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", propertyChangeListener);
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("permanentFocusOwner", propertyChangeListener);
        DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("activeWindow", propertyChangeListener);
        tracingFocus = true;
    }

    public static void runGCAndPrintFreeMemory() {
        DecimalFormat decimalFormat = new DecimalFormat("###,###,##0.####");
        String string = decimalFormat.format(Runtime.getRuntime().freeMemory() / 1024L);
        String string2 = decimalFormat.format(Runtime.getRuntime().totalMemory() / 1024L);
        String string3 = decimalFormat.format((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
        System.out.println("before gc: (Total [" + string2 + "k] - Free [" + string + "k]) = Used [" + string3 + "k]");
        System.runFinalization();
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        string = decimalFormat.format(Runtime.getRuntime().freeMemory() / 1024L);
        string2 = decimalFormat.format(Runtime.getRuntime().totalMemory() / 1024L);
        string3 = decimalFormat.format((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
        System.out.println("after gc: (Total [" + string2 + "k] - Free [" + string + "k]) = Used [" + string3 + "k]");
    }

    public static JPanel createTableModelModifier(final DefaultTableModel defaultTableModel) {
        JPanel jPanel = new JPanel(new BorderLayout(6, 6));
        final JTable jTable = new JTable(defaultTableModel);
        jPanel.add(new JScrollPane(jTable));
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton jButton = new JButton("Insert");
        jButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Vector<Vector> vector = defaultTableModel.getDataVector();
                int n2 = jTable.getSelectedRow();
                if (n2 != -1) {
                    Vector vector2 = vector.get(n2);
                    Vector<Object> vector3 = new Vector<Object>();
                    for (int i2 = 0; i2 < vector2.size(); ++i2) {
                        if (i2 == 0) {
                            vector3.add((int)(Math.random() * 10.0));
                            continue;
                        }
                        vector3.add("" + vector2.get(i2));
                    }
                    defaultTableModel.insertRow(n2, vector3);
                }
            }
        });
        JButton jButton2 = new JButton("Delete");
        jButton2.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = jTable.getSelectedRows();
                for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
                    int n2 = nArray[i2];
                    defaultTableModel.removeRow(n2);
                }
            }
        });
        JButton jButton3 = new JButton("Clear");
        jButton3.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i2 = 0; i2 < defaultTableModel.getRowCount(); ++i2) {
                    defaultTableModel.removeRow(0);
                }
            }
        });
        buttonPanel.add(jButton);
        buttonPanel.add(jButton2);
        buttonPanel.add(jButton3);
        jPanel.add((Component)buttonPanel, "Last");
        return jPanel;
    }

    public static Component findSomethingFocusable(Container container) {
        Component[] componentArray;
        if (JideSwingUtilities.passesFocusabilityTest(container)) {
            container.requestFocusInWindow();
            return container;
        }
        for (Component component : componentArray = container.getComponents()) {
            Component component2;
            if (JideSwingUtilities.passesFocusabilityTest(component)) {
                container.requestFocusInWindow();
                return container;
            }
            if (!(component instanceof Container) || (component2 = JideSwingUtilities.findSomethingFocusable((Container)component)) == null) continue;
            return component2;
        }
        return null;
    }

    public static boolean passesFocusabilityTest(Component component) {
        return component != null && component.isEnabled() && component.isDisplayable() && component.isVisible() && component.isFocusable() && component.isShowing();
    }

    public static void ignoreException(Exception exception) {
    }

    public static void printException(Exception exception) {
        System.err.println(exception.getLocalizedMessage());
    }

    public static void throwException(Exception exception) {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    public static void throwInvocationTargetException(InvocationTargetException invocationTargetException) {
        if (invocationTargetException.getTargetException() instanceof RuntimeException) {
            throw (RuntimeException)invocationTargetException.getTargetException();
        }
        if (invocationTargetException.getTargetException() instanceof Error) {
            throw (Error)invocationTargetException.getTargetException();
        }
        throw new RuntimeException(invocationTargetException.getTargetException());
    }

    public static int findDisplayedMnemonicIndex(String string, int n2) {
        if (string == null || n2 == 0) {
            return -1;
        }
        char c2 = Character.toUpperCase((char)n2);
        char c3 = Character.toLowerCase((char)n2);
        int n3 = string.indexOf(c2);
        int n4 = string.indexOf(c3);
        if (n3 == -1) {
            return n4;
        }
        if (n4 == -1) {
            return n3;
        }
        return n4 < n3 ? n4 : n3;
    }

    public static Component getDescendantOfClass(Class clazz, Container container) {
        Component[] componentArray;
        if (container == null || clazz == null) {
            return null;
        }
        for (Component component : componentArray = container.getComponents()) {
            Component component2;
            if (clazz.isInstance(component)) {
                return component;
            }
            if (!(component instanceof Container) || (component2 = JideSwingUtilities.getDescendantOfClass(clazz, (Container)component)) == null) continue;
            return component2;
        }
        return null;
    }

    public static float getDefaultFontSize() {
        String string = SecurityUtils.getProperty("jide.fontSize", null);
        float f2 = -1.0f;
        try {
            if (string != null) {
                f2 = Float.parseFloat(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f2;
    }

    public static Object getMenuFont(Toolkit toolkit, UIDefaults uIDefaults) {
        Font font;
        Object object = null;
        float f2 = JideSwingUtilities.getDefaultFontSize();
        object = JideSwingUtilities.shouldUseSystemFont() ? (f2 == -1.0f ? uIDefaults.getFont("ToolBar.font") : new WindowsDesktopProperty("win.menu.font", uIDefaults.getFont("ToolBar.font"), toolkit, f2)) : ((font = uIDefaults.getFont("ToolBar.font")) == null ? SecurityUtils.createFontUIResource("Tahoma", 0, f2 != -1.0f ? (int)f2 : 11) : SecurityUtils.createFontUIResource(font.getFontName(), 0, f2 != -1.0f ? (int)f2 : font.getSize()));
        if (object == null) {
            return JideSwingUtilities.getControlFont(toolkit, uIDefaults);
        }
        return object;
    }

    public static Object getControlFont(Toolkit toolkit, UIDefaults uIDefaults) {
        Object object;
        float f2 = JideSwingUtilities.getDefaultFontSize();
        if (JideSwingUtilities.shouldUseSystemFont()) {
            Font font = uIDefaults.getFont("Label.font");
            if (font == null) {
                font = new Font("Tahoma", 0, 12);
            }
            object = f2 == -1.0f ? font : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, f2);
        } else {
            Font font = uIDefaults.getFont("Label.font");
            object = font == null ? SecurityUtils.createFontUIResource("Tahoma", 0, f2 != -1.0f ? (int)f2 : 11) : (f2 == -1.0f ? font : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, f2));
        }
        return object;
    }

    public static Object getBoldFont(Toolkit toolkit, UIDefaults uIDefaults) {
        Object object;
        if (SystemInfo.isCJKLocale()) {
            return JideSwingUtilities.getControlFont(toolkit, uIDefaults);
        }
        float f2 = JideSwingUtilities.getDefaultFontSize();
        if (JideSwingUtilities.shouldUseSystemFont()) {
            Font font = uIDefaults.getFont("Label.font");
            if (font == null) {
                font = new Font("Tahoma", 0, 12);
            }
            object = f2 == -1.0f ? new FontUIResource(font.deriveFont(1)) : new WindowsDesktopProperty("win.defaultGUI.font", font, toolkit, f2, 1);
        } else {
            Font font = uIDefaults.getFont("Label.font");
            object = font == null ? SecurityUtils.createFontUIResource("Tahoma", 1, f2 != -1.0f ? (int)f2 : 11) : SecurityUtils.createFontUIResource(font.getFontName(), 1, f2 != -1.0f ? (int)f2 : font.getSize());
        }
        return object;
    }

    public static void drawShadow(Graphics graphics, Component component, int n2, int n3, int n4, int n5) {
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        ShadowFactory shadowFactory = new ShadowFactory(6, 0.7f, Color.GRAY);
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setColor(Color.BLACK);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
        BufferedImage bufferedImage2 = shadowFactory.createShadow(bufferedImage);
        graphics.drawImage(bufferedImage2, n2, n3, component);
    }

    public static void drawImageBorder(Graphics graphics, ImageIcon imageIcon, Rectangle rectangle, Insets insets, boolean bl) {
        int n2 = insets.left;
        int n3 = insets.right;
        int n4 = insets.top;
        int n5 = insets.bottom;
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        graphics.drawImage(imageIcon.getImage(), n6, n7, n6 + n2, n7 + n4, 0, 0, n2, n4, null);
        graphics.drawImage(imageIcon.getImage(), n6 + n2, n7, n6 + n8 - n3, n7 + n4, n2, 0, imageIcon.getIconWidth() - n3, n4, null);
        graphics.drawImage(imageIcon.getImage(), n6 + n8 - n3, n7, n6 + n8, n7 + n4, imageIcon.getIconWidth() - n3, 0, imageIcon.getIconWidth(), n4, null);
        graphics.drawImage(imageIcon.getImage(), n6, n7 + n4, n6 + n2, n7 + n9 - n5, 0, n4, n2, imageIcon.getIconHeight() - n5, null);
        graphics.drawImage(imageIcon.getImage(), n6 + n2, n7 + n4, n6 + n8 - n3, n7 + n9 - n5, n2, n4, imageIcon.getIconWidth() - n3, imageIcon.getIconHeight() - n5, null);
        graphics.drawImage(imageIcon.getImage(), n6 + n8 - n3, n7 + n4, n6 + n8, n7 + n9 - n5, imageIcon.getIconWidth() - n3, n4, imageIcon.getIconWidth(), imageIcon.getIconHeight() - n5, null);
        graphics.drawImage(imageIcon.getImage(), n6, n7 + n9 - n5, n6 + n2, n7 + n9, 0, imageIcon.getIconHeight() - n5, n2, imageIcon.getIconHeight(), null);
        graphics.drawImage(imageIcon.getImage(), n6 + n2, n7 + n9 - n5, n6 + n8 - n3, n7 + n9, n2, imageIcon.getIconHeight() - n5, imageIcon.getIconWidth() - n3, imageIcon.getIconHeight(), null);
        graphics.drawImage(imageIcon.getImage(), n6 + n8 - n3, n7 + n9 - n5, n6 + n8, n7 + n9, imageIcon.getIconWidth() - n3, imageIcon.getIconHeight() - n5, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        if (bl) {
            graphics.drawImage(imageIcon.getImage(), n6 + n2, n7 + n4, n6 + n8 - n3, n7 + n9 - n5, n2, n4, imageIcon.getIconWidth() - n3, imageIcon.getIconHeight() - n5, null);
        }
    }

    public static boolean compositeRequestFocus(Component component) {
        e.fine("compositeRequestFocus " + component);
        if (component instanceof Container) {
            Object object;
            Object object2;
            e.fine("compositeRequestFocus is container.");
            Container container = (Container)component;
            if (container.isFocusCycleRoot()) {
                e.fine("compositeRequestFocus is focuscycleroot.");
                object2 = container.getFocusTraversalPolicy();
                object = ((FocusTraversalPolicy)object2).getDefaultComponent(container);
                e.fine("compositeRequestFocus default component = " + object);
                if (object != null && ((Component)object).isShowing() && container.getComponentCount() > 0) {
                    e.fine("compositeRequestFocus default component passesFocusabilityTest =" + JideSwingUtilities.passesFocusabilityTest((Component)object));
                    e.fine("compositeRequestFocus requestFocus for " + object);
                    return ((Component)object).requestFocusInWindow();
                }
            }
            if ((object2 = container.getFocusCycleRootAncestor()) != null) {
                e.fine("compositeRequestFocus using rootAncestor =" + object2);
                object = ((Container)object2).getFocusTraversalPolicy();
                Component component2 = null;
                try {
                    component2 = ((FocusTraversalPolicy)object).getComponentAfter((Container)object2, container);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                e.fine("compositeRequestFocus getComponentAfter =" + component2);
                if (component2 != null && SwingUtilities.isDescendingFrom(component2, container)) {
                    e.fine("compositeRequestFocus getComponentAfter passesFocusabilityTest =" + JideSwingUtilities.passesFocusabilityTest(component2));
                    e.fine("compositeRequestFocus requestFocus for " + component2);
                    return component2.requestFocusInWindow();
                }
            }
        }
        if (!JideSwingUtilities.passesFocusabilityTest(component)) {
            e.fine("compositeRequestFocus returingfalse because !passesFocusabilityTest" + component);
            return false;
        }
        e.fine("compositeRequestFocus component=" + component);
        return component.requestFocusInWindow();
    }

    public static boolean isAncestorOfFocusOwner(Component component) {
        boolean bl = false;
        Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (component == component2 || component instanceof Container && ((Container)component).isAncestorOf(component2)) {
            bl = true;
        }
        return bl;
    }

    public static Window getWindowForComponent(Component component) throws HeadlessException {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return JideSwingUtilities.getWindowForComponent(component.getParent());
    }

    public static boolean isKeyListenerRegistered(Component component, KeyListener keyListener) {
        KeyListener[] keyListenerArray;
        for (KeyListener keyListener2 : keyListenerArray = component.getKeyListeners()) {
            if (keyListener2 != keyListener) continue;
            return true;
        }
        return false;
    }

    public static void insertKeyListener(Component component, KeyListener keyListener, int n2) {
        KeyListener[] keyListenerArray;
        for (KeyListener keyListener2 : keyListenerArray = component.getKeyListeners()) {
            component.removeKeyListener(keyListener2);
        }
        for (int i2 = 0; i2 < keyListenerArray.length; ++i2) {
            KeyListener keyListener3 = keyListenerArray[i2];
            if (n2 == i2) {
                component.addKeyListener(keyListener);
            }
            component.addKeyListener(keyListener3);
        }
        if (n2 > keyListenerArray.length - 1) {
            component.addKeyListener(keyListener);
        }
    }

    public static void insertTableModelListener(TableModel tableModel, TableModelListener tableModelListener, int n2) {
        TableModelListener[] tableModelListenerArray;
        if (!(tableModel instanceof AbstractTableModel)) {
            tableModel.addTableModelListener(tableModelListener);
            return;
        }
        for (TableModelListener tableModelListener2 : tableModelListenerArray = ((AbstractTableModel)tableModel).getTableModelListeners()) {
            tableModel.removeTableModelListener(tableModelListener2);
        }
        for (int i2 = 0; i2 < tableModelListenerArray.length; ++i2) {
            TableModelListener tableModelListener3 = tableModelListenerArray[i2];
            if (n2 == i2) {
                tableModel.addTableModelListener(tableModelListener);
            }
            tableModel.addTableModelListener(tableModelListener3);
        }
        if (n2 < 0 || n2 > tableModelListenerArray.length - 1) {
            tableModel.addTableModelListener(tableModelListener);
        }
    }

    public static boolean isPropertyChangeListenerRegistered(Component component, PropertyChangeListener propertyChangeListener) {
        PropertyChangeListener[] propertyChangeListenerArray;
        for (PropertyChangeListener propertyChangeListener2 : propertyChangeListenerArray = component.getPropertyChangeListeners()) {
            if (propertyChangeListener2 != propertyChangeListener) continue;
            return true;
        }
        return false;
    }

    public static boolean isPropertyChangeListenerRegistered(Component component, String string, PropertyChangeListener propertyChangeListener) {
        PropertyChangeListener[] propertyChangeListenerArray;
        if (string == null) {
            return JideSwingUtilities.isPropertyChangeListenerRegistered(component, propertyChangeListener);
        }
        for (PropertyChangeListener propertyChangeListener2 : propertyChangeListenerArray = component.getPropertyChangeListeners(string)) {
            if (propertyChangeListener2 != propertyChangeListener) continue;
            return true;
        }
        return false;
    }

    public static boolean isMouseListenerRegistered(Component component, MouseListener mouseListener) {
        MouseListener[] mouseListenerArray;
        for (MouseListener mouseListener2 : mouseListenerArray = component.getMouseListeners()) {
            if (mouseListener2 != mouseListener) continue;
            return true;
        }
        return false;
    }

    public static void insertMouseListener(Component component, MouseListener mouseListener, int n2) {
        MouseListener[] mouseListenerArray;
        for (MouseListener mouseListener2 : mouseListenerArray = component.getMouseListeners()) {
            component.removeMouseListener(mouseListener2);
        }
        for (int i2 = 0; i2 < mouseListenerArray.length; ++i2) {
            MouseListener mouseListener3 = mouseListenerArray[i2];
            if (n2 == i2) {
                component.addMouseListener(mouseListener);
            }
            component.addMouseListener(mouseListener3);
        }
        if (n2 < 0 || n2 > mouseListenerArray.length - 1) {
            component.addMouseListener(mouseListener);
        }
    }

    public static boolean isMouseMotionListenerRegistered(Component component, MouseMotionListener mouseMotionListener) {
        MouseMotionListener[] mouseMotionListenerArray;
        for (MouseMotionListener mouseMotionListener2 : mouseMotionListenerArray = component.getMouseMotionListeners()) {
            if (mouseMotionListener2 != mouseMotionListener) continue;
            return true;
        }
        return false;
    }

    public static void insertMouseMotionListener(Component component, MouseMotionListener mouseMotionListener, int n2) {
        MouseMotionListener[] mouseMotionListenerArray;
        for (MouseMotionListener mouseMotionListener2 : mouseMotionListenerArray = component.getMouseMotionListeners()) {
            component.removeMouseMotionListener(mouseMotionListener2);
        }
        for (int i2 = 0; i2 < mouseMotionListenerArray.length; ++i2) {
            MouseMotionListener mouseMotionListener3 = mouseMotionListenerArray[i2];
            if (n2 == i2) {
                component.addMouseMotionListener(mouseMotionListener);
            }
            component.addMouseMotionListener(mouseMotionListener3);
        }
        if (n2 < 0 || n2 > mouseMotionListenerArray.length - 1) {
            component.addMouseMotionListener(mouseMotionListener);
        }
    }

    public static Component getScrollPane(Component component) {
        Component component2 = component;
        if (component instanceof JScrollPane) {
            return component;
        }
        if (component2.getParent() != null && component2.getParent().getParent() != null && component2.getParent().getParent() instanceof JScrollPane) {
            component2 = component2.getParent().getParent();
            return component2;
        }
        return null;
    }

    public static boolean isListenerRegistered(EventListenerList eventListenerList, Class clazz, EventListener eventListener) {
        Object[] objectArray = eventListenerList.getListenerList();
        return JideSwingUtilities.c(objectArray, clazz, eventListener);
    }

    public static boolean isListenerRegistered(Component component, Class clazz, EventListener eventListener) {
        Object[] objectArray = component.getListeners(clazz);
        return JideSwingUtilities.c(objectArray, clazz, eventListener);
    }

    private static boolean c(Object[] objectArray, Class clazz, EventListener eventListener) {
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != clazz || !objectArray[i2 + 1].equals(eventListener)) continue;
            return true;
        }
        return false;
    }

    public static Component getFirstChildOf(final Class<?> clazz, Component component) {
        return JideSwingUtilities.getRecursively(component, new GetHandler(){

            public boolean condition(Component component) {
                return clazz.isAssignableFrom(component.getClass());
            }

            public Component action(Component component) {
                return component;
            }
        });
    }

    public static int getComponentIndex(Container container, Component component) {
        if (component.getParent() != container) {
            return -1;
        }
        Component[] componentArray = container.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (componentArray[i2] != component) continue;
            return i2;
        }
        return -1;
    }

    public static Vector convertDefaultComboBoxModelToVector(DefaultComboBoxModel defaultComboBoxModel) {
        Vector vector = new Vector();
        for (int i2 = 0; i2 < defaultComboBoxModel.getSize(); ++i2) {
            vector.add(defaultComboBoxModel.getElementAt(i2));
        }
        return vector;
    }

    public static void ensureRowVisible(JTable jTable, int n2) {
        Rectangle rectangle;
        Rectangle rectangle2 = jTable.getVisibleRect();
        Rectangle rectangle3 = jTable.getCellRect(n2, 0, true);
        Rectangle rectangle4 = null;
        Rectangle rectangle5 = null;
        if (n2 < jTable.getModel().getRowCount() - 1) {
            rectangle5 = jTable.getCellRect(n2 + 1, 0, true);
        }
        if (n2 > 0) {
            rectangle4 = jTable.getCellRect(n2 - 1, 0, true);
        }
        int n3 = (int)rectangle3.getMinY();
        int n4 = (int)rectangle3.getMaxY();
        int n5 = rectangle2.x;
        int n6 = rectangle2.x + rectangle2.width;
        if (rectangle4 != null) {
            n3 = (int)rectangle4.getMinY();
        }
        if (rectangle5 != null) {
            n4 = (int)rectangle5.getMaxY();
        }
        if (!rectangle2.contains(rectangle = new Rectangle(n5, n3, n6 - n5, n4 - n3)) && rectangle.height != 0) {
            jTable.scrollRectToVisible(rectangle);
        }
    }

    public static void retargetMouseEvent(int n2, MouseEvent mouseEvent, Component component) {
        if (component == null || component == mouseEvent.getSource() && n2 == mouseEvent.getID()) {
            return;
        }
        if (mouseEvent.isConsumed()) {
            return;
        }
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), component);
        MouseEvent mouseEvent2 = new MouseEvent(component, n2, mouseEvent.getWhen(), mouseEvent.getModifiersEx() | mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        component.dispatchEvent(mouseEvent2);
    }

    public static JRootPane getOutermostRootPane(Component component) {
        if (component instanceof RootPaneContainer && component.getParent() == null) {
            return ((RootPaneContainer)((Object)component)).getRootPane();
        }
        while (component != null) {
            if (component instanceof JRootPane) {
                JRootPane jRootPane = (JRootPane)component;
                if (component.getParent().getParent() == null) {
                    return jRootPane;
                }
                if (component.getParent() instanceof JDialog || component.getParent() instanceof JWindow || component.getParent() instanceof JFrame || component.getParent() instanceof JApplet) {
                    return jRootPane;
                }
                component = component.getParent().getParent();
            }
            component = SwingUtilities.getRootPane(component);
        }
        return null;
    }

    public static boolean isFixedWidthFont(String string, Component component) {
        if (string.endsWith(" Bold") || string.endsWith(" ITC") || string.endsWith(" MT") || string.endsWith(" LET") || string.endsWith(".bold") || string.endsWith(".italic")) {
            return false;
        }
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            Font font = new Font(string, 0, 12);
            if (!font.canDisplay('W')) {
                return false;
            }
            Font font2 = font.deriveFont(1);
            FontMetrics fontMetrics = component.getFontMetrics(font);
            FontMetrics fontMetrics2 = component.getFontMetrics(font2);
            int n7 = fontMetrics.charWidth('l');
            if (n7 == (n6 = fontMetrics2.charWidth('l')) && (n5 = fontMetrics.charWidth('W')) == (n4 = fontMetrics2.charWidth('W')) && n7 == n5 && (n3 = fontMetrics.charWidth(' ')) == (n2 = fontMetrics2.charWidth(' '))) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public static void setLocaleRecursively(Component component, final Locale locale) {
        JideSwingUtilities.setRecursively(component, new Handler(){

            public boolean condition(Component component) {
                return true;
            }

            public void action(Component component) {
                component.setLocale(locale);
            }

            public void postAction(Component component) {
            }
        });
    }

    public static void setBounds(Container container, Component component, Rectangle rectangle) {
        if (container.getComponentOrientation().isLeftToRight()) {
            component.setBounds(rectangle);
        } else {
            Rectangle rectangle2 = new Rectangle(rectangle);
            int n2 = container.getWidth();
            rectangle2.x = n2 - (rectangle.x + rectangle.width);
            component.setBounds(rectangle2);
        }
    }

    public static void setBounds(Container container, Component component, int n2, int n3, int n4, int n5) {
        if (container.getComponentOrientation().isLeftToRight()) {
            component.setBounds(n2, n3, n4, n5);
        } else {
            int n6 = container.getWidth();
            component.setBounds(n6 - n2 - n4, n3, n4, n5);
        }
    }

    public static void invalidateRecursively(Component component) {
        if (component instanceof JComponent) {
            JideSwingUtilities.setRecursively(component, new Handler(){

                public boolean condition(Component component) {
                    return true;
                }

                public void action(Component component) {
                    if (component instanceof JComponent) {
                        ((JComponent)component).revalidate();
                    }
                    component.invalidate();
                }

                public void postAction(Component component) {
                }
            });
        }
        component.doLayout();
        component.repaint();
    }

    public static void synchronizeKeyboardActions(JComponent jComponent, JComponent jComponent2, KeyStroke[] keyStrokeArray, int n2) {
        for (KeyStroke keyStroke : keyStrokeArray) {
            ActionListener actionListener = jComponent.getActionForKeyStroke(keyStroke);
            if (actionListener == null) continue;
            jComponent2.registerKeyboardAction(actionListener, keyStroke, n2);
        }
    }

    public static JComponent getFirstJComponent(RootPaneContainer rootPaneContainer) {
        return (JComponent)JideSwingUtilities.getRecursively(rootPaneContainer.getContentPane(), new GetHandler(){

            public boolean condition(Component component) {
                return component instanceof JComponent;
            }

            public Component action(Component component) {
                return component;
            }
        });
    }

    public static Dimension adjustPreferredScrollableViewportSize(JList jList, Dimension dimension) {
        Dimension dimension2;
        Component component;
        ListCellRenderer<String> listCellRenderer;
        Rectangle rectangle = jList.getCellBounds(0, 0);
        if (rectangle != null && rectangle.height < 3 && (listCellRenderer = jList.getCellRenderer()) != null && (component = listCellRenderer.getListCellRendererComponent(jList, "DUMMY STRING", 0, false, false)) != null && (dimension2 = component.getPreferredSize()) != null) {
            int n2 = dimension2.height;
            if (n2 < 3) {
                try {
                    n2 = jList.getCellBounds((int)1, (int)1).height;
                }
                catch (Exception exception) {
                    n2 = 16;
                }
            }
            jList.setFixedCellHeight(n2);
        }
        if (SystemInfo.isJdk15Above()) {
            return dimension;
        }
        ++dimension.height;
        return dimension;
    }

    public static void removeFromParentWithFocusTransfer(Component component) {
        boolean bl = component.isVisible();
        component.setVisible(false);
        if (component.getParent() != null) {
            component.getParent().remove(component);
        }
        component.setVisible(bl);
    }

    public static int getLineHeight(Component component, int n2) {
        Font font;
        Font font2 = font = component == null ? null : component.getFont();
        if (font == null) {
            return n2;
        }
        FontMetrics fontMetrics = component.getFontMetrics(font);
        float f2 = fontMetrics.getHeight();
        return (int)(f2 += (float)fontMetrics.getDescent());
    }

    public static void addSeparatorIfNecessary(JPopupMenu jPopupMenu) {
        int n2 = jPopupMenu.getComponentCount();
        if (n2 > 0 && !(jPopupMenu.getComponent(n2 - 1) instanceof JSeparator)) {
            jPopupMenu.addSeparator();
        }
    }

    public static void removeExtraSeparators(JPopupMenu jPopupMenu) {
        Component[] componentArray = jPopupMenu.getComponents();
        if (componentArray.length <= 1) {
            return;
        }
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Component component = componentArray[i2];
            if (!(component instanceof JSeparator)) continue;
            if (i2 == 0 || i2 == componentArray.length - 1) {
                jPopupMenu.remove(component);
                continue;
            }
            if (!(componentArray[i2 - 1] instanceof JSeparator)) continue;
            jPopupMenu.remove(component);
        }
    }

    @Deprecated
    public static void setTextComponentTransparent(JComponent jComponent) {
        JideSwingUtilities.setComponentTransparent(jComponent);
    }

    public static void setComponentTransparent(JComponent jComponent) {
        jComponent.setOpaque(false);
        jComponent.putClientProperty("Synthetica.opaque", false);
        jComponent.putClientProperty("Nimbus.Overrides.InheritDefaults", false);
        jComponent.putClientProperty("Nimbus.Overrides", new UIDefaults());
    }

    public static int binarySearch(List<Object> list, Object object) {
        int n2 = 0;
        int n3 = list.size();
        int n4 = n3 / 2;
        while (n2 < n3) {
            if (!(list.get(n4) instanceof Comparable)) {
                return n4;
            }
            int n5 = ((Comparable)list.get(n4)).compareTo(object);
            if (n5 == 0) {
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return -1 * n4;
    }

    public static int binarySearch(Object[] objectArray, Object object) {
        int n2 = 0;
        int n3 = objectArray.length;
        int n4 = n3 / 2;
        while (n2 < n3) {
            if (!(objectArray[n4] instanceof Comparable)) {
                return n4;
            }
            int n5 = ((Comparable)objectArray[n4]).compareTo(object);
            if (n5 == 0) {
                return n4;
            }
            if (n5 < 0) {
                n2 = n4 + 1;
            } else {
                n3 = n4;
            }
            n4 = n2 + (n3 - n2) / 2;
        }
        return -1 * n4;
    }

    public static int binarySearch(int[] nArray, int n2) {
        return JideSwingUtilities.binarySearch(nArray, n2, 0, nArray.length);
    }

    public static int binarySearch(int[] nArray, int n2, int n3, int n4) {
        int n5 = n3;
        int n6 = n4;
        int n7 = n6 / 2;
        while (n5 < n6) {
            if (nArray[n7] == n2) {
                return n7;
            }
            if (nArray[n7] < n2) {
                n5 = n7 + 1;
            } else {
                n6 = n7;
            }
            n7 = n5 + (n6 - n5) / 2;
        }
        return -1 * n7;
    }

    public static boolean isMenuShortcutKeyDown(InputEvent inputEvent) {
        return (inputEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    public static boolean isMenuShortcutKeyDown(ActionEvent actionEvent) {
        return (actionEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    public static ChangeListener getViewportSynchronizationChangeListener() {
        if (o == null) {
            o = new _c();
        }
        return o;
    }

    public static void setWindowOpaque(Window window, boolean bl) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            method.invoke(null, window, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setWindowOpacity(Window window, float f2) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowOpacity", Window.class, Float.TYPE);
            method.invoke(null, window, Float.valueOf(f2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setWindowShape(Window window, Shape shape) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowShape", Window.class, Shape.class);
            method.invoke(null, window, shape);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getOKString(Locale locale) {
        String string = UIDefaultsLookup.getString("OptionPane.okButtonText", locale);
        if (!(string != null && string.length() > 0 || (string = UIDefaultsLookup.getString("ColorChooser.okText")) != null && string.length() > 0)) {
            string = ButtonResources.getResourceBundle(locale).getString("Button.ok");
        }
        return string;
    }

    public static String getCancelString(Locale locale) {
        String string = UIDefaultsLookup.getString("OptionPane.cancelButtonText", locale);
        if (!(string != null && string.length() > 0 || (string = UIDefaultsLookup.getString("ColorChooser.cancelText")) != null && string.length() > 0)) {
            string = ButtonResources.getResourceBundle(locale).getString("Button.cancel");
        }
        return string;
    }

    public static String getYesString(Locale locale) {
        String string = UIDefaultsLookup.getString("OptionPane.yesButtonText", locale);
        if (string == null || string.length() <= 0) {
            string = ButtonResources.getResourceBundle(locale).getString("Button.yes");
        }
        return string;
    }

    public static String getNoString(Locale locale) {
        String string = UIDefaultsLookup.getString("OptionPane.noButtonText", locale);
        if (string == null || string.length() <= 0) {
            string = ButtonResources.getResourceBundle(locale).getString("Button.no");
        }
        return string;
    }

    static {
        AA_TEXT_PROPERTY_KEY = new StringBuffer("AATextPropertyKey");
        Object object = SecurityUtils.getProperty("swing.aatext", "false");
        n = object != null;
        i = "true".equals(object);
        c = null;
        if (SystemInfo.isJdk6Above()) {
            object = Toolkit.getDefaultToolkit();
            c = (Map)((Toolkit)object).getDesktopProperty("awt.font.desktophints");
            ((Toolkit)object).addPropertyChangeListener("awt.font.desktophints", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getNewValue() instanceof RenderingHints) {
                        c = (RenderingHints)propertyChangeEvent.getNewValue();
                    }
                }
            });
        }
        tracingFocus = false;
        Font.getFont("defaultFont");
        Font.getFont("emphasizedFont");
    }

    private static class _c
    implements ChangeListener {
        private _c() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object;
            if (!(changeEvent.getSource() instanceof JViewport)) {
                return;
            }
            JViewport jViewport = (JViewport)changeEvent.getSource();
            Object object2 = jViewport.getClientProperty("synchronizeViewSlaveViewport");
            if (!(object2 instanceof Map)) {
                return;
            }
            Dimension dimension = jViewport.getSize();
            if (dimension.width == 0 || dimension.height == 0) {
                return;
            }
            Map map = (Map)object2;
            HashMap hashMap = new HashMap();
            hashMap.putAll(map);
            while (true) {
                HashMap hashMap2 = new HashMap();
                for (JViewport jViewport2 : hashMap.keySet()) {
                    object = jViewport2.getClientProperty("synchronizeViewSlaveViewport");
                    if (!(object instanceof Map)) continue;
                    int n2 = (Integer)hashMap.get(jViewport2);
                    Map map2 = (Map)object;
                    for (JViewport jViewport3 : map2.keySet()) {
                        if (jViewport3 == jViewport || hashMap.containsKey(jViewport3) || (Integer)map2.get(jViewport3) != n2) continue;
                        hashMap2.put(jViewport3, map2.get(jViewport3));
                    }
                }
                if (hashMap2.isEmpty()) break;
                hashMap.putAll(hashMap2);
            }
            for (Object object3 : hashMap.keySet()) {
                Point point;
                ((JViewport)object3).removeChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
                int n3 = (Integer)hashMap.get(object3);
                if (n3 == 0) {
                    object = jViewport.getViewPosition();
                    point = ((JViewport)object3).getViewPosition();
                    if (((Point)object).x != point.x) {
                        ((JViewport)object3).setViewPosition(new Point(((Point)object).x, point.y));
                    }
                } else if (n3 == 1) {
                    object = jViewport.getViewPosition();
                    point = ((JViewport)object3).getViewPosition();
                    if (((Point)object).y != point.y) {
                        ((JViewport)object3).setViewPosition(new Point(point.x, ((Point)object).y));
                    }
                }
                ((JViewport)object3).addChangeListener(JideSwingUtilities.getViewportSynchronizationChangeListener());
            }
        }
    }

    public static class TraceDebugBorder
    extends CompoundBorder {
        private static final long b = -1396250213346461982L;

        public TraceDebugBorder(Border border) {
            super(BorderFactory.createLineBorder(Color.RED, 1), border);
        }

        public Insets getBorderInsets(Component component) {
            return this.getInsideBorder().getBorderInsets(component);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            return this.getInsideBorder().getBorderInsets(component);
        }
    }

    public static interface GetHandler {
        public boolean condition(Component var1);

        public Component action(Component var1);
    }

    public static interface ConditionHandler
    extends Handler {
        public boolean stopCondition(Component var1);
    }

    public static interface Handler {
        public boolean condition(Component var1);

        public void action(Component var1);

        public void postAction(Component var1);
    }

    private static class _b
    implements PrivilegedAction {
        private String b;
        private String c;

        public _b(String string) {
            this.b = string;
        }

        public _b(String string, String string2) {
            this.b = string;
            this.c = string2;
        }

        public Object run() {
            String string = System.getProperty(this.b);
            return string == null ? this.c : string;
        }
    }
}

