/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ButtonStyle;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.DefaultSplitButtonModel;
import com.jidesoft.swing.JideMenu;
import com.jidesoft.swing.SplitButtonModel;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class JideSplitButton
extends JideMenu
implements ButtonStyle,
ComponentStateSupport {
    private static final String xb = "JideSplitButtonUI";
    private int bc = 0;
    private boolean ub = false;
    public static final String PROPERTY_ALWAYS_DROPDOWN = "alwaysDropdown";
    public static final String ACTION_PROPERTY_SPLIT_BUTTON_ENABLED = "JideSplitButtonEnabled";
    private Color vb;
    private Color cc;
    private Color dc;
    private Color zb;
    private Color yb;
    private Color ac;
    private Color wb;

    public JideSplitButton() {
        this.initComponent();
    }

    public JideSplitButton(String string) {
        super(string);
        this.initComponent();
    }

    public JideSplitButton(String string, Icon icon) {
        super(string);
        this.setIcon(icon);
        this.initComponent();
    }

    public JideSplitButton(Icon icon) {
        super("");
        this.setIcon(icon);
        this.initComponent();
    }

    public JideSplitButton(Action action) {
        super(action);
        this.initComponent();
    }

    protected void initComponent() {
        this.setModel(new DefaultSplitButtonModel());
        if (this.getAction() != null) {
            this.configurePropertiesFromAction(this.getAction());
        }
        this.setFocusable(true);
        this.setRequestFocusEnabled(false);
    }

    public ButtonUI getUI() {
        return (ButtonUI)this.ui;
    }

    public void setUI(ButtonUI buttonUI) {
        super.setUI(buttonUI);
    }

    public void updateUI() {
        if (UIDefaultsLookup.get(xb) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return xb;
    }

    public boolean isButtonSelected() {
        return this.model instanceof SplitButtonModel && ((DefaultSplitButtonModel)this.model).isButtonSelected();
    }

    public void setButtonSelected(boolean bl) {
        if (this.model instanceof SplitButtonModel) {
            ((DefaultSplitButtonModel)this.model).setButtonSelected(bl);
        }
    }

    public boolean isButtonEnabled() {
        return this.model instanceof SplitButtonModel && ((DefaultSplitButtonModel)this.model).isButtonEnabled();
    }

    public void setButtonEnabled(boolean bl) {
        if (this.model instanceof SplitButtonModel) {
            ((DefaultSplitButtonModel)this.model).setButtonEnabled(bl);
        }
    }

    public int getButtonStyle() {
        return this.bc;
    }

    public void setButtonStyle(int n2) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("Only TOOLBAR_STYLE, TOOLBOX_STYLE, and FLAT_STYLE are supported");
        }
        if (n2 == this.bc) {
            return;
        }
        int n3 = this.bc;
        this.bc = n2;
        this.firePropertyChange("buttonStyle", n3, this.bc);
    }

    public boolean isAlwaysDropdown() {
        return this.ub;
    }

    public void setAlwaysDropdown(boolean bl) {
        if (this.ub != bl) {
            boolean bl2 = this.ub;
            this.ub = bl;
            this.firePropertyChange(PROPERTY_ALWAYS_DROPDOWN, bl2, bl);
        }
    }

    public void setText(String string) {
        Boolean bl = (Boolean)this.getClientProperty("hideActionText");
        if (bl == null || Boolean.FALSE.equals(bl)) {
            super.setText(string);
        }
    }

    public Color getDefaultForeground() {
        return this.vb;
    }

    public void setDefaultForeground(Color color) {
        this.vb = color;
    }

    private Color jb() {
        return this.cc;
    }

    private void tb(Color color) {
        this.cc = color;
    }

    private Color mb() {
        return this.dc;
    }

    private void pb(Color color) {
        this.dc = color;
    }

    private Color qb() {
        return this.zb;
    }

    private void sb(Color color) {
        this.zb = color;
    }

    private Color ib() {
        return this.yb;
    }

    private void rb(Color color) {
        this.yb = color;
    }

    private Color lb() {
        return this.ac;
    }

    private void kb(Color color) {
        this.ac = color;
    }

    private Color ob() {
        return this.wb;
    }

    private void nb(Color color) {
        this.wb = color;
    }

    public Color getBackgroundOfState(int n2) {
        switch (n2) {
            case 0: {
                return this.getBackground();
            }
            case 2: {
                return this.jb();
            }
            case 3: {
                return this.mb();
            }
            case 1: {
                return this.qb();
            }
        }
        return null;
    }

    public void setBackgroundOfState(int n2, Color color) {
        switch (n2) {
            case 0: {
                this.setBackground(color);
                break;
            }
            case 2: {
                this.tb(color);
                break;
            }
            case 3: {
                this.pb(color);
                break;
            }
            case 1: {
                this.sb(color);
            }
        }
    }

    public Color getForegroundOfState(int n2) {
        switch (n2) {
            case 0: {
                return this.getDefaultForeground();
            }
            case 2: {
                return this.ib();
            }
            case 3: {
                return this.lb();
            }
            case 1: {
                return this.ob();
            }
        }
        return null;
    }

    public void setForegroundOfState(int n2, Color color) {
        switch (n2) {
            case 0: {
                this.setDefaultForeground(color);
                break;
            }
            case 2: {
                this.rb(color);
                break;
            }
            case 3: {
                this.kb(color);
                break;
            }
            case 1: {
                this.nb(color);
            }
        }
    }

    public void doClick() {
        Action action = this.getActionMap().get("pressed");
        if (action != null) {
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    public void doClickOnMenu() {
        Action action = this.getActionMap().get("downPressed");
        if (action != null) {
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        this.setButtonEnabled(JideSplitButton.isSplitButtonEnabled(action));
        this.setIconFromAction(action);
    }

    protected void setIconFromAction(Action action) {
        Icon icon = null;
        if (action != null) {
            Icon icon2 = icon = SystemInfo.isJdk6Above() ? (Icon)action.getValue("SwingLargeIconKey") : null;
            if (icon == null) {
                icon = (Icon)action.getValue("SmallIcon");
            }
        }
        this.setIcon(icon);
    }

    protected void actionPropertyChanged(Action action, String string) {
        super.actionPropertyChanged(action, string);
        if (ACTION_PROPERTY_SPLIT_BUTTON_ENABLED.equals(string) || "enabled".equals(string)) {
            this.setButtonEnabled(JideSplitButton.isSplitButtonEnabled(action));
        } else if ("SmallIcon".equals(string)) {
            if (!SystemInfo.isJdk6Above() || action.getValue("SwingLargeIconKey") == null) {
                this.setIconFromAction(action);
            }
        } else if (SystemInfo.isJdk6Above() && "SwingLargeIconKey".equals(string)) {
            this.setIconFromAction(action);
        }
    }

    public static boolean isSplitButtonEnabled(Action action) {
        if (action == null) {
            return true;
        }
        Object object = action.getValue(ACTION_PROPERTY_SPLIT_BUTTON_ENABLED);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return action.isEnabled();
    }
}

