/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericRange
extends AbstractNumericRange<Double> {
    protected double _min;
    protected double _max;

    public NumericRange() {
        this(0.0, 1.0);
    }

    public NumericRange(double d2, double d3) {
        this._min = Math.min(d2, d3);
        this._max = Math.max(d2, d3);
    }

    public NumericRange(NumericRange numericRange) {
        this(numericRange.minimum(), numericRange.maximum());
    }

    @Override
    public Range<Double> copy() {
        return new NumericRange(this);
    }

    @Override
    public double minimum() {
        return this._min;
    }

    @Override
    public double maximum() {
        return this._max;
    }

    public double getMin() {
        return this._min;
    }

    public void setMin(double d2) {
        double d3 = this._min;
        if (d3 == d2) {
            return;
        }
        assert (d2 <= this._max);
        this._min = d2;
        this.firePropertyChange("min", d3, d2);
    }

    public double getMax() {
        return this._max;
    }

    public void setMax(double d2) {
        double d3 = this._max;
        if (d3 == d2) {
            return;
        }
        assert (d2 >= this._min);
        this._max = d2;
        this.firePropertyChange("max", d3, d2);
    }

    @Override
    public double size() {
        return this._max - this._min;
    }

    @Override
    public Double lower() {
        return this.minimum();
    }

    @Override
    public void adjust(Double d2, Double d3) {
        this.setMin(d2);
        this.setMax(d3);
    }

    @Override
    public Double upper() {
        return this.maximum();
    }

    @Override
    public boolean contains(Double d2) {
        return d2 != null && d2 >= this._min && d2 <= this._max;
    }

    public NumericRange stretch(double d2) {
        return this.stretch(d2, d2);
    }

    public NumericRange stretch(double d2, double d3) {
        double d4 = (this._max + this._min) / 2.0;
        double d5 = this.size() / 2.0;
        return new NumericRange(d4 - d5 * d2, d4 + d5 * d3);
    }

    public boolean equals(Object object) {
        if (object instanceof NumericRange) {
            NumericRange numericRange = (NumericRange)object;
            return this._min == numericRange._min && this._max == numericRange._max;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this._max * 29.0 + this._min);
    }

    public String toString() {
        return String.format("#<NumericRange min=%f max=%f>", this._min, this._max);
    }

    public static NumericRange union(NumericRange numericRange, NumericRange numericRange2) {
        if (numericRange == null) {
            return numericRange2;
        }
        if (numericRange2 == null) {
            return numericRange;
        }
        double d2 = numericRange._min;
        double d3 = numericRange2._min;
        double d4 = numericRange._max;
        double d5 = numericRange2._max;
        double d6 = Math.min(d2, d3);
        double d7 = Math.max(d4, d5);
        return new NumericRange(d6, d7);
    }
}

