/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.plaf.DockableFrameUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicDockableFrameTitlePane;
import com.jidesoft.plaf.basic.ThemePainter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;

public class BasicDockableFrameUI
extends DockableFrameUI {
    protected DockableFrame _frame;
    protected PropertyChangeListener _propertyChangeListener;
    protected LayoutManager _dockableFrameLayout;
    protected JComponent _northPane;
    protected JComponent _southPane;
    protected JComponent _westPane;
    protected JComponent _eastPane;
    protected BasicDockableFrameTitlePane _titlePane;
    private boolean d = false;
    private boolean b = false;
    private ThemePainter c;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDockableFrameUI((DockableFrame)jComponent);
    }

    public BasicDockableFrameUI() {
    }

    public BasicDockableFrameUI(DockableFrame dockableFrame) {
        this._frame = dockableFrame;
    }

    public void installUI(JComponent jComponent) {
        this._frame = (DockableFrame)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installComponents();
        this.installKeyboardActions();
        this._frame.setOpaque(true);
    }

    public void uninstallUI(JComponent jComponent) {
        if (this._frame == null) {
            return;
        }
        if (jComponent != this._frame) {
            throw new IllegalComponentStateException(this + " was asked to uninstall() " + jComponent + " when it only knows about " + this._frame + ".");
        }
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this._frame = null;
    }

    protected void installDefaults() {
        this.c = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        Container container = this._frame.getContentPane();
        if (container instanceof JComponent) {
            ((JComponent)container).setOpaque(false);
        }
        this._dockableFrameLayout = this.createLayoutManager();
        this._frame.setLayout(this._dockableFrameLayout);
        this._frame.setBackground(UIDefaultsLookup.getColor("DockableFrame.background"));
        LookAndFeel.installBorder(this._frame, "DockableFrame.border");
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.c();
        SwingUtilities.replaceUIActionMap(this._frame, actionMap);
    }

    ActionMap c() {
        ActionMap actionMap = (ActionMap)UIDefaultsLookup.get("DockableFrame.actionMap");
        if (actionMap == null && (actionMap = this.b()) != null) {
            UIManager.getLookAndFeelDefaults().put("DockableFrame.actionMap", actionMap);
        }
        return actionMap;
    }

    ActionMap b() {
        return new ActionMapUIResource();
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this._frame));
        this.setSouthPane(this.createSouthPane(this._frame));
        this.setEastPane(this.createEastPane(this._frame));
        this.setWestPane(this.createWestPane(this._frame));
    }

    protected void installListeners() {
        this._propertyChangeListener = this.createPropertyChangeListener();
        this._frame.addPropertyChangeListener(this._propertyChangeListener);
    }

    InputMap d(int n2) {
        if (n2 == 2) {
            return this.e(n2);
        }
        return null;
    }

    InputMap e(int n2) {
        Object[] objectArray;
        if (n2 == 2 && (objectArray = (Object[])UIDefaultsLookup.get("DockableFrame.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this._frame, objectArray);
        }
        return null;
    }

    protected void uninstallDefaults() {
        this._dockableFrameLayout = null;
        this._frame.setLayout(null);
        LookAndFeel.uninstallBorder(this._frame);
        this.c = null;
    }

    protected void uninstallComponents() {
        if (this._titlePane != null) {
            this._titlePane.uninstallTitlePane();
            this._titlePane = null;
        }
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
    }

    protected void uninstallListeners() {
        this._frame.removePropertyChangeListener(this._propertyChangeListener);
        this._propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this._frame, 2, null);
        SwingUtilities.replaceUIActionMap(this._frame, null);
    }

    public Component getTitlePane() {
        return this._northPane;
    }

    protected LayoutManager createLayoutManager() {
        return new DockableFrameLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new DockableFramePropertyChangeListener();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this._frame == jComponent) {
            return this._frame.getLayout().preferredLayoutSize(jComponent);
        }
        return new Dimension(100, 100);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this._frame == jComponent) {
            return this._frame.getLayout().minimumLayoutSize(jComponent);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void replacePane(JComponent jComponent, JComponent jComponent2) {
        if (jComponent != null) {
            this.deinstallMouseHandlers(jComponent);
            this._frame.remove(jComponent);
        }
        if (jComponent2 != null) {
            this._frame.add(jComponent2);
            this.installMouseHandlers(jComponent2);
        }
    }

    protected void deinstallMouseHandlers(JComponent jComponent) {
    }

    protected void installMouseHandlers(JComponent jComponent) {
    }

    protected JComponent createNorthPane(DockableFrame dockableFrame) {
        this._titlePane = new BasicDockableFrameTitlePane(dockableFrame);
        return this._titlePane;
    }

    protected JComponent createSouthPane(DockableFrame dockableFrame) {
        return null;
    }

    protected JComponent createWestPane(DockableFrame dockableFrame) {
        return null;
    }

    protected JComponent createEastPane(DockableFrame dockableFrame) {
        return null;
    }

    protected final boolean isKeyBindingRegistered() {
        return this.d;
    }

    protected final void setKeyBindingRegistered(boolean bl) {
        this.d = bl;
    }

    public final boolean isKeyBindingActive() {
        return this.b;
    }

    protected final void setKeyBindingActive(boolean bl) {
        this.b = bl;
    }

    protected void setupMenuOpenKey() {
        InputMap inputMap = this.d(2);
        SwingUtilities.replaceUIInputMap(this._frame, 2, inputMap);
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this._northPane;
    }

    protected void setNorthPane(JComponent jComponent) {
        if (this._northPane != null && this._northPane instanceof BasicDockableFrameTitlePane) {
            ((BasicDockableFrameTitlePane)this._northPane).uninstallListeners();
        }
        this.replacePane(this._northPane, jComponent);
        this._northPane = jComponent;
    }

    public JComponent getSouthPane() {
        return this._southPane;
    }

    protected void setSouthPane(JComponent jComponent) {
        this._southPane = jComponent;
    }

    public JComponent getWestPane() {
        return this._westPane;
    }

    protected void setWestPane(JComponent jComponent) {
        this._westPane = jComponent;
    }

    public JComponent getEastPane() {
        return this._eastPane;
    }

    protected void setEastPane(JComponent jComponent) {
        this._eastPane = jComponent;
    }

    public ThemePainter getPainter() {
        return this.c;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        ThemePainter themePainter = this.getPainter();
        if (themePainter != null) {
            themePainter.paintDockableFrameBackground(jComponent, graphics, new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight()), 0, 0);
        }
    }

    public class DockableFrameLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension;
            Insets insets = BasicDockableFrameUI.this._frame.getInsets();
            Dimension dimension2 = !BasicDockableFrameUI.this._frame.isShowContentPane() ? new Dimension(0, 0) : (BasicDockableFrameUI.this._frame.getRootPane() == null || !BasicDockableFrameUI.this._frame.getRootPane().isVisible() ? new Dimension() : BasicDockableFrameUI.this._frame.getRootPane().getPreferredSize());
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
            if (BasicDockableFrameUI.this.getNorthPane() != null && BasicDockableFrameUI.this._frame.isShowTitleBar()) {
                dimension = BasicDockableFrameUI.this.getNorthPane().getPreferredSize();
                dimension2.width = Math.max(dimension.width, dimension2.width);
                dimension2.height += dimension.height;
            }
            if (BasicDockableFrameUI.this.getSouthPane() != null) {
                dimension = BasicDockableFrameUI.this.getSouthPane().getPreferredSize();
                dimension2.width = Math.max(dimension.width, dimension2.width);
                dimension2.height += dimension.height;
            }
            if (BasicDockableFrameUI.this.getEastPane() != null) {
                dimension = BasicDockableFrameUI.this.getEastPane().getPreferredSize();
                dimension2.width += dimension.width;
                dimension2.height = Math.max(dimension.height, dimension2.height);
            }
            if (BasicDockableFrameUI.this.getWestPane() != null) {
                dimension = BasicDockableFrameUI.this.getWestPane().getPreferredSize();
                dimension2.width += dimension.width;
                dimension2.height = Math.max(dimension.height, dimension2.height);
            }
            return dimension2;
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension;
            Dimension dimension2 = new Dimension();
            if (BasicDockableFrameUI.this._frame.isShowTitleBar() && BasicDockableFrameUI.this.getNorthPane() != null && BasicDockableFrameUI.this.getNorthPane() instanceof BasicDockableFrameTitlePane) {
                dimension2 = new Dimension(BasicDockableFrameUI.this.getNorthPane().getMinimumSize());
            }
            Dimension dimension3 = !BasicDockableFrameUI.this._frame.isShowContentPane() ? new Dimension(0, 0) : (dimension = BasicDockableFrameUI.this._frame.getRootPane() == null || !BasicDockableFrameUI.this._frame.getRootPane().isVisible() ? new Dimension() : BasicDockableFrameUI.this._frame.getRootPane().getMinimumSize());
            if (dimension.width > dimension2.width) {
                dimension2.width = dimension.width;
            }
            dimension2.height += dimension.height;
            Insets insets = BasicDockableFrameUI.this._frame.getInsets();
            dimension2.width += insets.left + insets.right;
            dimension2.height += insets.top + insets.bottom;
            return dimension2;
        }

        public void layoutContainer(Container container) {
            Dimension dimension;
            Insets insets = BasicDockableFrameUI.this._frame.getInsets();
            int n2 = insets.left;
            int n3 = insets.top;
            int n4 = BasicDockableFrameUI.this._frame.getWidth() - insets.left - insets.right;
            int n5 = BasicDockableFrameUI.this._frame.getHeight() - insets.top - insets.bottom;
            if (BasicDockableFrameUI.this.getNorthPane() != null && !BasicDockableFrameUI.this._frame.isShowTitleBar()) {
                BasicDockableFrameUI.this.getNorthPane().setVisible(false);
            } else if (BasicDockableFrameUI.this.getNorthPane() != null && BasicDockableFrameUI.this._frame.isShowTitleBar()) {
                BasicDockableFrameUI.this.getNorthPane().setVisible(true);
                dimension = BasicDockableFrameUI.this.getNorthPane().getPreferredSize();
                BasicDockableFrameUI.this.getNorthPane().setBounds(n2, n3, n4, dimension.height);
                n3 += dimension.height;
                n5 -= dimension.height;
            }
            if (BasicDockableFrameUI.this.getSouthPane() != null) {
                dimension = BasicDockableFrameUI.this.getSouthPane().getPreferredSize();
                BasicDockableFrameUI.this.getSouthPane().setBounds(n2, BasicDockableFrameUI.this._frame.getHeight() - insets.bottom - dimension.height, n4, dimension.height);
                n5 -= dimension.height;
            }
            if (BasicDockableFrameUI.this.getWestPane() != null) {
                dimension = BasicDockableFrameUI.this.getWestPane().getPreferredSize();
                BasicDockableFrameUI.this.getWestPane().setBounds(n2, n3, dimension.width, n5);
                n4 -= dimension.width;
                n2 += dimension.width;
            }
            if (BasicDockableFrameUI.this.getEastPane() != null) {
                dimension = BasicDockableFrameUI.this.getEastPane().getPreferredSize();
                BasicDockableFrameUI.this.getEastPane().setBounds(n4 - dimension.width, n3, dimension.width, n5);
                n4 -= dimension.width;
            }
            if (BasicDockableFrameUI.this._frame.getRootPane() != null) {
                if (BasicDockableFrameUI.this._frame.isShowContentPane() && BasicDockableFrameUI.this._frame.getRootPane().isVisible()) {
                    BasicDockableFrameUI.this._frame.getRootPane().setBounds(n2, n3, n4, n5);
                } else {
                    BasicDockableFrameUI.this._frame.getRootPane().setBounds(n2, n3, n4, 0);
                }
            }
        }
    }

    public class DockableFramePropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if (!(object instanceof DockableFrame)) {
                return;
            }
            DockableFrame dockableFrame = (DockableFrame)object;
            Object object2 = propertyChangeEvent.getNewValue();
            if ("docked".equals(string)) {
                if (Boolean.TRUE.equals(object2)) {
                    LookAndFeel.installBorder(BasicDockableFrameUI.this._frame, "DockableFrame.border");
                }
            } else if ("autohideShowing".equals(string)) {
                if (Boolean.TRUE.equals(object2) && dockableFrame.isSlidingAutohide()) {
                    dockableFrame.applyComponentOrientation(dockableFrame.getDockingManager().getDockedFrameContainer().getComponentOrientation());
                    boolean bl = dockableFrame.getComponentOrientation().isLeftToRight();
                    switch (dockableFrame.getContext().getCurrentDockSide()) {
                        case 1: {
                            LookAndFeel.installBorder(dockableFrame, "DockableFrame.slidingNorthBorder");
                            break;
                        }
                        case 2: {
                            LookAndFeel.installBorder(dockableFrame, "DockableFrame.slidingSouthBorder");
                            break;
                        }
                        case 4: {
                            LookAndFeel.installBorder(dockableFrame, bl ? "DockableFrame.slidingEastBorder" : "DockableFrame.slidingWestBorder");
                            break;
                        }
                        case 8: {
                            LookAndFeel.installBorder(dockableFrame, bl ? "DockableFrame.slidingWestBorder" : "DockableFrame.slidingEastBorder");
                        }
                    }
                }
            } else if ("title".equals(string)) {
                Dimension dimension = BasicDockableFrameUI.this._frame.getMinimumSize();
                Dimension dimension2 = BasicDockableFrameUI.this._frame.getSize();
                if (dimension.width > dimension2.width) {
                    BasicDockableFrameUI.this._frame.setSize(dimension.width, dimension2.height);
                }
            } else if ("showContentPane".equals(string)) {
                BasicDockableFrameUI.this._frame.invalidate();
            }
        }
    }
}

