/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.icons.MaskFilter;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.basic.Resource;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.ClickThroughLabel;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ButtonUI;

public class BasicDockableFrameTitlePane
extends JComponent
implements MouseListener {
    protected AbstractButton _autohideButton;
    protected AbstractButton _closeButton;
    protected AbstractButton _hideAutohideButton;
    protected AbstractButton _floatButton;
    protected AbstractButton _maximizeButton;
    protected final LinkedHashMap<Action, AbstractButton> _additionalButtons = new LinkedHashMap();
    protected JComponent _title;
    protected Gripper _gripper;
    protected JPopupMenu _popupMenu;
    protected DockableFrame _frame;
    protected Color _backgroundColor;
    protected Color _selectedTitleColor;
    protected Color _selectedTextColor;
    protected Color _selectedTitleBorderColor;
    protected Color _notSelectedTitleColor;
    protected Color _notSelectedTextColor;
    protected Color _notSelectedTitleBorderColor;
    protected PropertyChangeListener _propertyChangeListener;
    protected String _closeText;
    protected String _hideAutohideText;
    protected String _dockableText;
    protected String _autohideText;
    protected String _floatingText;
    protected String _maximizeText;
    protected String _closeButtonToolTip;
    protected String _hideAutohideButtonToolTip;
    protected String _autohideButtonToolTip;
    protected String _floatButtonToolTip;
    protected String _maximizeButtonToolTip;
    protected Icon _closeIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideIcon");
    protected Icon _closeActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideActiveIcon");
    protected Icon _closeRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideRolloverIcon");
    protected Icon _closeRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideRolloverActiveIcon");
    protected Icon _hideAutohideIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideAutohideIcon");
    protected Icon _hideAutohideActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideAutohideActiveIcon");
    protected Icon _hideAutohideRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideAutohideRolloverIcon");
    protected Icon _hideAutohideRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.hideAutohideRolloverActiveIcon");
    protected Icon _autohideIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.autohideIcon");
    protected Icon _autohideActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.autohideActiveIcon");
    protected Icon _autohideRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.autohideRolloverIcon");
    protected Icon _autohideRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.autohideRolloverActiveIcon");
    protected Icon _stopAutohideIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.stopAutohideIcon");
    protected Icon _stopAutohideActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.stopAutohideActiveIcon");
    protected Icon _stopAutohideRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.stopAutohideRolloverIcon");
    protected Icon _stopAutohideRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.stopAutohideRolloverActiveIcon");
    protected Icon _floatIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.floatIcon");
    protected Icon _floatActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.floatActiveIcon");
    protected Icon _floatRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.floatRolloverIcon");
    protected Icon _floatRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.floatRolloverActiveIcon");
    protected Icon _unfloatIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.unfloatIcon");
    protected Icon _unfloatActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.unfloatActiveIcon");
    protected Icon _unfloatRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.unfloatRolloverIcon");
    protected Icon _unfloatRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.unfloatRolloverActiveIcon");
    protected Icon _maximizeIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.maximizeIcon");
    protected Icon _maximizeActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.maximizeActiveIcon");
    protected Icon _maximizeRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.maximizeRolloverIcon");
    protected Icon _maximizeRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.maximizeRolloverActiveIcon");
    protected Icon _restoreIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.restoreIcon");
    protected Icon _restoreActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.restoreActiveIcon");
    protected Icon _restoreRolloverIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.restoreRolloverIcon");
    protected Icon _restoreRolloverActiveIcon = UIDefaultsLookup.getIcon("DockableFrameTitlePane.restoreRolloverActiveIcon");
    protected int _gripperWidth = 6;
    protected String _titleButtonUI = null;
    protected boolean _titleBarComponentCanBeOneSameLine = false;
    protected boolean _alwaysShowAllButtons = false;
    protected boolean _showIcon = false;
    protected boolean _use3DButtons = false;
    protected boolean _contentFilledButtons = false;
    protected int _buttonsAlignment = 11;
    protected int _titleAlignment = 10;
    protected int _buttonGap = 2;
    protected Insets _titleInsets = new Insets(0, 0, 0, 0);
    private ThemePainter c;
    protected Painter _gripperPainter;
    private Dimension b = null;

    public BasicDockableFrameTitlePane(DockableFrame dockableFrame) {
        this._frame = dockableFrame;
        this.installTitlePane();
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.setLayout(this.createLayout());
        this.createComponents();
        this.updateAdditionalButtons();
        this.addSubComponents();
    }

    protected void uninstallTitlePane() {
        this.removeAll();
        this.uninstallListeners();
        this.uninstallDefaults();
    }

    protected Dimension getMaximumButtonSize() {
        if (this.b == null) {
            if (this._closeIcon == null) {
                this.b = new Dimension(8, 8);
            } else {
                int n2;
                int n3 = 8;
                if (n3 < this._closeIcon.getIconWidth()) {
                    n3 = this._closeIcon.getIconWidth();
                }
                if (n3 < this._autohideIcon.getIconWidth()) {
                    n3 = this._autohideIcon.getIconWidth();
                }
                if (n3 < this._stopAutohideIcon.getIconWidth()) {
                    n3 = this._stopAutohideIcon.getIconWidth();
                }
                if (n3 < this._floatIcon.getIconWidth()) {
                    n3 = this._floatIcon.getIconWidth();
                }
                if (n3 < this._unfloatIcon.getIconWidth()) {
                    n3 = this._unfloatIcon.getIconWidth();
                }
                if (n3 < this._maximizeIcon.getIconWidth()) {
                    n3 = this._maximizeIcon.getIconWidth();
                }
                if (n3 < this._restoreIcon.getIconWidth()) {
                    n3 = this._restoreIcon.getIconWidth();
                }
                if ((n2 = 8) < this._closeIcon.getIconHeight()) {
                    n2 = this._closeIcon.getIconHeight();
                }
                if (n2 < this._autohideIcon.getIconHeight()) {
                    n2 = this._autohideIcon.getIconHeight();
                }
                if (n2 < this._stopAutohideIcon.getIconHeight()) {
                    n2 = this._stopAutohideIcon.getIconHeight();
                }
                if (n2 < this._floatIcon.getIconHeight()) {
                    n2 = this._floatIcon.getIconHeight();
                }
                if (n2 < this._unfloatIcon.getIconHeight()) {
                    n2 = this._unfloatIcon.getIconHeight();
                }
                if (n2 < this._maximizeIcon.getIconHeight()) {
                    n2 = this._maximizeIcon.getIconHeight();
                }
                if (n2 < this._restoreIcon.getIconHeight()) {
                    n2 = this._restoreIcon.getIconHeight();
                }
                this.b = new Dimension(n3 += 2, n2 += 2);
            }
        }
        return this.b;
    }

    protected void addSubComponents() {
        if (!this._frame.isShowTitleBar()) {
            return;
        }
        if (this._gripper != null) {
            this.add(this._gripper);
        }
        if (this._maximizeButton != null) {
            this.add(this._maximizeButton);
        }
        if (this._floatButton != null) {
            this.add(this._floatButton);
        }
        if (this._closeButton != null) {
            this.add(this._closeButton);
        }
        if (this._hideAutohideButton != null) {
            this.add(this._hideAutohideButton);
        }
        if (this._autohideButton != null) {
            this.add(this._autohideButton);
        }
        for (AbstractButton abstractButton : this._additionalButtons.values()) {
            this.add(abstractButton);
        }
        if (this._frame.getTitleBarComponent() != null) {
            this.add(this._frame.getTitleBarComponent());
        }
        this.add(this._title);
    }

    protected void updateAdditionalButtons() {
        List<Action> list = this._frame.getAdditionalButtonActions();
        HashSet<Action> hashSet = new HashSet<Action>(this._additionalButtons.keySet());
        hashSet.removeAll(list);
        for (Action action : hashSet) {
            this.remove((Component)this._additionalButtons.remove(action));
        }
        for (Action action : list) {
            if (this._additionalButtons.containsKey(action)) continue;
            AbstractButton abstractButton = this.createTitleBarButton();
            Icon icon = this._frame.getActionIcon(action);
            if (icon != null) {
                abstractButton.setIcon(icon);
            }
            this._additionalButtons.put(action, abstractButton);
            this.changeButtonType(abstractButton, 101);
            abstractButton.setAction(action);
        }
    }

    protected void createActions() {
    }

    protected void installListeners() {
        if (this._propertyChangeListener == null) {
            this._propertyChangeListener = this.createPropertyChangeListener();
            this._frame.addPropertyChangeListener(this._propertyChangeListener);
        }
    }

    protected void uninstallListeners() {
        if (this._propertyChangeListener != null) {
            this._frame.removePropertyChangeListener(this._propertyChangeListener);
            this._propertyChangeListener = null;
        }
    }

    protected void installDefaults() {
        this.c = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this._gripperPainter = (Painter)UIDefaultsLookup.get("DockableFrameTitlePane.gripperPainter");
        this.setBorder(UIDefaultsLookup.getBorder("DockableFrame.titleBorder"));
        this._backgroundColor = UIDefaultsLookup.getColor("DockableFrame.background");
        this._selectedTitleColor = UIDefaultsLookup.getColor("DockableFrame.activeTitleBackground");
        this._selectedTextColor = this.getPainter().getDockableFrameTitleBarActiveForeground();
        this._selectedTitleBorderColor = UIDefaultsLookup.getColor("DockableFrame.activeTitleBorderColor");
        this._notSelectedTitleColor = UIDefaultsLookup.getColor("DockableFrame.inactiveTitleBackground");
        this._notSelectedTextColor = this.getPainter().getDockableFrameTitleBarInactiveForeground();
        this._notSelectedTitleBorderColor = UIDefaultsLookup.getColor("DockableFrame.inactiveTitleBorderColor");
        this.setFont(UIDefaultsLookup.getFont("DockableFrameTitlePane.font"));
        if (this._title != null) {
            this.h();
        }
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        this._closeText = resourceBundle.getString("DockableFrameTitlePane.closeText");
        this._hideAutohideText = resourceBundle.getString("DockableFrameTitlePane.hideAutohideText");
        this._dockableText = resourceBundle.getString("DockableFrameTitlePane.dockableText");
        this._floatingText = resourceBundle.getString("DockableFrameTitlePane.floatingText");
        this._autohideText = resourceBundle.getString("DockableFrameTitlePane.autohideText");
        this._maximizeText = resourceBundle.getString("DockableFrameTitlePane.maximizeText");
        this._closeButtonToolTip = resourceBundle.getString("DockableFrameTitlePane.closeTooltip");
        this._hideAutohideButtonToolTip = resourceBundle.getString("DockableFrameTitlePane.hideAutohideTooltip");
        this._autohideButtonToolTip = resourceBundle.getString("DockableFrameTitlePane.autohideTooltip");
        this._floatButtonToolTip = resourceBundle.getString("DockableFrameTitlePane.floatingTooltip");
        this._maximizeButtonToolTip = resourceBundle.getString("DockableFrameTitlePane.maximizeTooltip");
        this._titleBarComponentCanBeOneSameLine = UIDefaultsLookup.getBoolean("DockableFrameTitlePane.titleBarComponent");
        Object object = UIDefaultsLookup.get("DockableFrameTitlePane." + this._frame.getKey() + ".showIcon");
        this._showIcon = object instanceof Boolean ? (Boolean)object : UIDefaultsLookup.getBoolean("DockableFrameTitlePane.showIcon");
        this._use3DButtons = UIDefaultsLookup.getBoolean("DockableFrameTitlePane.use3dButtons");
        this._contentFilledButtons = UIDefaultsLookup.getBoolean("DockableFrameTitlePane.contentFilledButtons");
        this._alwaysShowAllButtons = UIDefaultsLookup.getBoolean("DockableFrameTitlePane.alwaysShowAllButtons");
        this._buttonsAlignment = UIDefaultsLookup.getInt("DockableFrameTitlePane.buttonsAlignment");
        this._titleAlignment = UIDefaultsLookup.getInt("DockableFrameTitlePane.titleAlignment");
        this._buttonGap = UIDefaultsLookup.getInt("DockableFrameTitlePane.buttonGap");
        this._titleInsets = UIDefaultsLookup.getInsets("DockableFrameTitlePane.margin");
        this._gripperWidth = UIDefaultsLookup.getInt("Gripper.size");
        this._titleButtonUI = UIDefaultsLookup.getString("DockableFrameTitlePane.titleButtonUI");
    }

    private void h() {
        if (this.dockableFrameHasFocus()) {
            this._title.setForeground(this._selectedTextColor);
        } else {
            this._title.setForeground(this._notSelectedTextColor);
        }
    }

    protected boolean dockableFrameHasFocus() {
        return this._frame.isActive() && this._frame.getDockingManager() != null && this._frame.getDockingManager().isActive();
    }

    protected void uninstallDefaults() {
        this._backgroundColor = null;
        this._selectedTitleColor = null;
        this._selectedTextColor = null;
        this._selectedTitleBorderColor = null;
        this._notSelectedTitleColor = null;
        this._notSelectedTextColor = null;
        this._notSelectedTitleBorderColor = null;
        this._closeText = null;
        this._hideAutohideText = null;
        this._dockableText = null;
        this._floatingText = null;
        this._autohideText = null;
        this._maximizeText = null;
        this._closeButtonToolTip = null;
        this._hideAutohideButtonToolTip = null;
        this._autohideButtonToolTip = null;
        this._floatButtonToolTip = null;
        this._maximizeButtonToolTip = null;
        this._titleInsets = null;
        this.setBorder(null);
        this.c = null;
        this._gripperPainter = null;
    }

    protected void createComponents() {
        this._gripper = new Gripper();
        Object object = this._frame.getClientProperty("DraggingListener");
        if (object != null) {
            this._gripper.addMouseListener((MouseListener)object);
            this._gripper.addMouseMotionListener((MouseMotionListener)object);
        }
        this._title = this._frame.getTitleLabelComponent();
        if (this._title == null) {
            this._title = this.createDefaultTitleLabel();
        }
        if (this._title instanceof JLabel) {
            ((JLabel)this._title).setHorizontalAlignment(this._titleAlignment);
            ((JLabel)this._title).setVerticalAlignment(0);
            if (this._showIcon) {
                ((JLabel)this._title).setIcon(this._frame.getFrameIcon());
            }
        }
        this.h();
        this._floatButton = this.createTitleBarButton();
        this.setupButton(this._floatButton, this._frame.getFloatingAction());
        this._autohideButton = this.createTitleBarButton();
        this.setupButton(this._autohideButton, this._frame.getAutohideAction());
        this._closeButton = this.createTitleBarButton();
        this.setupButton(this._closeButton, this._frame.getCloseAction());
        this._hideAutohideButton = this.createTitleBarButton();
        this.setupButton(this._hideAutohideButton, this._frame.getHideAutohideAction());
        this._maximizeButton = this.createTitleBarButton();
        this.setupButton(this._maximizeButton, this._frame.getMaximizeAction());
        this.setButtonIcons();
    }

    protected JComponent createDefaultTitleLabel() {
        ClickThroughLabel clickThroughLabel = new ClickThroughLabel(this._frame.getTitle());
        if (this._frame != null) {
            String string = this._frame.getToolTipText();
            this.setToolTipText(string);
            clickThroughLabel.setToolTipText(string);
        }
        clickThroughLabel.setTarget(this);
        clickThroughLabel.setOpaque(false);
        clickThroughLabel.setFont(this.getFont());
        return clickThroughLabel;
    }

    protected void setupButton(final AbstractButton abstractButton, final Action action) {
        abstractButton.addActionListener(action);
        this.updateButtonFromAction(action, abstractButton);
        action.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BasicDockableFrameTitlePane.this.updateButtonFromAction(action, abstractButton);
            }
        });
    }

    protected void updateButtonFromAction(Action action, AbstractButton abstractButton) {
        Icon icon;
        Object object;
        Object object2 = action.getValue("Name");
        if (object2 != null) {
            abstractButton.setName("" + object2);
        }
        if ((object = action.getValue("ShortDescription")) != null && object.toString().length() != 0) {
            abstractButton.setToolTipText(object.toString());
        }
        abstractButton.setEnabled(action.isEnabled());
        if (this._additionalButtons.containsKey(action) && (icon = this._frame.getActionIcon(action)) != null) {
            abstractButton.setIcon(icon);
        }
        this.updateButtonVisibilities();
    }

    protected void updateButtonVisibilities() {
        if (!this._alwaysShowAllButtons) {
            if (this._autohideButton != null) {
                this._autohideButton.setVisible(this.j());
            }
            if (this._maximizeButton != null) {
                this._maximizeButton.setVisible(this.g());
            }
            if (this._floatButton != null) {
                this._floatButton.setVisible(this.m());
            }
            if (this._closeButton != null) {
                this._closeButton.setVisible(this.f());
            }
            if (this._hideAutohideButton != null) {
                this._hideAutohideButton.setVisible(this.d());
            }
        }
    }

    protected AbstractButton createTitleBarButton() {
        NoFocusButton noFocusButton = new NoFocusButton();
        noFocusButton.setUse3DButtons(this._use3DButtons);
        noFocusButton.setContentAreaFilled(this._contentFilledButtons);
        noFocusButton.putClientProperty("ignoreClickToActivate", Boolean.TRUE);
        return noFocusButton;
    }

    protected void changeButtonType(AbstractButton abstractButton, int n2) {
        if (abstractButton != null && abstractButton instanceof NoFocusButton) {
            ((NoFocusButton)abstractButton).setType(n2);
        }
    }

    protected void setButtonIcons() {
        this.changeButtonType(this._closeButton, 0);
        this.changeButtonType(this._hideAutohideButton, 7);
        if (!this._frame.isAutohideShowing()) {
            this.changeButtonType(this._autohideButton, 1);
        } else {
            this.changeButtonType(this._autohideButton, 2);
        }
        if (!this._frame.isFloated()) {
            this.changeButtonType(this._floatButton, 3);
        } else {
            this.changeButtonType(this._floatButton, 4);
        }
        if (!this._frame.isMaximized()) {
            this.changeButtonType(this._maximizeButton, 5);
        } else {
            this.changeButtonType(this._maximizeButton, 6);
        }
    }

    protected void addPopupMenuItems(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(new JCheckBoxMenuItem(this._frame.getCloseAction()));
        ResourceBundle resourceBundle = Resource.getResourceBundle(Locale.getDefault());
        jMenuItem.setMnemonic(resourceBundle.getString("DockableFrameTitlePane.closeMnemonic").charAt(0));
        JMenuItem jMenuItem2 = jPopupMenu.add(new JCheckBoxMenuItem(this._frame.getHideAutohideAction()));
        jMenuItem2.setMnemonic(resourceBundle.getString("DockableFrameTitlePane.hideAutohideMnemonic").charAt(0));
        JMenuItem jMenuItem3 = jPopupMenu.add(new JCheckBoxMenuItem(this._frame.getFloatingAction()));
        jMenuItem3.setMnemonic(resourceBundle.getString("DockableFrameTitlePane.floatingMnemonic").charAt(0));
        JMenuItem jMenuItem4 = jPopupMenu.add(new JCheckBoxMenuItem(this._frame.getAutohideAction()));
        jMenuItem4.setMnemonic(resourceBundle.getString("DockableFrameTitlePane.autohideMnemonic").charAt(0));
        JMenuItem jMenuItem5 = jPopupMenu.add(new JCheckBoxMenuItem(this._frame.getMaximizeAction()));
        jMenuItem5.setMnemonic(resourceBundle.getString("DockableFrameTitlePane.maximizeMnemonic").charAt(0));
    }

    protected JPopupMenu createPopupMenu() {
        return new JidePopupMenu();
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this._backgroundColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getTitleBarHeight());
        }
        this.paintTitleBackground(graphics);
        this._title.setOpaque(false);
        this.h();
    }

    protected void paintGripper(Graphics graphics) {
        if (!this._frame.isShowGripper()) {
            return;
        }
        if (this._gripper != null) {
            this._gripper.setSelected(this.dockableFrameHasFocus());
        }
        Rectangle rectangle = this._frame.getComponentOrientation().isLeftToRight() ? new Rectangle(2, 0, this._gripperWidth, this.getTitleBarHeight()) : new Rectangle(this.getWidth() - this._gripperWidth, 0, this.getWidth() - this._titleInsets.right, this.getTitleBarHeight());
        if (this._gripperPainter != null) {
            this._gripperPainter.paint(this._frame, graphics, rectangle, 0, this.dockableFrameHasFocus() ? 3 : 0);
        } else {
            this.getPainter().paintGripper(this._frame, graphics, rectangle, 0, this.dockableFrameHasFocus() ? 3 : 0);
        }
    }

    protected void paintTitleBackground(Graphics graphics) {
        boolean bl = this.dockableFrameHasFocus();
        Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getTitleBarHeight());
        this.getPainter().paintDockableFrameTitlePane(this, graphics, rectangle, 0, bl ? 3 : 0);
    }

    protected String getTitle(String string, FontMetrics fontMetrics, int n2) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n3 = SwingUtilities.computeStringWidth(fontMetrics, string);
        String string2 = "...";
        if (n3 > n2) {
            int n4;
            int n5 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            for (n4 = 0; n4 < string.length() && (n5 += fontMetrics.charWidth(string.charAt(n4))) <= n2; ++n4) {
            }
            string = string.substring(0, n4) + string2;
        }
        return string;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    public void popupMenu(MouseEvent mouseEvent) {
        this._popupMenu.show(this, mouseEvent.getX() + 1, mouseEvent.getY() + 1);
        mouseEvent.consume();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected int getLeftmostButtonX(int n2, Container container) {
        int n3 = n2;
        if (this.f() && this._closeButton != null && n3 > this._closeButton.getX()) {
            n3 = this._closeButton.getX();
        }
        if (this.j() && this._autohideButton != null && n3 > this._autohideButton.getX()) {
            n3 = this._autohideButton.getX();
        }
        if (this.d() && this._hideAutohideButton != null && n3 > this._hideAutohideButton.getX()) {
            n3 = this._hideAutohideButton.getX();
        }
        if (this.m() && this._floatButton != null && n3 > this._floatButton.getX()) {
            n3 = this._floatButton.getX();
        }
        if (this.g() && this._maximizeButton != null && n3 > this._maximizeButton.getX()) {
            n3 = this._maximizeButton.getX();
        }
        for (AbstractButton abstractButton : this._additionalButtons.values()) {
            if (n3 <= abstractButton.getX()) continue;
            n3 = abstractButton.getX();
        }
        if (this._frame.isShowTitleBar() && this._frame.getTitleBarComponent() != null && this._frame.getTitleBarComponent().isVisible() && this.isSameLine(container)) {
            n3 -= this._frame.getTitleBarComponent().getPreferredSize().width - this._buttonGap;
        }
        return n3;
    }

    protected boolean isCloseButtonVisible() {
        return (this._frame.getAvailableButtons() & 1) != 0;
    }

    protected boolean isHideAutohideButtonVisible() {
        return (this._frame.getAvailableButtons() & 2) != 0;
    }

    protected boolean isAutohideButtonVisible() {
        return (this._frame.getAvailableButtons() & 4) != 0;
    }

    protected boolean isFloatingButtonVisible() {
        return (this._frame.getAvailableButtons() & 8) != 0;
    }

    protected boolean isMaximizeButtonVisible() {
        return (this._frame.getAvailableButtons() & 0x10) != 0;
    }

    protected int getTitleBarHeight() {
        Serializable serializable;
        int n2;
        JComponent jComponent;
        Dimension dimension = this.getMaximumButtonSize();
        JComponent jComponent2 = jComponent = this._frame != null ? this._frame.getTitleLabelComponent() : null;
        if (jComponent != null && jComponent.isVisible()) {
            n2 = jComponent.getPreferredSize().height;
        } else {
            serializable = this.getFontMetrics(this.getFont());
            n2 = serializable.getHeight() + 2;
        }
        n2 = Math.max(dimension.height + (this._closeIcon == null ? 0 : 5), n2);
        serializable = this.getInsets();
        if (this._frame != null && this._frame.getTitleBarComponent() != null && this._frame.getTitleBarComponent().isVisible() && this.isSameLine(this._frame)) {
            Dimension dimension2 = this._frame.getTitleBarComponent().getPreferredSize();
            return Math.max(n2, dimension2.height) + ((Insets)serializable).top + ((Insets)serializable).bottom + this._titleInsets.top + this._titleInsets.bottom + this.getExtraHeight();
        }
        return n2 + ((Insets)serializable).top + ((Insets)serializable).bottom + this._titleInsets.top + this._titleInsets.bottom;
    }

    protected int calculateButtonWidth() {
        int n2 = 0;
        if (this.f() && this._closeButton != null) {
            n2 += this._closeButton.getWidth() + this._buttonGap;
        }
        if (this.d() && this._hideAutohideButton != null) {
            n2 += this._hideAutohideButton.getWidth() + this._buttonGap;
        }
        if (this.j() && this._autohideButton != null) {
            n2 += this._autohideButton.getWidth() + this._buttonGap;
        }
        if (this.m() && this._floatButton != null) {
            n2 += this._floatButton.getWidth() + this._buttonGap;
        }
        if (this.g() && this._maximizeButton != null) {
            n2 += this._maximizeButton.getWidth() + this._buttonGap;
        }
        for (AbstractButton abstractButton : this._additionalButtons.values()) {
            n2 += abstractButton.getWidth() + this._buttonGap;
        }
        return n2;
    }

    protected boolean isSameLine(Container container) {
        int n2;
        int n3;
        if (!this._titleBarComponentCanBeOneSameLine) {
            return false;
        }
        if (container.getWidth() <= 0) {
            return true;
        }
        Dimension dimension = this._frame.getTitleBarComponent() != null && this._frame.getTitleBarComponent().isVisible() ? this._frame.getTitleBarComponent().getPreferredSize() : new Dimension(0, 0);
        int n4 = this.calculateButtonWidth();
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String string = this._frame.getTitle();
        int n5 = string != null ? fontMetrics.stringWidth(string) : 0;
        int n6 = n3 = string != null ? string.length() : 0;
        if (n3 > 3) {
            n2 = fontMetrics.stringWidth(string != null ? string.substring(0, 3) + "..." : "");
            n4 += n5 < n2 ? n5 : n2;
        } else {
            n4 += n5;
        }
        n2 = 0;
        if (this._titleBarComponentCanBeOneSameLine && n4 + dimension.width <= container.getWidth()) {
            n2 = 1;
        }
        return n2 != 0;
    }

    protected void enableButton(AbstractButton abstractButton, boolean bl) {
        if (abstractButton == null) {
            return;
        }
        abstractButton.setEnabled(bl);
        this.updateButtonVisibilities();
    }

    private boolean f() {
        return this._frame.getCloseAction().isEnabled() && (this._frame.getAvailableButtons() & 1) != 0;
    }

    private boolean d() {
        return this._frame.getHideAutohideAction().isEnabled() && (this._frame.getAvailableButtons() & 2) != 0;
    }

    private boolean j() {
        return this._frame.getAutohideAction().isEnabled() && (this._frame.getAvailableButtons() & 4) != 0;
    }

    private boolean m() {
        return this._frame.getFloatingAction().isEnabled() && (this._frame.getAvailableButtons() & 8) != 0;
    }

    private boolean g() {
        return this._frame.getMaximizeAction().isEnabled() && (this._frame.getAvailableButtons() & 0x10) != 0;
    }

    public ThemePainter getPainter() {
        return this.c;
    }

    protected int getExtraHeight() {
        return 1;
    }

    public class NoFocusButton
    extends JideButton
    implements MouseMotionListener,
    MouseListener {
        public static final int CLOSE_BUTTON = 0;
        public static final int AUTOHIDE_BUTTON = 1;
        public static final int STOP_AUTOHIDE_BUTTON = 2;
        public static final int FLOAT_BUTTON = 3;
        public static final int UNFLOAT_BUTTON = 4;
        public static final int MAXIMIZE_BUTTON = 5;
        public static final int RESTORE_BUTTON = 6;
        public static final int HIDE_AUTOHIDE_BUTTON = 7;
        public static final int ACTION_BUTTON = 100;
        public static final int ADDITIONAL_BUTTON = 101;
        private int mb;
        private boolean kb = false;
        private boolean lb = false;
        private boolean jb;

        public void setUse3DButtons(boolean bl) {
            this.jb = bl;
        }

        public void updateUI() {
            if (BasicDockableFrameTitlePane.this._titleButtonUI != null) {
                try {
                    this.setUI((ButtonUI)Class.forName(BasicDockableFrameTitlePane.this._titleButtonUI).newInstance());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    super.updateUI();
                }
            } else {
                super.updateUI();
            }
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setBorder(null);
        }

        public NoFocusButton() {
            if (this.jb) {
                this.setOpaque(false);
                this.setContentAreaFilled(false);
            }
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        public NoFocusButton(Action action) {
            this();
            this.setAction(action);
            this.setType(100);
        }

        protected void originalPaintComponent(Graphics graphics) {
            super.paintComponent(graphics);
        }

        public Icon getIcon() {
            return null;
        }

        public String getText() {
            return "";
        }

        protected void paintComponent(Graphics graphics) {
            int n2;
            int n3;
            int n4;
            if (!this.jb) {
                super.paintComponent(graphics);
            } else if (this.mb != 101 || this.isEnabled()) {
                if (this.isMouseOver() && this.isMousePressed()) {
                    graphics.setColor(Color.black);
                    graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                    graphics.drawLine(0, this.getHeight() - 2, 0, 1);
                    if (BasicDockableFrameTitlePane.this.dockableFrameHasFocus()) {
                        graphics.setColor(Color.lightGray);
                    } else {
                        graphics.setColor(Color.white);
                    }
                    graphics.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                    graphics.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
                } else if (this.isMouseOver()) {
                    if (BasicDockableFrameTitlePane.this.dockableFrameHasFocus()) {
                        graphics.setColor(Color.lightGray);
                    } else {
                        graphics.setColor(Color.white);
                    }
                    graphics.drawLine(0, 0, this.getWidth() - 1, 0);
                    graphics.drawLine(0, this.getHeight() - 2, 0, 1);
                    graphics.setColor(Color.black);
                    graphics.drawLine(this.getWidth() - 1, 1, this.getWidth() - 1, this.getHeight() - 2);
                    graphics.drawLine(this.getWidth() - 1, this.getHeight() - 1, 0, this.getHeight() - 1);
                }
            }
            Color color = BasicDockableFrameTitlePane.this.dockableFrameHasFocus() ? BasicDockableFrameTitlePane.this._selectedTextColor : BasicDockableFrameTitlePane.this._notSelectedTextColor;
            Icon icon = null;
            Icon icon2 = null;
            Icon icon3 = null;
            Icon icon4 = null;
            switch (this.getType()) {
                case 101: {
                    Icon icon5 = BasicDockableFrameTitlePane.this._frame.getActionIcon(this.getAction());
                    if (icon5 == null) break;
                    n4 = icon5.getIconWidth() / 2;
                    n3 = icon5.getIconHeight() / 2;
                    n2 = this.getWidth() / 2 - n4;
                    int n5 = this.getHeight() / 2 - n3;
                    if (!this.isEnabled() && icon5 instanceof ImageIcon) {
                        IconsFactory.createGrayImage(((ImageIcon)icon5).getImage()).paintIcon(this, graphics, n2, n5);
                        break;
                    }
                    icon5.paintIcon(this, graphics, n2, n5);
                    break;
                }
                case 100: {
                    Icon icon5 = (ImageIcon)this.getAction().getValue("SmallIcon");
                    n4 = ((ImageIcon)icon5).getIconWidth() / 2;
                    n3 = ((ImageIcon)icon5).getIconHeight() / 2;
                    n2 = this.getWidth() / 2 - n4;
                    int n6 = this.getHeight() / 2 - n3;
                    new ImageIcon(MaskFilter.createImage(((ImageIcon)icon5).getImage(), Color.black, color)).paintIcon(this, graphics, n2, n6);
                    break;
                }
                case 0: {
                    icon = BasicDockableFrameTitlePane.this._closeIcon;
                    icon2 = BasicDockableFrameTitlePane.this._closeActiveIcon;
                    icon3 = BasicDockableFrameTitlePane.this._closeRolloverIcon;
                    icon4 = BasicDockableFrameTitlePane.this._closeRolloverActiveIcon;
                    break;
                }
                case 7: {
                    icon = BasicDockableFrameTitlePane.this._hideAutohideIcon;
                    icon2 = BasicDockableFrameTitlePane.this._hideAutohideActiveIcon;
                    icon3 = BasicDockableFrameTitlePane.this._hideAutohideRolloverIcon;
                    icon4 = BasicDockableFrameTitlePane.this._hideAutohideRolloverActiveIcon;
                    break;
                }
                case 1: {
                    icon = BasicDockableFrameTitlePane.this._autohideIcon;
                    icon2 = BasicDockableFrameTitlePane.this._autohideActiveIcon;
                    icon3 = BasicDockableFrameTitlePane.this._autohideRolloverIcon;
                    icon4 = BasicDockableFrameTitlePane.this._autohideRolloverActiveIcon;
                    break;
                }
                case 2: {
                    icon = BasicDockableFrameTitlePane.this._stopAutohideIcon;
                    icon2 = BasicDockableFrameTitlePane.this._stopAutohideActiveIcon;
                    icon3 = BasicDockableFrameTitlePane.this._stopAutohideRolloverIcon;
                    icon4 = BasicDockableFrameTitlePane.this._stopAutohideRolloverActiveIcon;
                    break;
                }
                case 3: {
                    icon = BasicDockableFrameTitlePane.this._floatIcon;
                    icon2 = BasicDockableFrameTitlePane.this._floatActiveIcon;
                    icon3 = BasicDockableFrameTitlePane.this._floatRolloverIcon;
                    icon4 = BasicDockableFrameTitlePane.this._floatRolloverActiveIcon;
                    break;
                }
                case 4: {
                    icon = BasicDockableFrameTitlePane.this._unfloatIcon;
                    icon2 = BasicDockableFrameTitlePane.this._unfloatActiveIcon;
                    icon3 = BasicDockableFrameTitlePane.this._unfloatRolloverIcon;
                    icon4 = BasicDockableFrameTitlePane.this._unfloatRolloverActiveIcon;
                    break;
                }
                case 5: {
                    icon = BasicDockableFrameTitlePane.this._maximizeIcon;
                    icon2 = BasicDockableFrameTitlePane.this._maximizeActiveIcon;
                    icon3 = BasicDockableFrameTitlePane.this._maximizeRolloverIcon;
                    icon4 = BasicDockableFrameTitlePane.this._maximizeRolloverActiveIcon;
                    break;
                }
                case 6: {
                    icon = BasicDockableFrameTitlePane.this._restoreIcon;
                    icon2 = BasicDockableFrameTitlePane.this._restoreActiveIcon;
                    icon3 = BasicDockableFrameTitlePane.this._restoreRolloverIcon;
                    icon4 = BasicDockableFrameTitlePane.this._restoreRolloverActiveIcon;
                }
            }
            if (icon != null) {
                int n7 = icon.getIconWidth() / 2;
                n4 = icon.getIconHeight() / 2;
                n3 = this.getWidth() / 2 - n7;
                n2 = this.getHeight() / 2 - n4;
                if (icon3 != null) {
                    if (icon2 != null && icon4 == null) {
                        icon4 = icon2;
                    } else if (icon2 == null && icon4 != null) {
                        icon2 = icon4;
                    }
                    if (BasicDockableFrameTitlePane.this.dockableFrameHasFocus() && icon2 != null) {
                        (this.isMouseOver() ? icon4 : icon2).paintIcon(this, graphics, n3, n2);
                    } else {
                        (this.isMouseOver() ? icon3 : icon).paintIcon(this, graphics, n3, n2);
                    }
                } else if (icon instanceof ImageIcon) {
                    new ImageIcon(MaskFilter.createImage(((ImageIcon)icon).getImage(), Color.black, color)).paintIcon(this, graphics, n3, n2);
                } else {
                    icon.paintIcon(this, graphics, n3, n2);
                }
            }
        }

        public boolean isFocusable() {
            return false;
        }

        public void requestFocus() {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JideSwingUtilities.retargetMouseEvent(506, mouseEvent, BasicDockableFrameTitlePane.this._frame);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.setMouseOver(true);
            this.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.setMousePressed(false);
            this.setMouseOver(false);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.setMousePressed(true);
            this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.setMousePressed(false);
            this.setMouseOver(false);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.setMouseOver(true);
            this.repaint();
            JideSwingUtilities.retargetMouseEvent(504, mouseEvent, BasicDockableFrameTitlePane.this._frame);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.setMouseOver(false);
            this.setMousePressed(false);
            this.repaint();
            JideSwingUtilities.retargetMouseEvent(504, mouseEvent, BasicDockableFrameTitlePane.this._frame);
        }

        public int getType() {
            return this.mb;
        }

        public void setType(int n2) {
            this.mb = n2;
        }

        protected boolean isMouseOver() {
            return this.kb;
        }

        protected void setMouseOver(boolean bl) {
            this.kb = bl;
        }

        protected boolean isMousePressed() {
            return this.lb;
        }

        protected void setMousePressed(boolean bl) {
            this.lb = bl;
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension minimumLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Serializable serializable;
                JComponent jComponent;
                int n2 = 0;
                int n3 = 0;
                JComponent jComponent2 = BasicDockableFrameTitlePane.this._frame.getTitleBarComponent();
                Dimension dimension = jComponent2 != null && jComponent2.isVisible() ? jComponent2.getPreferredSize() : new Dimension(0, 0);
                Dimension dimension2 = BasicDockableFrameTitlePane.this.getMaximumButtonSize();
                n2 += BasicDockableFrameTitlePane.this.calculateButtonWidth();
                JComponent jComponent3 = jComponent = BasicDockableFrameTitlePane.this._frame != null ? BasicDockableFrameTitlePane.this._frame.getTitleLabelComponent() : null;
                if (jComponent != null && jComponent.isVisible()) {
                    serializable = jComponent.getPreferredSize();
                    Dimension dimension3 = jComponent.getMinimumSize();
                    n3 = ((Dimension)serializable).height;
                    n2 += dimension3.width;
                } else {
                    int n4;
                    serializable = BasicDockableFrameTitlePane.this.getFontMetrics(BasicDockableFrameTitlePane.this.getFont());
                    String string = BasicDockableFrameTitlePane.this._frame.getTitle();
                    int n5 = string != null ? ((FontMetrics)serializable).stringWidth(string) : 0;
                    int n6 = n4 = string != null ? string.length() : 0;
                    if (n4 > 3) {
                        int n7 = ((FontMetrics)serializable).stringWidth(string != null ? string.substring(0, 3) + "..." : "");
                        n2 += n5 < n7 ? n5 : n7;
                    } else {
                        n2 += n5;
                    }
                    n3 = Math.max(((FontMetrics)serializable).getHeight() + 2, n3);
                }
                n3 = Math.max(dimension2.height + (BasicDockableFrameTitlePane.this._closeIcon == null ? 0 : 5), n3);
                n3 = BasicDockableFrameTitlePane.this.isSameLine(container) ? Math.max(dimension.height, n3) + BasicDockableFrameTitlePane.this.getExtraHeight() : (n3 += dimension.height);
                if (BasicDockableFrameTitlePane.this.getBorder() != null) {
                    serializable = BasicDockableFrameTitlePane.this.getBorder().getBorderInsets(container);
                    n3 += ((Insets)serializable).top + ((Insets)serializable).bottom;
                    n2 += ((Insets)serializable).left + ((Insets)serializable).right;
                }
                n2 = Math.max(dimension.width, n2);
                return new Dimension(n2, n3 += BasicDockableFrameTitlePane.this._titleInsets.top + BasicDockableFrameTitlePane.this._titleInsets.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                JComponent jComponent;
                int n2;
                boolean bl = BasicDockableFrameTitlePane.this._frame.getComponentOrientation().isLeftToRight() && BasicDockableFrameTitlePane.this._buttonsAlignment == 11;
                int n3 = container.getWidth() - BasicDockableFrameTitlePane.this._titleInsets.left - BasicDockableFrameTitlePane.this._titleInsets.right;
                int n4 = BasicDockableFrameTitlePane.this.getTitleBarHeight() - BasicDockableFrameTitlePane.this._titleInsets.top - BasicDockableFrameTitlePane.this._titleInsets.bottom;
                Dimension dimension = BasicDockableFrameTitlePane.this.getMaximumButtonSize();
                int n5 = dimension.height + (BasicDockableFrameTitlePane.this._closeIcon == null ? 0 : 2);
                int n6 = dimension.width + BasicDockableFrameTitlePane.this._buttonGap;
                int n7 = n2 = bl ? BasicDockableFrameTitlePane.this.getWidth() - BasicDockableFrameTitlePane.this._titleInsets.right : BasicDockableFrameTitlePane.this._titleInsets.left;
                if (!bl) {
                    n2 += BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth - BasicDockableFrameTitlePane.this._titleInsets.left + 2 : 0;
                }
                int n8 = bl ? -(n6 + BasicDockableFrameTitlePane.this._buttonGap) : n6 + BasicDockableFrameTitlePane.this._buttonGap;
                int n9 = 0;
                boolean bl2 = true;
                int[] nArray = BasicDockableFrameTitlePane.this._frame.getButtonsOrder();
                block10: for (int n10 : nArray) {
                    switch (n10) {
                        case 1: {
                            if (BasicDockableFrameTitlePane.this.f()) {
                                if (BasicDockableFrameTitlePane.this._closeButton == null) continue block10;
                                if (bl2) {
                                    n2 += bl ? n8 : 0;
                                    bl2 = false;
                                } else {
                                    n2 += n8;
                                }
                                BasicDockableFrameTitlePane.this._closeButton.setVisible(true);
                                BasicDockableFrameTitlePane.this._closeButton.setBounds(n2, BasicDockableFrameTitlePane.this._titleInsets.top + (n4 - n5) / 2 + n9, n6, n5);
                                continue block10;
                            }
                            if (BasicDockableFrameTitlePane.this._closeButton == null) continue block10;
                            BasicDockableFrameTitlePane.this._closeButton.setVisible(false);
                            continue block10;
                        }
                        case 4: {
                            if (BasicDockableFrameTitlePane.this.j()) {
                                if (BasicDockableFrameTitlePane.this._autohideButton == null) continue block10;
                                if (bl2) {
                                    n2 += bl ? n8 : 0;
                                    bl2 = false;
                                } else {
                                    n2 += n8;
                                }
                                BasicDockableFrameTitlePane.this._autohideButton.setVisible(true);
                                BasicDockableFrameTitlePane.this._autohideButton.setBounds(n2, BasicDockableFrameTitlePane.this._titleInsets.top + (n4 - n5) / 2 + n9, n6, n5);
                                continue block10;
                            }
                            if (BasicDockableFrameTitlePane.this._autohideButton == null) continue block10;
                            BasicDockableFrameTitlePane.this._autohideButton.setVisible(false);
                            continue block10;
                        }
                        case 2: {
                            if (BasicDockableFrameTitlePane.this.d()) {
                                if (BasicDockableFrameTitlePane.this._hideAutohideButton == null) continue block10;
                                if (bl2) {
                                    n2 += bl ? n8 : 0;
                                    bl2 = false;
                                } else {
                                    n2 += n8;
                                }
                                BasicDockableFrameTitlePane.this._hideAutohideButton.setVisible(true);
                                BasicDockableFrameTitlePane.this._hideAutohideButton.setBounds(n2, BasicDockableFrameTitlePane.this._titleInsets.top + (n4 - n5) / 2 + n9, n6, n5);
                                continue block10;
                            }
                            if (BasicDockableFrameTitlePane.this._hideAutohideButton == null) continue block10;
                            BasicDockableFrameTitlePane.this._hideAutohideButton.setVisible(false);
                            continue block10;
                        }
                        case 8: {
                            if (BasicDockableFrameTitlePane.this.m()) {
                                if (BasicDockableFrameTitlePane.this._floatButton == null) continue block10;
                                if (bl2) {
                                    n2 += bl ? n8 : 0;
                                    bl2 = false;
                                } else {
                                    n2 += n8;
                                }
                                BasicDockableFrameTitlePane.this._floatButton.setVisible(true);
                                BasicDockableFrameTitlePane.this._floatButton.setBounds(n2, BasicDockableFrameTitlePane.this._titleInsets.top + (n4 - n5) / 2 + n9, n6, n5);
                                continue block10;
                            }
                            if (BasicDockableFrameTitlePane.this._floatButton == null) continue block10;
                            BasicDockableFrameTitlePane.this._floatButton.setVisible(false);
                            continue block10;
                        }
                        case 16: {
                            if (BasicDockableFrameTitlePane.this.g()) {
                                if (BasicDockableFrameTitlePane.this._maximizeButton == null) continue block10;
                                if (bl2) {
                                    n2 += bl ? n8 : 0;
                                    bl2 = false;
                                } else {
                                    n2 += n8;
                                }
                                BasicDockableFrameTitlePane.this._maximizeButton.setVisible(true);
                                BasicDockableFrameTitlePane.this._maximizeButton.setBounds(n2, BasicDockableFrameTitlePane.this._titleInsets.top + (n4 - n5) / 2 + n9, n6, n5);
                                continue block10;
                            }
                            if (BasicDockableFrameTitlePane.this._maximizeButton == null) continue block10;
                            BasicDockableFrameTitlePane.this._maximizeButton.setVisible(false);
                        }
                    }
                }
                Object object2 = BasicDockableFrameTitlePane.this._additionalButtons.values().iterator();
                while (object2.hasNext()) {
                    AbstractButton abstractButton = (AbstractButton)object2.next();
                    if (bl2) {
                        n2 += bl ? n8 : 0;
                        bl2 = false;
                    } else {
                        n2 += n8;
                    }
                    abstractButton.setBounds(n2, BasicDockableFrameTitlePane.this._titleInsets.top + (n4 - n5) / 2 + n9, n6, n5);
                }
                if (!bl && !bl2) {
                    n2 += n8;
                }
                object2 = BasicDockableFrameTitlePane.this.getInsets();
                if (BasicDockableFrameTitlePane.this._frame.isShowTitleBar() && (jComponent = BasicDockableFrameTitlePane.this._frame.getTitleBarComponent()) != null && jComponent.isVisible()) {
                    int n10;
                    int n11 = jComponent.getPreferredSize().width;
                    n10 = jComponent.getPreferredSize().height;
                    if (BasicDockableFrameTitlePane.this.isSameLine(container)) {
                        jComponent.setBounds(n2 -= n11, BasicDockableFrameTitlePane.this._titleInsets.top + (n4 - n10) / 2 + n9, n11, n10);
                    } else {
                        jComponent.setBounds(((Insets)object2).left, container.getHeight() - ((Insets)object2).bottom - n10, container.getWidth() - ((Insets)object2).left - ((Insets)object2).right, n10);
                    }
                }
                if (BasicDockableFrameTitlePane.this._titleAlignment == 0) {
                    if (bl) {
                        if ((n3 + BasicDockableFrameTitlePane.this._title.getPreferredSize().width) / 2 > n2 - BasicDockableFrameTitlePane.this._titleInsets.left - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0)) {
                            BasicDockableFrameTitlePane.this._title.setBounds(BasicDockableFrameTitlePane.this._titleInsets.left + (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), BasicDockableFrameTitlePane.this._titleInsets.top, n2 - BasicDockableFrameTitlePane.this._titleInsets.left - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), n4);
                            if (BasicDockableFrameTitlePane.this._title instanceof JLabel) {
                                ((JLabel)BasicDockableFrameTitlePane.this._title).setHorizontalAlignment(11);
                            }
                        } else {
                            BasicDockableFrameTitlePane.this._title.setBounds(BasicDockableFrameTitlePane.this._titleInsets.left + (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), BasicDockableFrameTitlePane.this._titleInsets.top, n3, n4);
                            if (BasicDockableFrameTitlePane.this._title instanceof JLabel) {
                                ((JLabel)BasicDockableFrameTitlePane.this._title).setHorizontalAlignment(0);
                            }
                        }
                    } else if ((n3 - BasicDockableFrameTitlePane.this._title.getPreferredSize().width) / 2 < (n2 += n8)) {
                        BasicDockableFrameTitlePane.this._title.setBounds(n2, BasicDockableFrameTitlePane.this._titleInsets.top, n3 - n2 - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), n4);
                        if (BasicDockableFrameTitlePane.this._title instanceof JLabel) {
                            ((JLabel)BasicDockableFrameTitlePane.this._title).setHorizontalAlignment(10);
                        }
                    } else {
                        BasicDockableFrameTitlePane.this._title.setBounds(BasicDockableFrameTitlePane.this._titleInsets.left, BasicDockableFrameTitlePane.this._titleInsets.top, n3, n4);
                        if (BasicDockableFrameTitlePane.this._title instanceof JLabel) {
                            ((JLabel)BasicDockableFrameTitlePane.this._title).setHorizontalAlignment(0);
                        }
                    }
                } else if (bl) {
                    BasicDockableFrameTitlePane.this._title.setBounds(BasicDockableFrameTitlePane.this._titleInsets.left + (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), BasicDockableFrameTitlePane.this._titleInsets.top, n2 - BasicDockableFrameTitlePane.this._titleInsets.left - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), n4);
                } else {
                    BasicDockableFrameTitlePane.this._title.setBounds(n2, BasicDockableFrameTitlePane.this._titleInsets.top, n3 - n2 - (BasicDockableFrameTitlePane.this._frame.isShowGripper() ? BasicDockableFrameTitlePane.this._gripperWidth : 0), n4);
                }
                if (BasicDockableFrameTitlePane.this._gripper != null) {
                    if (BasicDockableFrameTitlePane.this._frame.isShowGripper()) {
                        Rectangle rectangle = BasicDockableFrameTitlePane.this._frame.getComponentOrientation().isLeftToRight() ? new Rectangle(2, BasicDockableFrameTitlePane.this._titleInsets.top, BasicDockableFrameTitlePane.this._gripperWidth, n4) : new Rectangle(BasicDockableFrameTitlePane.this.getWidth() - BasicDockableFrameTitlePane.this._gripperWidth, BasicDockableFrameTitlePane.this._titleInsets.top, BasicDockableFrameTitlePane.this.getWidth() - BasicDockableFrameTitlePane.this._titleInsets.right, n4);
                        BasicDockableFrameTitlePane.this._gripper.setBounds(rectangle);
                    } else {
                        BasicDockableFrameTitlePane.this._gripper.setBounds(new Rectangle(0, 0, 0, 0));
                    }
                }
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("active".equals(string)) {
                BasicDockableFrameTitlePane.this.h();
            } else if ("maximizable".equals(string)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._maximizeButton, BasicDockableFrameTitlePane.this._frame.getMaximizeAction().isEnabled());
            } else if ("hidable".equals(string)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._closeButton, BasicDockableFrameTitlePane.this._frame.getCloseAction().isEnabled());
            } else if ("autohideShowing".equals(string)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._hideAutohideButton, BasicDockableFrameTitlePane.this._frame.getHideAutohideAction().isEnabled());
                BasicDockableFrameTitlePane.this.setButtonIcons();
            } else if ("dockable".equals(string)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, BasicDockableFrameTitlePane.this._frame.getFloatingAction().isEnabled());
                this.b();
            } else if ("autohidable".equals(string)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, BasicDockableFrameTitlePane.this._frame.getAutohideAction().isEnabled());
            } else if ("floatable".equals(string)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, BasicDockableFrameTitlePane.this._frame.getFloatingAction().isEnabled());
            } else if (string.equals("autohide") || "autohideShowing".equals(string)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, BasicDockableFrameTitlePane.this._frame.getAutohideAction().isEnabled());
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, BasicDockableFrameTitlePane.this._frame.getFloatingAction().isEnabled());
                BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._autohideButton, 2);
                this.b();
                BasicDockableFrameTitlePane.this.updateButtonVisibilities();
            } else if ("docked".equals(string)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, BasicDockableFrameTitlePane.this._frame.getAutohideAction().isEnabled());
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._floatButton, BasicDockableFrameTitlePane.this._frame.getFloatingAction().isEnabled());
                if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._floatButton, 3);
                }
                BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._autohideButton, 1);
                this.b();
                BasicDockableFrameTitlePane.this.updateButtonVisibilities();
            } else if ("maximized".equals(string)) {
                if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._maximizeButton, 6);
                } else {
                    BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._maximizeButton, 5);
                }
                this.b();
                BasicDockableFrameTitlePane.this.updateButtonVisibilities();
            } else if ("floated".equals(string)) {
                BasicDockableFrameTitlePane.this.enableButton(BasicDockableFrameTitlePane.this._autohideButton, BasicDockableFrameTitlePane.this._frame.getFloatingAction().isEnabled());
                if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    BasicDockableFrameTitlePane.this.changeButtonType(BasicDockableFrameTitlePane.this._floatButton, 4);
                }
                this.b();
                BasicDockableFrameTitlePane.this.updateButtonVisibilities();
            } else if ("closeAction".equals(string) || "autohideAction".equals(string) || "hideAutohideAction".equals(string) || "floatingAction".equals(string) || "maximizeAction".equals(string)) {
                BasicDockableFrameTitlePane.this._frame.updateUI();
            } else if ("availableButtons".equals(string)) {
                BasicDockableFrameTitlePane.this._frame.updateUI();
            } else if ("title".equals(string)) {
                if (BasicDockableFrameTitlePane.this._title instanceof JLabel) {
                    ((JLabel)BasicDockableFrameTitlePane.this._title).setText(BasicDockableFrameTitlePane.this._frame.getTitle());
                }
            } else if ("frameIcon".equals(string)) {
                if (BasicDockableFrameTitlePane.this._showIcon && BasicDockableFrameTitlePane.this._title instanceof JLabel) {
                    ((JLabel)BasicDockableFrameTitlePane.this._title).setIcon(BasicDockableFrameTitlePane.this._frame.getFrameIcon());
                }
            } else if ("visible".equals(string)) {
                if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    BasicDockableFrameTitlePane.this.addSubComponents();
                    BasicDockableFrameTitlePane.this.invalidate();
                }
                this.b();
            } else if ("ToolTipText".equals(string)) {
                if (BasicDockableFrameTitlePane.this._frame != null) {
                    String string2 = BasicDockableFrameTitlePane.this._frame.getToolTipText();
                    BasicDockableFrameTitlePane.this.setToolTipText(string2);
                    BasicDockableFrameTitlePane.this._title.setToolTipText(string2);
                }
            } else if ("rearrangable".equals(string)) {
                BasicDockableFrameTitlePane.this.invalidate();
            } else if ("showGripper".equals(string)) {
                BasicDockableFrameTitlePane.this.invalidate();
            } else if ("showTitleBar".equals(string)) {
                BasicDockableFrameTitlePane.this.addSubComponents();
                BasicDockableFrameTitlePane.this.revalidate();
            } else if ("titleBarComponent".equals(string)) {
                if (BasicDockableFrameTitlePane.this._frame.getTitleBarComponent() != null) {
                    BasicDockableFrameTitlePane.this.add(BasicDockableFrameTitlePane.this._frame.getTitleBarComponent());
                }
                BasicDockableFrameTitlePane.this.invalidate();
            } else if ("titleLabelComponent".equals(string)) {
                BasicDockableFrameTitlePane.this._frame.updateUI();
            } else if ("additionalButtonActions".equals(string)) {
                BasicDockableFrameTitlePane.this.updateAdditionalButtons();
                BasicDockableFrameTitlePane.this.addSubComponents();
                BasicDockableFrameTitlePane.this.revalidate();
            }
        }

        private void b() {
            if (BasicDockableFrameTitlePane.this._closeButton != null) {
                BasicDockableFrameTitlePane.this._closeButton.getModel().setRollover(false);
            }
            if (BasicDockableFrameTitlePane.this._hideAutohideButton != null) {
                BasicDockableFrameTitlePane.this._hideAutohideButton.getModel().setRollover(false);
            }
            if (BasicDockableFrameTitlePane.this._autohideButton != null) {
                BasicDockableFrameTitlePane.this._autohideButton.getModel().setRollover(false);
            }
            if (BasicDockableFrameTitlePane.this._floatButton != null) {
                BasicDockableFrameTitlePane.this._floatButton.getModel().setRollover(false);
            }
            if (BasicDockableFrameTitlePane.this._maximizeButton != null) {
                BasicDockableFrameTitlePane.this._maximizeButton.getModel().setRollover(false);
            }
        }
    }
}

