/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.action.Chevron;
import com.jidesoft.action.CommandBarTitleBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.vsnet.VsnetMenuUI;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class BasicChevronUI
extends VsnetMenuUI {
    public static final int MARGIN = 3;
    protected Color shadow;
    protected Color highlight;
    protected int _size;
    protected boolean _alwaysVisible;
    private PropertyChangeListener n;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicChevronUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installDefaults((Chevron)jComponent);
        this.installListeners((Chevron)jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallDefaults((Chevron)jComponent);
        this.uninstallListeners((Chevron)jComponent);
    }

    protected void installDefaults(Chevron chevron) {
        this._size = UIDefaultsLookup.getInt("Chevron.size");
        this._alwaysVisible = UIDefaultsLookup.getBoolean("Chevron.alwaysVisible");
    }

    protected void uninstallDefaults(Chevron chevron) {
    }

    protected void installListeners(Chevron chevron) {
        if (this.n == null) {
            this.n = this.createPropertyChangeListener();
        }
        if (this.n != null) {
            chevron.addPropertyChangeListener(this.n);
        }
    }

    protected void uninstallListeners(Chevron chevron) {
        if (this.n != null) {
            chevron.removePropertyChangeListener(this.n);
            this.n = null;
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Chevron chevron = (Chevron)jComponent;
        int n2 = jComponent.getWidth();
        int n3 = jComponent.getHeight();
        this.paintBackground(graphics, chevron);
        Rectangle rectangle = new Rectangle(0, 0, n2, n3);
        int n4 = chevron.getOrientation();
        if (chevron.isShowMore()) {
            this.getPainter().paintChevronMore(chevron, graphics, rectangle, n4, chevron.getModel().isRollover() ? 2 : 0);
        }
        if (chevron.isShowOptions()) {
            Container container = chevron.getParent();
            boolean bl = container instanceof CommandBarTitleBar;
            if (bl) {
                this.getPainter().paintFloatingChevronOption(chevron, graphics, rectangle, n4, chevron.getModel().isRollover() ? 2 : 0);
            } else {
                this.getPainter().paintChevronOption(chevron, graphics, rectangle, n4, chevron.getModel().isRollover() ? 2 : 0);
            }
        }
    }

    protected void paintBackground(Graphics graphics, Chevron chevron) {
        Container container = chevron.getParent();
        boolean bl = container instanceof CommandBarTitleBar;
        Rectangle rectangle = new Rectangle(0, 0, chevron.getWidth(), chevron.getHeight());
        int n2 = JideSwingUtilities.getOrientationOf(chevron);
        if (chevron.getModel().isArmed() || this.menuItem instanceof JMenu && chevron.getModel().isSelected()) {
            if (!bl) {
                this.getPainter().paintChevronBackground(chevron, graphics, rectangle, n2, 1);
            } else {
                this.getPainter().paintButtonBackground(chevron, graphics, rectangle, 0, 1);
            }
        } else if (chevron.getModel().isSelected()) {
            if (!bl) {
                this.getPainter().paintChevronBackground(chevron, graphics, rectangle, n2, 3);
            } else {
                this.getPainter().paintButtonBackground(chevron, graphics, rectangle, 0, 3);
            }
        } else if (this.isMouseOver()) {
            if (!bl) {
                this.getPainter().paintChevronBackground(chevron, graphics, rectangle, n2, 2);
            } else {
                this.getPainter().paintButtonBackground(chevron, graphics, rectangle, 0, 2);
            }
        } else {
            if (!bl) {
                this.getPainter().paintChevronBackground(chevron, graphics, rectangle, n2, 0);
            }
            if (chevron.isOpaque() && "true".equals(SecurityUtils.getProperty("shadingtheme", "false"))) {
                JideSwingUtilities.fillGradient(graphics, rectangle, 0);
            }
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMaximumSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getMaximumSize(jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Chevron chevron = (Chevron)jComponent;
        if (chevron.getParent() != null && (this.i(jComponent) || chevron.isShowMore() || chevron.isShowOptions())) {
            boolean bl = chevron.getParent() instanceof CommandBarTitleBar;
            if (bl) {
                return new Dimension(chevron.getParent().getHeight(), chevron.getParent().getHeight());
            }
            if (chevron.getOrientation() == 0) {
                return new Dimension(this._size, jComponent.getParent().getHeight());
            }
            return new Dimension(jComponent.getParent().getWidth(), this._size);
        }
        return new Dimension(0, 0);
    }

    private boolean i(JComponent jComponent) {
        DockableBar dockableBar = (DockableBar)SwingUtilities.getAncestorOfClass(DockableBar.class, jComponent);
        if (dockableBar != null) {
            return this._alwaysVisible && dockableBar.isChevronAlwaysVisible();
        }
        return this._alwaysVisible;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new _b();
    }

    private class _b
    implements PropertyChangeListener {
        private _b() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ((string.equals("showMore") || string.equals("showOption")) && propertyChangeEvent.getSource() instanceof Component) {
                ((Component)propertyChangeEvent.getSource()).repaint();
            }
        }
    }
}

