/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.plaf.basic.BasicDockableFrameTitlePane;
import com.jidesoft.utils.SecurityUtils;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputListener;

public class AutoHideMouseListener
extends MouseAdapter
implements MouseInputListener {
    protected final DockableFrame _frame;
    protected final int _side;
    protected final DockingManager _dockingManager;
    private static final int b = 0;

    public AutoHideMouseListener(DockingManager dockingManager, DockableFrame dockableFrame, int n2) {
        this._dockingManager = dockingManager;
        this._frame = dockableFrame;
        this._side = n2;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && mouseEvent.getSource() instanceof Component && this._frame.getUI().getTitlePane() instanceof BasicDockableFrameTitlePane && this._dockingManager.isShowContextMenu() && this._frame.isShowContextMenu()) {
            this._dockingManager.showContextMenu((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._frame, false);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && mouseEvent.getSource() instanceof Component && this._frame.getUI().getTitlePane() instanceof BasicDockableFrameTitlePane && this._dockingManager.isShowContextMenu() && this._frame.isShowContextMenu()) {
            this._dockingManager.showContextMenu((Component)mouseEvent.getSource(), mouseEvent.getPoint(), this._frame, false);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!(mouseEvent.isPopupTrigger() && mouseEvent.getSource() instanceof Component && this._frame.getUI().getTitlePane() instanceof BasicDockableFrameTitlePane || this._frame == null)) {
            if (this._frame.isActive()) {
                this._dockingManager.stopShowingAutohideFrame(0, false);
            } else {
                this._dockingManager.requestFocusInDockingManager();
                this._dockingManager.activateFrame(this._frame.getKey());
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && mouseEvent.getSource() instanceof Component && this._frame != null && this._frame.getUI().getTitlePane() instanceof BasicDockableFrameTitlePane) {
            return;
        }
        if (this._frame != null) {
            DockableFrame dockableFrame;
            int n2 = this._dockingManager.getInitDelay();
            if (this._dockingManager.getAutohideShowingFrame() != null) {
                n2 = 0;
            }
            if (mouseEvent.getID() == 506) {
                this._dockingManager.activateFrame(this._frame.getKey());
                n2 = 0;
            }
            String string = this._dockingManager.getActiveFrameKey();
            boolean bl = true;
            if (string != null && (dockableFrame = this._dockingManager.getFrame(string)).isAutohideShowing()) {
                bl = false;
            }
            if (bl) {
                this._dockingManager.startShowingAutohideFrame(this._frame.getKey(), this._side, n2);
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getID() != 506) {
            if (SecurityUtils.isAWTEventListenerDisabled() || "true".equals(SecurityUtils.getProperty("jide.disableAWTEventListener", "false"))) {
                return;
            }
            String string = this._dockingManager.getAutohideShowingFrame();
            if ((!this._frame.isActive() || this._frame.isAutohideWhenActive()) && string != null && this._frame == this._dockingManager.getFrame(string)) {
                this._dockingManager.stopShowingAutohideFrame(this._dockingManager.getInitDelay(), false);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this._dockingManager.getAutohideShowingFrame() == null) {
            this._dockingManager.startShowingAutohideFrame(this._frame.getKey(), this._side, this._dockingManager.getInitDelay() * 2);
        }
    }
}

