/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.utils.SystemInfo;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.Locale;

public abstract class NumberConverter
implements ObjectConverter {
    private NumberFormat ob;
    private boolean pb;
    public static final ConverterContext CONTEXT_FRACTION_NUMBER = new ConverterContext("Fraction Number");
    private static boolean qb = true;

    public NumberConverter() {
    }

    public NumberConverter(NumberFormat numberFormat) {
        this.ob = numberFormat;
    }

    private String b(String string) {
        int n2;
        if (string.indexOf(45) != 0) {
            return string;
        }
        for (n2 = 49; n2 <= 57; n2 = (int)((char)(n2 + 1))) {
            if (string.indexOf(n2) < 0) continue;
            return string;
        }
        for (n2 = 97; n2 <= 102; n2 = (int)((char)(n2 + 1))) {
            if (string.indexOf(n2) < 0) continue;
            return string;
        }
        for (n2 = 65; n2 <= 70; n2 = (int)((char)(n2 + 1))) {
            if (string.indexOf(n2) < 0) continue;
            return string;
        }
        if (string.indexOf(48) < 0) {
            return string;
        }
        return string.substring(1);
    }

    public String toString(Object object, ConverterContext converterContext) {
        try {
            if (converterContext == null || converterContext.getUserObject() == null || !(converterContext.getUserObject() instanceof NumberFormat)) {
                if (object instanceof Number && ((Number)object).doubleValue() == Double.NaN) {
                    return "";
                }
                String string = this.getNumberFormat().format(object);
                if (this.isAvoidNegativeZero()) {
                    string = this.b(string);
                }
                return string;
            }
            NumberFormat numberFormat = (NumberFormat)converterContext.getUserObject();
            String string = numberFormat.format(object);
            if (this.isAvoidNegativeZero()) {
                string = this.b(string);
            }
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "";
        }
    }

    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.ob = numberFormat;
    }

    protected NumberFormat getNumberFormat() {
        if (this.ob == null) {
            this.ob = DecimalFormat.getInstance();
            this.ob.setGroupingUsed(NumberConverter.isGroupingUsed());
        }
        return this.ob;
    }

    protected NumberFormat getDefaultNumberFormat() {
        NumberFormat numberFormat = DecimalFormat.getInstance(Locale.US);
        numberFormat.setGroupingUsed(NumberConverter.isGroupingUsed());
        return numberFormat;
    }

    protected Number parseNumber(String string) {
        Number number;
        try {
            number = this.getNumberFormat().parse(string);
        }
        catch (ParseException parseException) {
            try {
                number = this.getDefaultNumberFormat().parse(string);
            }
            catch (ParseException parseException2) {
                number = null;
            }
        }
        return number;
    }

    public static boolean isGroupingUsed() {
        return qb;
    }

    public static void setGroupingUsed(boolean bl) {
        qb = bl;
    }

    public void setFractionDigits(int n2, int n3) {
        NumberFormat numberFormat = this.getNumberFormat();
        numberFormat.setMinimumFractionDigits(n2);
        numberFormat.setMaximumFractionDigits(n3);
    }

    public void setCurrency(Currency currency) {
        NumberFormat numberFormat = this.getNumberFormat();
        numberFormat.setCurrency(currency);
    }

    public void setIntegerDigits(int n2, int n3) {
        NumberFormat numberFormat = this.getNumberFormat();
        numberFormat.setMinimumIntegerDigits(n2);
        numberFormat.setMaximumIntegerDigits(n3);
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        if (SystemInfo.isJdk6Above()) {
            NumberFormat numberFormat = this.getNumberFormat();
            numberFormat.setRoundingMode(roundingMode);
        }
    }

    public boolean isAvoidNegativeZero() {
        return this.pb;
    }

    public void setAvoidNegativeZero(boolean bl) {
        this.pb = bl;
    }
}

