/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MonthConverter
implements ObjectConverter {
    public static ConverterContext CONTEXT_MONTH = new ConverterContext("Calendar.Month");
    private DateFormat x = new SimpleDateFormat("MMyy");
    private DateFormat w = new SimpleDateFormat("MM/yy");
    private DateFormat y = new SimpleDateFormat("MM, yyyy");
    private DateFormat u = new SimpleDateFormat("MMMMM, yyyy");
    private DateFormat v = this.w;

    public String toString(Object object, ConverterContext converterContext) {
        if (object == null || !(object instanceof Calendar)) {
            return "";
        }
        return this.v.format(((Calendar)object).getTime());
    }

    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    public Object fromString(String string, ConverterContext converterContext) {
        Calendar calendar = Calendar.getInstance();
        try {
            Date date = this.v.parse(string);
            calendar.setTime(date);
        }
        catch (ParseException parseException) {
            try {
                Date date = this.w.parse(string);
                calendar.setTime(date);
            }
            catch (ParseException parseException2) {
                try {
                    Date date = this.y.parse(string);
                    calendar.setTime(date);
                }
                catch (ParseException parseException3) {
                    try {
                        Date date = this.u.parse(string);
                        calendar.setTime(date);
                    }
                    catch (ParseException parseException4) {
                        try {
                            Date date = this.x.parse(string);
                            calendar.setTime(date);
                        }
                        catch (ParseException parseException5) {
                            return null;
                        }
                    }
                }
            }
        }
        return calendar;
    }

    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public DateFormat getDefaultFormat() {
        return this.v;
    }

    public void setDefaultFormat(DateFormat dateFormat) {
        this.v = dateFormat;
    }
}

