/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateConverter
implements ObjectConverter {
    public static final ConverterContext DATETIME_CONTEXT = new ConverterContext("DateTime");
    public static final ConverterContext TIME_CONTEXT = new ConverterContext("Time");
    public static final ConverterContext DATE_CONTEXT = new ConverterContext("Date");
    private DateFormat z = SimpleDateFormat.getDateInstance(3);
    private DateFormat jb = SimpleDateFormat.getDateInstance(2);
    private DateFormat kb = SimpleDateFormat.getDateInstance(1);
    private DateFormat cb = SimpleDateFormat.getDateInstance(2);
    private DateFormat gb = SimpleDateFormat.getDateTimeInstance(3, 3);
    private DateFormat bb = SimpleDateFormat.getDateTimeInstance(2, 2);
    private DateFormat ab = SimpleDateFormat.getDateTimeInstance(1, 1);
    private DateFormat fb = SimpleDateFormat.getDateTimeInstance(2, 2);
    private DateFormat db = SimpleDateFormat.getTimeInstance(3);
    private DateFormat hb = SimpleDateFormat.getTimeInstance(2);
    private DateFormat eb = SimpleDateFormat.getTimeInstance(1);
    private DateFormat ib = SimpleDateFormat.getTimeInstance(2);

    public synchronized String toString(Object object, ConverterContext converterContext) {
        TimeZone timeZone;
        if (object == null) {
            return "";
        }
        if (object instanceof Calendar) {
            timeZone = ((Calendar)object).getTimeZone();
            object = ((Calendar)object).getTime();
        } else if (object instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)object);
            timeZone = calendar.getTimeZone();
        } else {
            timeZone = TimeZone.getDefault();
        }
        if (object instanceof Date || object instanceof Number) {
            if (converterContext != null && converterContext.getUserObject() instanceof DateFormat) {
                return ((DateFormat)converterContext.getUserObject()).format(object);
            }
            if (DATETIME_CONTEXT.equals(converterContext)) {
                this.fb.setTimeZone(timeZone);
                return this.fb.format(object);
            }
            if (TIME_CONTEXT.equals(converterContext)) {
                this.ib.setTimeZone(timeZone);
                return this.ib.format(object);
            }
            this.cb.setTimeZone(timeZone);
            return this.cb.format(object);
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    public synchronized Object fromString(String string, ConverterContext converterContext) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        try {
            Object object;
            Object object2 = object = converterContext != null ? converterContext.getUserObject() : null;
            if (object instanceof DateFormat) {
                return ((DateFormat)object).parse(string);
            }
            if (DATETIME_CONTEXT.equals(converterContext)) {
                return this.fb.parse(string);
            }
            if (TIME_CONTEXT.equals(converterContext)) {
                return this.ib.parse(string);
            }
            return this.cb.parse(string);
        }
        catch (ParseException parseException) {
            String[] stringArray;
            if (DATETIME_CONTEXT.equals(converterContext)) {
                try {
                    return this.gb.parse(string);
                }
                catch (ParseException parseException2) {
                    try {
                        return this.bb.parse(string);
                    }
                    catch (ParseException parseException3) {
                        try {
                            return this.ab.parse(string);
                        }
                        catch (ParseException parseException4) {
                        }
                    }
                }
            } else {
                if (TIME_CONTEXT.equals(converterContext)) {
                    try {
                        return this.db.parse(string);
                    }
                    catch (ParseException parseException5) {
                        try {
                            return this.hb.parse(string);
                        }
                        catch (ParseException parseException6) {
                            try {
                                return this.eb.parse(string);
                            }
                            catch (ParseException parseException7) {
                                return string;
                            }
                        }
                    }
                }
                try {
                    return this.z.parse(string);
                }
                catch (ParseException parseException8) {
                    try {
                        return this.jb.parse(string);
                    }
                    catch (ParseException parseException9) {
                        try {
                            return this.kb.parse(string);
                        }
                        catch (ParseException parseException10) {
                            // empty catch block
                        }
                    }
                }
            }
            for (String string2 : stringArray = new String[]{"yyyy-mm-dd", "yy-mm-dd", "yyyymmdd", "yymmdd", "dd-MMM-yy", "dd-MMM-yyyy"}) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
                    return simpleDateFormat.parse(string);
                }
                catch (ParseException parseException11) {
                }
            }
            return string;
        }
    }

    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public DateFormat getDefaultFormat() {
        return this.cb;
    }

    public void setDefaultFormat(DateFormat dateFormat) {
        this.cb = dateFormat;
    }

    public DateFormat getDefaultTimeFormat() {
        return this.ib;
    }

    public void setDefaultTimeFormat(DateFormat dateFormat) {
        this.ib = dateFormat;
    }

    public DateFormat getDefaultDatetimeFormat() {
        return this.fb;
    }

    public void setDefaultDatetimeFormat(DateFormat dateFormat) {
        this.fb = dateFormat;
    }
}

