/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigDecimal;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XPathDecimalFormat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBase64Binary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSHexBinary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;

public class XSFloat
extends NumericType {
    private static final String XS_FLOAT = "xs:float";
    private Float _value;
    private XPathDecimalFormat format = new XPathDecimalFormat("0.#######E0");
    static /* synthetic */ Class class$0;

    public XSFloat(float x) {
        this._value = new Float(x);
    }

    public XSFloat() {
        this(0.0f);
    }

    public XSFloat(String init) throws DynamicError {
        try {
            this._value = init.equals("-INF") ? new Float(Float.NEGATIVE_INFINITY) : (init.equals("INF") ? new Float(Float.POSITIVE_INFINITY) : new Float(init));
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }

    public String string_type() {
        return XS_FLOAT;
    }

    public String type_name() {
        return "float";
    }

    public String string_value() {
        if (this.zero()) {
            return "0";
        }
        if (this.negativeZero()) {
            return "-0";
        }
        if (this.nan()) {
            return "NaN";
        }
        return this.format.xpathFormat(this._value);
    }

    public boolean nan() {
        return Float.isNaN(this._value.floatValue());
    }

    public boolean infinite() {
        return Float.isInfinite(this._value.floatValue());
    }

    public boolean zero() {
        return Float.compare(this._value.floatValue(), 0.0f) == 0;
    }

    public boolean negativeZero() {
        return Float.compare(this._value.floatValue(), -0.0f) == 0;
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        if (aat instanceof XSDuration || aat instanceof CalendarType || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!(aat.string_type().equals("xs:string") || aat instanceof NodeType || aat.string_type().equals("xs:untypedAtomic") || aat.string_type().equals("xs:boolean") || aat instanceof NumericType)) {
            throw DynamicError.cant_cast(null);
        }
        try {
            Float f = null;
            f = aat.string_value().equals("INF") ? new Float(Float.POSITIVE_INFINITY) : (aat.string_value().equals("-INF") ? new Float(Float.NEGATIVE_INFINITY) : (aat instanceof XSBoolean ? (aat.string_value().equals("true") ? new Float("1.0E0") : new Float("0.0E0")) : new Float(aat.string_value())));
            rs.add(new XSFloat(f.floatValue()));
            return rs;
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null);
        }
    }

    public float float_value() {
        return this._value.floatValue();
    }

    public boolean eq(AnyType aa, DynamicContext context) throws DynamicError {
        boolean isThisValueZero;
        AnyType carg = this.convertArg(aa);
        if (!(carg instanceof XSFloat)) {
            DynamicError.throw_type_error();
        }
        XSFloat f = (XSFloat)carg;
        if (this.nan() && f.nan()) {
            return false;
        }
        boolean isThatValueZero = f.zero() || f.negativeZero();
        boolean bl = isThisValueZero = this.zero() || this.negativeZero();
        if (isThatValueZero && isThisValueZero) {
            return true;
        }
        Float thatvalue = new Float(f.float_value());
        Float thisvalue = new Float(this.float_value());
        return thisvalue.equals(thatvalue);
    }

    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        AnyType carg = this.convertArg(arg);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSFloat val = (XSFloat)XSFloat.get_single_type(carg, (Class)clazz);
        return this.float_value() > val.float_value();
    }

    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        AnyType carg = this.convertArg(arg);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSFloat val = (XSFloat)XSFloat.get_single_type(carg, (Class)clazz);
        return this.float_value() < val.float_value();
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        AnyType at = this.get_single_arg(carg);
        if (!(at instanceof XSFloat)) {
            DynamicError.throw_type_error();
        }
        XSFloat val = (XSFloat)at;
        return ResultSequenceFactory.create_new(new XSFloat(this.float_value() + val.float_value()));
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.constructor(arg);
        AnyType at = this.get_single_arg(carg);
        if (!(at instanceof XSFloat)) {
            DynamicError.throw_type_error();
        }
        XSFloat val = (XSFloat)at;
        return ResultSequenceFactory.create_new(new XSFloat(this.float_value() - val.float_value()));
    }

    public ResultSequence times(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.constructor(arg);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSFloat val = (XSFloat)XSFloat.get_single_type(carg, (Class)clazz);
        return ResultSequenceFactory.create_new(new XSFloat(this.float_value() * val.float_value()));
    }

    public ResultSequence div(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSFloat val = (XSFloat)XSFloat.get_single_type(carg, (Class)clazz);
        return ResultSequenceFactory.create_new(new XSFloat(this.float_value() / val.float_value()));
    }

    public ResultSequence idiv(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSFloat val = (XSFloat)XSFloat.get_single_type(carg, (Class)clazz);
        if (this.nan() || val.nan()) {
            throw DynamicError.numeric_overflow("Dividend or divisor is NaN");
        }
        if (this.infinite()) {
            throw DynamicError.numeric_overflow("Dividend is infinite");
        }
        if (val.zero()) {
            throw DynamicError.div_zero(null);
        }
        BigDecimal result = BigDecimal.valueOf(new Float(this.float_value() / val.float_value()).longValue());
        return ResultSequenceFactory.create_new(new XSInteger(result.toBigInteger()));
    }

    public ResultSequence mod(ResultSequence arg) throws DynamicError {
        ResultSequence carg = this.convertResultSequence(arg);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSFloat val = (XSFloat)XSFloat.get_single_type(carg, (Class)clazz);
        return ResultSequenceFactory.create_new(new XSFloat(this.float_value() % val.float_value()));
    }

    public ResultSequence unary_minus() {
        return ResultSequenceFactory.create_new(new XSFloat(-1.0f * this.float_value()));
    }

    public NumericType abs() {
        return new XSFloat(Math.abs(this.float_value()));
    }

    public NumericType ceiling() {
        return new XSFloat((float)Math.ceil(this.float_value()));
    }

    public NumericType floor() {
        return new XSFloat((float)Math.floor(this.float_value()));
    }

    public NumericType round() {
        BigDecimal value = new BigDecimal(this.float_value());
        BigDecimal round = value.setScale(0, 4);
        return new XSFloat(round.floatValue());
    }

    public NumericType round_half_to_even() {
        return this.round_half_to_even(0);
    }

    public NumericType round_half_to_even(int precision) {
        BigDecimal value = new BigDecimal(this._value.floatValue());
        BigDecimal round = value.setScale(precision, 6);
        return new XSFloat(round.floatValue());
    }

    protected AnyType convertArg(AnyType arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new(arg);
        rs = this.constructor(rs);
        AnyType carg = rs.first();
        return carg;
    }

    private ResultSequence convertResultSequence(ResultSequence arg) throws DynamicError {
        ResultSequence carg = arg;
        ListIterator it = carg.iterator();
        while (it.hasNext()) {
            AnyType type = (AnyType)it.next();
            if (!type.string_type().equals("xs:untypedAtomic") && !type.string_type().equals("xs:string")) continue;
            throw DynamicError.throw_type_error();
        }
        carg = this.constructor(carg);
        return carg;
    }
}

