/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.xerces.xs.XSModel;
import org.eclipse.wst.xml.xpath2.processor.CollationProvider;
import org.eclipse.wst.xml.xpath2.processor.DOMLoaderException;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.XercesLoader;
import org.eclipse.wst.xml.xpath2.processor.internal.DefaultStaticContext;
import org.eclipse.wst.xml.xpath2.processor.internal.Focus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FunctionLibrary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDayTimeDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultDynamicContext
extends DefaultStaticContext
implements DynamicContext {
    private Focus _focus = null;
    private XSDuration _tz = new XSDayTimeDuration(0, 5, 0, 0.0, true);
    private Map _loaded_documents = new HashMap();
    private GregorianCalendar _current_date_time;
    private String _default_collation_name = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    private CollationProvider _collation_provider;
    private Node _rootNode;
    private static Comparator CODEPOINT_COMPARATOR;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.DefaultDynamicContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        CODEPOINT_COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo((String)o2);
            }
        };
    }

    public DefaultDynamicContext(XSModel schema, Document doc) {
        super(schema);
    }

    public XSDuration tz() {
        return this._tz;
    }

    public GregorianCalendar current_date_time() {
        if (this._current_date_time == null) {
            this._current_date_time = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        }
        return this._current_date_time;
    }

    public void set_focus(Focus f) {
        this._focus = f;
    }

    public void setRootNode(Node rootNode) {
        this._rootNode = rootNode;
    }

    public Node getRootNode() {
        return this._rootNode;
    }

    public Focus focus() {
        return this._focus;
    }

    public AnyType context_item() {
        return this._focus.context_item();
    }

    public int context_position() {
        return this._focus.position();
    }

    public int last() {
        return this._focus.last();
    }

    public Object get_variable(QName name) {
        if ("fs".equals(name.prefix())) {
            if (name.local().equals("dot")) {
                return this.context_item();
            }
            return null;
        }
        return this.get_var(name);
    }

    public ResultSequence evaluate_function(QName name, Collection args) throws DynamicError {
        Function funct = this.function(name, args.size());
        if (!$assertionsDisabled && funct == null) {
            throw new AssertionError();
        }
        return funct.evaluate(args);
    }

    public void add_function_library(FunctionLibrary fl) {
        super.add_function_library(fl);
        fl.set_dynamic_context(this);
    }

    public ResultSequence get_doc(URI resolved) {
        Document doc = null;
        if (this._loaded_documents.containsKey(resolved)) {
            doc = (Document)this._loaded_documents.get(resolved);
        } else {
            doc = this.retrieve_doc(resolved);
            this._loaded_documents.put(resolved, doc);
        }
        if (doc == null) {
            return null;
        }
        return ResultSequenceFactory.create_new(new DocType(doc));
    }

    public URI resolve_uri(String uri) {
        try {
            URI realURI = URI.create(uri);
            if (realURI.isAbsolute()) {
                return realURI;
            }
            URI baseURI = URI.create(this.base_uri().string_value());
            return baseURI.resolve(uri);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    private Document retrieve_doc(URI uri) {
        try {
            XercesLoader loader = new XercesLoader();
            loader.set_validating(false);
            Document doc = loader.load(new URL(uri.toString()).openStream());
            doc.setDocumentURI(uri.toString());
            return doc;
        }
        catch (DOMLoaderException e) {
            return null;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void set_variable(QName var, AnyType val) {
        super.set_variable(var, val);
    }

    public void set_variable(QName var, ResultSequence val) {
        super.set_variable(var, val);
    }

    public void set_default_collation(String _default_collation) {
        this._default_collation_name = _default_collation;
    }

    public String default_collation_name() {
        return this._default_collation_name;
    }

    public Comparator get_collation(String uri) {
        if ("http://www.w3.org/2005/xpath-functions/collation/codepoint".equals(uri)) {
            return CODEPOINT_COMPARATOR;
        }
        return this._collation_provider != null ? this._collation_provider.get_collation(uri) : null;
    }

    public void set_collation_provider(CollationProvider provider) {
        this._collation_provider = provider;
    }

    public int node_position(Node node) {
        return this._focus.position();
    }
}

