/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip;

import de.schlichtherle.io.File;
import de.schlichtherle.io.OutputArchiveMetaData;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.spi.OutputArchiveBusyException;
import de.schlichtherle.io.archive.spi.RfsEntry;
import de.schlichtherle.io.archive.zip.Zip32Entry;
import de.schlichtherle.io.archive.zip.Zip32InputArchive;
import de.schlichtherle.io.util.Temps;
import de.schlichtherle.util.JointEnumeration;
import de.schlichtherle.util.zip.BasicZipOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;

public class Zip32OutputArchive
extends BasicZipOutputStream
implements OutputArchive {
    private static final String TEMP_FILE_PREFIX = "tzp-zip";
    private final Zip32InputArchive source;
    private OutputArchiveMetaData metaData;
    private Zip32Entry tempEntry;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Zip32OutputArchive(OutputStream outputStream, String string, Zip32InputArchive zip32InputArchive) throws NullPointerException, UnsupportedEncodingException, IOException {
        this(outputStream, string, 9, zip32InputArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Zip32OutputArchive(OutputStream outputStream, String string, int n, Zip32InputArchive zip32InputArchive) throws NullPointerException, UnsupportedEncodingException, IOException {
        super(outputStream, string);
        super.setLevel(n);
        this.source = zip32InputArchive;
        if (zip32InputArchive != null) {
            super.setComment(zip32InputArchive.getComment());
            if (zip32InputArchive.getPreambleLength() > 0L) {
                InputStream inputStream = zip32InputArchive.getPreambleInputStream();
                try {
                    File.cat(inputStream, zip32InputArchive.offsetsConsiderPreamble() ? this : outputStream);
                }
                finally {
                    inputStream.close();
                }
            }
        }
    }

    public int getNumArchiveEntries() {
        return this.size() + (this.tempEntry != null ? 1 : 0);
    }

    public Enumeration getArchiveEntries() {
        if (this.tempEntry == null) {
            return super.entries();
        }
        return new JointEnumeration(super.entries(), Collections.enumeration(Collections.singletonList(this.tempEntry)));
    }

    public ArchiveEntry getArchiveEntry(String string) {
        Zip32Entry zip32Entry = (Zip32Entry)this.getEntry(string);
        if (zip32Entry != null) {
            return zip32Entry;
        }
        zip32Entry = this.tempEntry;
        return zip32Entry != null && string.equals(zip32Entry.getName()) ? zip32Entry : null;
    }

    public OutputStream getOutputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        Zip32Entry zip32Entry = (Zip32Entry)archiveEntry;
        if (this.isBusy()) {
            throw new OutputArchiveBusyException(zip32Entry);
        }
        if (zip32Entry.isDirectory()) {
            zip32Entry.setMethod(0);
            zip32Entry.setCrc(0L);
            zip32Entry.setCompressedSize(0L);
            zip32Entry.setSize(0L);
            return new EntryOutputStream(zip32Entry);
        }
        if (archiveEntry2 instanceof Zip32Entry) {
            Zip32Entry zip32Entry2 = (Zip32Entry)archiveEntry2;
            if (zip32Entry.getMethod() == -1) {
                zip32Entry.setMethod(zip32Entry2.getMethod());
            }
            if (zip32Entry.getMethod() == zip32Entry2.getMethod()) {
                zip32Entry.setCompressedSize(zip32Entry2.getCompressedSize());
            }
            zip32Entry.setCrc(zip32Entry2.getCrc());
            zip32Entry.setSize(zip32Entry2.getSize());
            return new EntryOutputStream(zip32Entry, zip32Entry2.getMethod() != 8);
        }
        if (archiveEntry2 != null) {
            zip32Entry.setSize(archiveEntry2.getSize());
        }
        switch (zip32Entry.getMethod()) {
            case -1: {
                zip32Entry.setMethod(8);
                break;
            }
            case 0: {
                if (zip32Entry.getCrc() != -1L && zip32Entry.getCompressedSize() != -1L && zip32Entry.getSize() != -1L) break;
                if (!(archiveEntry2 instanceof RfsEntry)) {
                    java.io.File file = Temps.createTempFile(TEMP_FILE_PREFIX);
                    return new TempEntryOutputStream(zip32Entry, file);
                }
                java.io.File file = ((RfsEntry)archiveEntry2).getFile();
                long l = file.length();
                if (l > Integer.MAX_VALUE) {
                    throw new IOException("file too large");
                }
                FileInputStream fileInputStream = new FileInputStream(file);
                Crc32OutputStream crc32OutputStream = new Crc32OutputStream();
                File.cp(fileInputStream, crc32OutputStream);
                zip32Entry.setCrc(crc32OutputStream.crc.getValue());
                zip32Entry.setCompressedSize(l);
                zip32Entry.setSize(l);
                break;
            }
            case 8: {
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"unsupported method");
                }
                break;
            }
        }
        return new EntryOutputStream(zip32Entry);
    }

    public final boolean isBusy() {
        return super.isBusy() || this.tempEntry != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeTempEntry(Zip32Entry zip32Entry, java.io.File file) throws IOException {
        if (!$assertionsDisabled && zip32Entry.getMethod() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && zip32Entry.getCrc() == -1L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && zip32Entry.getCompressedSize() == -1L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && zip32Entry.getSize() == -1L) {
            throw new AssertionError();
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                this.putNextEntry(zip32Entry);
                try {
                    File.cat(fileInputStream, this);
                }
                finally {
                    this.closeEntry();
                }
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        finally {
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    public final void storeDirectory(ArchiveEntry archiveEntry) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Since TrueZIP 6.5, this is not used anymore!");
        }
        if (!archiveEntry.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.getOutputStream(archiveEntry, null).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() throws IOException {
        super.finish();
        if (this.source == null) {
            return;
        }
        long l = this.source.getPostambleLength();
        if (l <= 0L) {
            return;
        }
        long l2 = this.source.length();
        long l3 = this.length();
        InputStream inputStream = this.source.getPostambleInputStream();
        try {
            if (l3 + l != l2) {
                this.write(new byte[(int)(l3 % 4L)]);
            }
            File.cat(inputStream, this);
        }
        finally {
            inputStream.close();
        }
    }

    public OutputArchiveMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(OutputArchiveMetaData outputArchiveMetaData) {
        this.metaData = outputArchiveMetaData;
    }

    static {
        $assertionsDisabled = !Zip32OutputArchive.class.desiredAssertionStatus();
    }

    private static class Crc32OutputStream
    extends OutputStream {
        private final CRC32 crc = new CRC32();

        private Crc32OutputStream() {
        }

        public void write(int n) {
            this.crc.update(n);
        }

        public void write(byte[] byArray, int n, int n2) {
            this.crc.update(byArray, n, n2);
        }
    }

    private class TempEntryOutputStream
    extends CheckedOutputStream {
        private final java.io.File temp;
        private boolean closed;
        static final /* synthetic */ boolean $assertionsDisabled;

        public TempEntryOutputStream(Zip32Entry zip32Entry, java.io.File file) throws IOException {
            super(new FileOutputStream(file), new CRC32());
            if (!$assertionsDisabled && zip32Entry.getMethod() != 0) {
                throw new AssertionError();
            }
            this.temp = file;
            Zip32OutputArchive.this.tempEntry = zip32Entry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                try {
                    super.close();
                }
                finally {
                    long l = this.temp.length();
                    if (l > Integer.MAX_VALUE) {
                        throw new IOException("file too large");
                    }
                    Zip32OutputArchive.this.tempEntry.setCrc(this.getChecksum().getValue());
                    Zip32OutputArchive.this.tempEntry.setCompressedSize(l);
                    Zip32OutputArchive.this.tempEntry.setSize(l);
                    Zip32OutputArchive.this.storeTempEntry(Zip32OutputArchive.this.tempEntry, this.temp);
                }
            }
            finally {
                Zip32OutputArchive.this.tempEntry = null;
            }
        }

        static {
            $assertionsDisabled = !(class$de$schlichtherle$io$archive$zip$Zip32OutputArchive == null ? (class$de$schlichtherle$io$archive$zip$Zip32OutputArchive = Zip32OutputArchive.class$("de.schlichtherle.io.archive.zip.Zip32OutputArchive")) : class$de$schlichtherle$io$archive$zip$Zip32OutputArchive).desiredAssertionStatus();
        }
    }

    private class EntryOutputStream
    extends FilterOutputStream {
        private EntryOutputStream(Zip32Entry zip32Entry) throws IOException {
            this(zip32Entry, true);
        }

        private EntryOutputStream(Zip32Entry zip32Entry, boolean bl) throws IOException {
            super(Zip32OutputArchive.this);
            Zip32OutputArchive.this.putNextEntry(zip32Entry, bl);
        }

        public void write(byte[] byArray) throws IOException {
            this.out.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.out.write(byArray, n, n2);
        }

        public void close() throws IOException {
            Zip32OutputArchive.this.closeEntry();
        }
    }
}

