/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.tar;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.tar.TarDriver;
import de.schlichtherle.io.archive.tar.TarInputArchive;
import de.schlichtherle.io.archive.tar.TarOutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class TarBZip2Driver
extends TarDriver {
    private static final long serialVersionUID = 4966248471134003932L;
    private static final int BUFSIZE = 4096;
    public static final int DEFAULT_LEVEL = 9;
    private final int level;

    public TarBZip2Driver() {
        this("US-ASCII", null, null, 9);
    }

    public TarBZip2Driver(String string) {
        this(string, null, null, 9);
    }

    public TarBZip2Driver(int n) {
        this("US-ASCII", null, null, n);
    }

    public TarBZip2Driver(String string, int n) {
        this(string, null, null, n);
    }

    public TarBZip2Driver(String string, Icon icon, Icon icon2, int n) {
        super(string, icon, icon2);
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException();
        }
        this.level = n;
    }

    public final int getLevel() {
        return this.level;
    }

    protected InputStream createInputStream(Archive archive, ReadOnlyFile readOnlyFile) throws IOException {
        InputStream inputStream = super.createInputStream(archive, readOnlyFile);
        if (inputStream.read() != 66 || inputStream.read() != 90) {
            throw new IOException("Not a BZIP2 compressed input stream!");
        }
        byte[] byArray = new byte[2];
        InputStream inputStream2 = TarInputArchive.readAhead(inputStream, byArray);
        if (byArray[0] != 104 || byArray[1] < 49 || 57 < byArray[1]) {
            throw new IOException("Not a BZIP2 compressed input stream!");
        }
        return new CBZip2InputStream((InputStream)new BufferedInputStream(inputStream2, 4096));
    }

    protected TarOutputArchive createTarOutputArchive(Archive archive, OutputStream outputStream, TarInputArchive tarInputArchive) throws IOException {
        outputStream.write(new byte[]{66, 90});
        return super.createTarOutputArchive(archive, (OutputStream)new CBZip2OutputStream((OutputStream)new BufferedOutputStream(outputStream, 4096), this.level), tarInputArchive);
    }
}

