/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.crypto.modes;

import de.schlichtherle.crypto.SeekableBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class SICSeekableBlockCipher
implements SeekableBlockCipher {
    private final BlockCipher cipher;
    private final int blockSize;
    private final byte[] IV;
    private final byte[] counter;
    private long blockCounter;
    private final byte[] counterOut;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SICSeekableBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.blockSize = this.cipher.getBlockSize();
        this.IV = new byte[this.blockSize];
        this.counter = new byte[this.blockSize];
        this.counterOut = new byte[this.blockSize];
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byte[] byArray = parametersWithIV.getIV();
            System.arraycopy(byArray, 0, this.IV, 0, this.IV.length);
            this.reset();
            this.cipher.init(true, parametersWithIV.getParameters());
        }
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/SIC";
    }

    public int getBlockSize() {
        if (!$assertionsDisabled && this.blockSize != this.cipher.getBlockSize()) {
            throw new AssertionError();
        }
        return this.blockSize;
    }

    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        this.updateCounter();
        this.cipher.processBlock(this.counter, 0, this.counterOut, 0);
        int n3 = this.blockSize;
        while (--n3 >= 0) {
            byArray2[n2 + n3] = (byte)(this.counterOut[n3] ^ byArray[n + n3]);
        }
        ++this.blockCounter;
        return this.blockSize;
    }

    private final void updateCounter() {
        long l = this.blockCounter;
        int n = this.blockSize;
        while (--n >= 0) {
            this.counter[n] = (byte)(l += (long)(this.IV[n] & 0xFF));
            l >>>= 8;
        }
    }

    public void setBlockCounter(long l) {
        this.blockCounter = l;
    }

    public long getBlockCounter() {
        return this.blockCounter;
    }

    public void reset() {
        this.blockCounter = 0L;
        this.cipher.reset();
    }

    static {
        $assertionsDisabled = !SICSeekableBlockCipher.class.desiredAssertionStatus();
    }
}

