/*
* Copyright 2018-2020 elementary, Inc. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

public class OnlineAccounts.AccountMenuItem : Gtk.Button {
    public string custom_icon_name { get; construct; }
    public string primary_label { get; construct; }
    public string secondary_label { get; construct; }

    public AccountMenuItem (string custom_icon_name, string primary_label, string secondary_label) {
        Object (
            custom_icon_name: custom_icon_name,
            primary_label: primary_label,
            secondary_label: secondary_label
        );
    }

    construct {
        var label = new Gtk.Label (primary_label) {
            halign = Gtk.Align.START
        };
        label.add_css_class (Granite.STYLE_CLASS_H3_LABEL);

        var description = new Gtk.Label (secondary_label) {
            halign = Gtk.Align.START
        };
        description.add_css_class (Granite.STYLE_CLASS_SMALL_LABEL);

        var image = new Gtk.Image.from_icon_name (custom_icon_name);
        image.add_css_class (Granite.STYLE_CLASS_LARGE_ICONS);

        var grid = new Gtk.Grid () {
            column_spacing = 6
        };
        grid.attach (image, 0, 0, 1, 2);
        grid.attach (label, 1, 0);
        grid.attach (description, 1, 1);

        child = grid;
        add_css_class (Granite.STYLE_CLASS_MENUITEM);
    }
}
